/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.manageengine.ela.server.correlation.core.config.CorrConfigInfo;
import com.manageengine.ela.server.correlation.core.data.DataStore;
import com.manageengine.ela.server.correlation.core.data.SortedContainer;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FieldDataContainer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, Map<String, SortedContainer>> container;
    private final DataStore dataStore;
    private final Object identity;
    private final Lock sync = new ReentrantLock();
    private final long coldDataPeriod;
    private static final Logger LOGGER = Logger.getLogger(FieldDataContainer.class.getName());

    public FieldDataContainer(DataStore dataStore, Object identity, long coldDataPeriod) {
        this(dataStore, identity, (Set<String>)ImmutableSet.of((Object)CorrConfigInfo.DEFAULT_FIELD), coldDataPeriod);
    }

    public FieldDataContainer(DataStore dataStore, Object identity, Set<String> fields, long coldDataPeriod) {
        this.coldDataPeriod = coldDataPeriod;
        this.dataStore = Objects.requireNonNull(dataStore);
        this.identity = Objects.requireNonNull(identity);
        Map<String, Map<String, SortedContainer>> availableFieldMap = dataStore.initializeAndLoadAvailableDataFromStore(identity, fields);
        this.container = ImmutableMap.copyOf(availableFieldMap);
    }

    public void store(String key, String value, Long time, String docID) {
        SortedContainer dataContainer = this.getContainer(key, value);
        if (dataContainer != null) {
            dataContainer.store(time, docID);
        }
    }

    public void store(Long time, String docID) {
        SortedContainer dataContainer = this.getContainer();
        if (dataContainer != null) {
            dataContainer.store(time, docID);
        }
    }

    public SortedContainer getContainer() {
        return this.getContainer(CorrConfigInfo.DEFAULT_FIELD, CorrConfigInfo.DEFAULT_FIELD_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedContainer getContainer(String key, String value) {
        this.sync.lock();
        try {
            Map<String, SortedContainer> fieldSource = this.container.get(key);
            if (fieldSource == null) {
                SortedContainer sortedContainer = null;
                return sortedContainer;
            }
            SortedContainer dataContainer = fieldSource.get(value);
            if (dataContainer == null) {
                Lock lock = this.dataStore.getStoreSwapLock();
                lock.lock();
                try {
                    dataContainer = this.dataStore.getContainerFromExistingStore(this.identity, key, value, this.coldDataPeriod);
                }
                finally {
                    lock.unlock();
                }
                fieldSource.put(value, dataContainer);
            }
            SortedContainer sortedContainer = dataContainer;
            return sortedContainer;
        }
        finally {
            this.sync.unlock();
        }
    }

    public Map<String, Map<String, SortedContainer>> getDirectMap() {
        return this.container;
    }

    void removeColdDocInfo() {
        LOGGER.log(Level.INFO, "Total Fields for ruleID - {0}  {1}", new Object[]{this.identity, this.container.size()});
        this.container.forEach((field, fieldcon) -> fieldcon.forEach((fieldvalue, container) -> container.removeColdDocInfo()));
    }

    public String toString() {
        return "FieldDataContainer{container=" + this.container + '}';
    }
}

