/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.data;

import com.google.common.collect.ImmutableSet;
import com.manageengine.ela.server.correlation.core.data.DataStore;
import com.manageengine.ela.server.correlation.core.data.FieldDataContainer;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RuleContainer
implements Serializable {
    private static final long serialVersionUID = 12345L;
    private Map<Long, FieldDataContainer> action_container;
    private final Lock processingControl = new ReentrantLock(true);
    private final Lock sync = new ReentrantLock(true);
    private DataStore dataStore;
    private final Long id;
    private Set<Long> configuedActions = null;
    private AtomicBoolean initialize = new AtomicBoolean(false);
    private transient Runnable cleanupProcessor = null;
    private static final Logger LOGGER = Logger.getLogger(RuleContainer.class.getName());

    public Lock getLock() {
        return this.processingControl;
    }

    Runnable getCleanupProcessor() {
        if (this.cleanupProcessor != null) {
            return this.cleanupProcessor;
        }
        this.cleanupProcessor = () -> {
            long time = System.nanoTime();
            LOGGER.log(Level.INFO, "Cold data cleanup process started for ruleID : {0} ", this.getId());
            this.removeColdDocInfo();
            LOGGER.log(Level.INFO, "Time taken to complete cold data process for ruleID {0} : {1} ", new Object[]{this.getId(), System.nanoTime() - time});
        };
        return this.cleanupProcessor;
    }

    RuleContainer(Long ruleID, ScheduledExecutorService docDataCleane) {
        this.id = ruleID;
        this.action_container = new HashMap<Long, FieldDataContainer>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuleContainer initialize(Set<Long> confguredActions, Map<Long, Set<String>> fieldsInfo, Long totalPossibleTimeLimit, DataStore.StoreType storeType) {
        this.sync.lock();
        try {
            if (this.initialize.get()) {
                RuleContainer ruleContainer = this;
                return ruleContainer;
            }
            this.initialize.set(true);
            this.dataStore = DataStore.getDataStore(this.id, this.processingControl, totalPossibleTimeLimit, storeType);
            this.setConfiguedActions((Set<Long>)ImmutableSet.copyOf(confguredActions));
            for (Long configuredAction : confguredActions) {
                if (fieldsInfo != null && fieldsInfo.get(configuredAction) != null && !fieldsInfo.get(configuredAction).isEmpty()) {
                    this.action_container.put(configuredAction, new FieldDataContainer(this.dataStore, configuredAction, fieldsInfo.get(configuredAction), totalPossibleTimeLimit));
                    continue;
                }
                this.action_container.put(configuredAction, new FieldDataContainer(this.dataStore, configuredAction, totalPossibleTimeLimit));
            }
            RuleContainer ruleContainer = this;
            return ruleContainer;
        }
        finally {
            this.sync.unlock();
        }
    }

    public FieldDataContainer getFieldDataContainer(Long actionConfigID) {
        return this.action_container.get(actionConfigID);
    }

    public Map<Long, FieldDataContainer> getDirectMap() {
        return this.action_container;
    }

    public Set<Long> getConfiguedActions() {
        return this.configuedActions;
    }

    private void setConfiguedActions(Set<Long> configuedActions) {
        this.configuedActions = configuedActions;
    }

    public Long getId() {
        return this.id;
    }

    void removeColdDocInfo() {
        this.processingControl.lock();
        try {
            LOGGER.log(Level.INFO, "Total Actions for ruleID : {0}  {1}", new Object[]{this.getId(), this.action_container.size()});
            this.action_container.values().forEach(fieldContainer -> fieldContainer.removeColdDocInfo());
        }
        finally {
            this.processingControl.unlock();
        }
    }

    public String toString() {
        return this.action_container.toString();
    }

    public void flushLiveData() {
        this.dataStore.clearLiveData();
    }
}

