/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.data;

import com.manageengine.ela.server.correlation.core.config.CorrConfigInfo;
import com.manageengine.ela.server.correlation.core.data.DataMarker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SortedContainer
implements Serializable {
    private static final long serialVersionUID = 12345L;
    private static final Logger LOGGER = Logger.getLogger(SortedContainer.class.getName());
    private final Long cold_period;
    private final boolean isDuplicateContainer;
    private final DataMarker dataMarker;
    private final String uuid;
    private NavigableMap<Long, List<String>> data_container;
    private final AtomicLong clearedEntries = new AtomicLong(0L);
    private final AtomicBoolean cleanupStatus = new AtomicBoolean(false);

    public SortedContainer(Long cold_period, String uuid, NavigableMap<Long, List<String>> container) {
        this(cold_period, uuid, container, new DataMarker());
    }

    public SortedContainer(Long cold_period, String uuid, NavigableMap<Long, List<String>> container, DataMarker dataMarker) {
        this(container, uuid, cold_period, false, dataMarker);
    }

    private SortedContainer(NavigableMap<Long, List<String>> container, String uuid, Long coldPeriod, boolean isCustom, DataMarker dataMarker) {
        this.uuid = Objects.requireNonNull(uuid);
        this.data_container = Objects.requireNonNull(container);
        this.dataMarker = Objects.requireNonNull(dataMarker);
        this.cold_period = Objects.requireNonNull(coldPeriod);
        this.isDuplicateContainer = isCustom;
    }

    public static SortedContainer getCustomContainer(NavigableMap<Long, List<String>> data_container, boolean isDuplicateData) {
        return SortedContainer.getCustomContainer(data_container, isDuplicateData, new DataMarker());
    }

    public static SortedContainer getCustomContainer(NavigableMap<Long, List<String>> data_container, boolean isDuplicateData, DataMarker dataMarker) {
        return new SortedContainer(data_container, UUID.randomUUID().toString(), -1L, isDuplicateData, dataMarker);
    }

    void clearAllActions() {
        this.data_container.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCorrelatedActions(Long time, List<String> dataCopy) {
        Lock lock = this.dataMarker.getLock();
        lock.lock();
        try {
            List existing = (List)this.data_container.get(time);
            if (existing != null) {
                existing.removeAll(dataCopy);
                if (existing.isEmpty()) {
                    this.data_container.remove(time);
                } else {
                    this.data_container.put(time, existing);
                }
                this.clearedEntries.addAndGet(dataCopy.size());
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIfEmpty(Long time) {
        Lock lock = this.dataMarker.getLock();
        lock.lock();
        try {
            List docIDList = (List)this.data_container.get(time);
            if (docIDList != null && docIDList.isEmpty()) {
                this.data_container.remove(time);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void store(Long time, String docID) {
        Lock lock = this.dataMarker.getLock();
        lock.lock();
        try {
            ArrayList<String> docIDList = (ArrayList<String>)this.data_container.get(time);
            if (docIDList == null) {
                docIDList = new ArrayList<String>();
                this.data_container.put(time, docIDList);
            }
            docIDList.add(docID);
            if (this.dataMarker.isDelayedCommit()) {
                if (this.dataMarker.fetchDelayedCommitPoint() > time) {
                    this.dataMarker.setDelayedCommit(time);
                }
            } else if (this.dataMarker.getLastCommitPoint() > time) {
                this.dataMarker.setDelayedCommit(time);
            }
            this.data_container.put(time, docIDList);
        }
        finally {
            lock.unlock();
        }
    }

    public void store(NavigableMap<Long, List<String>> data) {
        this.data_container.putAll(data);
    }

    public void swapDataContainer(NavigableMap<Long, List<String>> updatedDataContainer) {
        Lock lock = this.dataMarker.getLock();
        lock.lock();
        try {
            this.data_container = Objects.requireNonNull(updatedDataContainer);
        }
        finally {
            lock.unlock();
        }
    }

    boolean removeColdDocInfo() {
        if (!this.isEmpty()) {
            try {
                long benchmark = System.currentTimeMillis() - (this.cold_period != null && this.cold_period > CorrConfigInfo.getDefaultColdPeriod() ? this.cold_period : CorrConfigInfo.getDefaultColdPeriod());
                LOGGER.log(Level.FINER, "Before cleanup startKey : {0}  EndKey: {1}  benchmark: {2}  ", new Object[]{this.firstKey(), this.lastKey(), benchmark});
                this.data_container.headMap(benchmark).forEach((key, value) -> {
                    this.data_container.remove(key);
                    this.clearedEntries.addAndGet(value.size());
                });
                LOGGER.log(Level.FINER, "After cleanup startKey : {0}  EndKey: {1}  benchmark: {2}  ", new Object[]{this.firstKey(), this.lastKey(), benchmark});
            }
            catch (Exception exp) {
                LOGGER.log(Level.INFO, "Error occurred during cold data cleanup {0}", exp.getMessage());
                return false;
            }
        } else {
            LOGGER.log(Level.FINER, "DocContainer {0} is empty. Skipped cold data cleanup.", this.uuid);
        }
        return true;
    }

    public Long firstKey() {
        if (!this.isEmpty()) {
            return (Long)this.data_container.firstKey();
        }
        return null;
    }

    public Long lastKey() {
        if (!this.isEmpty()) {
            return (Long)this.data_container.lastKey();
        }
        return null;
    }

    public Long ceilingKey(Long key) {
        return this.data_container.ceilingKey(key);
    }

    public Long floorKey(Long key) {
        return this.data_container.floorKey(key);
    }

    public boolean isEmpty() {
        return this.data_container.isEmpty();
    }

    public boolean containsKey(Long key) {
        return this.data_container.containsKey(key);
    }

    public List<String> get(Long key) {
        return (List)this.data_container.get(key);
    }

    public DataMarker getDataMarker() {
        return this.dataMarker;
    }

    public NavigableMap<Long, List<String>> getDirectMap() {
        return this.data_container;
    }

    public NavigableMap<Long, List<String>> subMap(Long start, Long end) {
        return this.data_container.subMap(start, true, end, true);
    }

    public NavigableMap<Long, List<String>> headMap(Long key, boolean inclusive) {
        return this.data_container.headMap(key, inclusive);
    }

    public NavigableMap<Long, List<String>> tailMap(Long key, boolean inclusive) {
        return this.data_container.tailMap(key, inclusive);
    }

    public NavigableMap<Long, List<String>> descendingMap() {
        return this.data_container.descendingMap();
    }

    public Collection<List<String>> getAllDocInfo() {
        return this.data_container.values();
    }

    public Set<Long> getAllTimeInterval() {
        return this.data_container.descendingKeySet();
    }

    public boolean isDuplicateContainer() {
        return this.isDuplicateContainer;
    }

    public String getUuid() {
        return this.uuid;
    }

    public Long getColdPeriod() {
        return this.cold_period;
    }

    public long getClearedEntries() {
        return this.clearedEntries.get();
    }

    public long getAndResetClearedEntries() {
        this.cleanupStatus.set(true);
        return this.clearedEntries.getAndSet(0L);
    }

    public boolean getCleanupStatus() {
        return this.cleanupStatus.get();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.data_container.forEach((timeStamp, docDataList) -> buffer.append(timeStamp).append("=>").append(docDataList));
        return buffer.toString();
    }
}

