/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.data.javaheap;

import com.manageengine.ela.server.common.io.file.FileHandler;
import com.manageengine.ela.server.correlation.core.config.CorrConfigInfo;
import com.manageengine.ela.server.correlation.core.data.DataStore;
import com.manageengine.ela.server.correlation.core.data.SortedContainer;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaHeapDataStoreImpl
implements DataStore {
    private final long coldDataPeriod;
    private final Long identity;
    private final Lock dataController;
    private static final String DUMP_FILENAME_FORMAT = "%d_JH.dmp";
    private static final Map<Long, Map<Object, Map<String, Map<String, NavigableMap<Long, List<String>>>>>> CORRELATION_DATACONTAINER;
    private Map<Object, Map<String, Map<String, NavigableMap<Long, List<String>>>>> ruleDocContainer;
    private static final Logger LOGGER;
    private final AtomicBoolean isDataAccessAllowed = new AtomicBoolean(true);

    public JavaHeapDataStoreImpl(Long identity, Lock controller, long coldDataPeriod) {
        this.coldDataPeriod = coldDataPeriod;
        this.identity = identity;
        this.dataController = controller;
        this.ruleDocContainer = this.createOrRestoreExistingData();
        CORRELATION_DATACONTAINER.put(identity, this.ruleDocContainer);
    }

    @Override
    public void flushDataFromLive() {
        this.isDataAccessAllowed.set(false);
        File file = new File(CorrConfigInfo.LIVE_FILE_PATH + File.separator + String.format(DUMP_FILENAME_FORMAT, this.identity));
        FileHandler.storeObjectInFIle(this.ruleDocContainer, file);
        this.ruleDocContainer = null;
        CORRELATION_DATACONTAINER.remove(this.identity);
    }

    @Override
    public void restoreDataFromDisk() {
        this.ruleDocContainer = this.createOrRestoreExistingData();
        CORRELATION_DATACONTAINER.put(this.identity, this.ruleDocContainer);
        this.isDataAccessAllowed.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Object, Map<String, Map<String, NavigableMap<Long, List<String>>>>> createOrRestoreExistingData() {
        File file = new File(CorrConfigInfo.LIVE_FILE_PATH + File.separator + String.format(DUMP_FILENAME_FORMAT, this.identity));
        if (file.exists()) {
            try {
                Object obj = FileHandler.readObjectFromFile(file);
                if (obj != null && obj instanceof Map) {
                    Map map = (Map)obj;
                    return map;
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            finally {
                FileHandler.deleteFile(file);
            }
        }
        return new ConcurrentHashMap<Object, Map<String, Map<String, NavigableMap<Long, List<String>>>>>();
    }

    @Override
    public Map<String, Map<String, SortedContainer>> initializeAndLoadAvailableDataFromStore(Object childIdentity, Set<String> fieldSet) {
        if (this.isDataAccessAllowed.get()) {
            Map<String, Map<String, NavigableMap<Long, List<String>>>> actionContainer = this.ruleDocContainer.get(childIdentity);
            if (actionContainer == null || actionContainer.isEmpty()) {
                actionContainer = new ConcurrentHashMap<String, Map<String, NavigableMap<Long, List<String>>>>();
                this.ruleDocContainer.put(childIdentity, actionContainer);
            }
            ConcurrentHashMap<String, Map<String, SortedContainer>> convertedContainer = new ConcurrentHashMap<String, Map<String, SortedContainer>>();
            for (String field : fieldSet) {
                ConcurrentHashMap convfieldSourceContainer = new ConcurrentHashMap();
                convertedContainer.put(field, convfieldSourceContainer);
                Map<String, NavigableMap<Long, List<String>>> fieldSourceContainer = actionContainer.get(field);
                if (fieldSourceContainer == null) {
                    fieldSourceContainer = new ConcurrentHashMap<String, NavigableMap<Long, List<String>>>();
                    actionContainer.put(field, fieldSourceContainer);
                    continue;
                }
                if (fieldSourceContainer.isEmpty()) continue;
                fieldSourceContainer.forEach((fieldSource, sortedContainer) -> convfieldSourceContainer.put(fieldSource, new SortedContainer(this.coldDataPeriod, (String)fieldSource, (NavigableMap<Long, List<String>>)sortedContainer)));
            }
            return convertedContainer;
        }
        throw new RuntimeException("Data access blocked in store");
    }

    @Override
    public void clearLiveData() {
        this.isDataAccessAllowed.set(false);
        this.ruleDocContainer = null;
        CORRELATION_DATACONTAINER.remove(this.identity);
    }

    @Override
    public Lock getStoreSwapLock() {
        return this.dataController;
    }

    @Override
    public SortedContainer getContainerFromExistingStore(Object identity, String key, String value, long coldDataPeriod) {
        Map<String, Map<String, NavigableMap<Long, List<String>>>> actionContainer = this.ruleDocContainer.get(identity);
        Map<String, NavigableMap<Long, List<String>>> fieldContainer = actionContainer.get(key);
        NavigableMap<Long, List<String>> fieldSourceContainer = fieldContainer.get(value);
        if (fieldSourceContainer == null) {
            fieldSourceContainer = new ConcurrentSkipListMap<Long, List<String>>();
            fieldContainer.put(value, fieldSourceContainer);
        }
        return new SortedContainer(coldDataPeriod, value, fieldSourceContainer);
    }

    static {
        LOGGER = Logger.getLogger(JavaHeapDataStoreImpl.class.getName());
        File directory = new File(CorrConfigInfo.LIVE_FILE_PATH);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        CORRELATION_DATACONTAINER = new ConcurrentHashMap<Long, Map<Object, Map<String, Map<String, NavigableMap<Long, List<String>>>>>>();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LOGGER.log(Level.INFO, "Shutdown hook received from JVM");
            ForkJoinPool customThreadPool = new ForkJoinPool(CorrConfigInfo.getDefault_mapdb_final_commit_threads());
            customThreadPool.execute(() -> CORRELATION_DATACONTAINER.entrySet().parallelStream().forEach(entry -> {
                File file = new File(CorrConfigInfo.LIVE_FILE_PATH + File.separator + String.format(DUMP_FILENAME_FORMAT, entry.getKey()));
                FileHandler.storeObjectInFIle(entry.getValue(), file);
            }));
            LOGGER.log(Level.INFO, "JAVAHeap commit request completed");
        }));
    }
}

