/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.data.mapdb;

import com.manageengine.ela.server.correlation.core.CorrelationRuleContainer;
import com.manageengine.ela.server.correlation.core.action.CorrelationAction;
import com.manageengine.ela.server.correlation.core.config.CorrConfigInfo;
import com.manageengine.ela.server.correlation.core.data.SortedContainer;
import com.manageengine.ela.server.correlation.core.data.mapdb.MapDBDataContainer;
import com.manageengine.ela.server.correlation.core.data.mapdb.MapDBUtil;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;

class MapDBCompactHandler {
    private static final Logger LOGGER = Logger.getLogger(MapDBCompactHandler.class.getName());
    private static final ScheduledExecutorService FILEOPTIMIZER;
    private static final Map<Long, MapDBDataContainer> OFFHEAP_FILES_FOR_COMPACT;
    private static final AtomicLong LASTCOMPACTTIME;

    MapDBCompactHandler() {
    }

    static void registerForCompact(Long ruleID, MapDBDataContainer db) {
        OFFHEAP_FILES_FOR_COMPACT.put(ruleID, db);
    }

    static void deRegisterForCompact(Long ruleID, MapDBDataContainer db) {
        OFFHEAP_FILES_FOR_COMPACT.remove(ruleID);
    }

    private static void optimizeFiles() {
        ForkJoinPool customThreadPool = new ForkJoinPool(CorrConfigInfo.getDefault_mapdb_compact_threads());
        long forceCompactLimit = CorrConfigInfo.getDefault_mapdb_force_compact_timeperiod();
        boolean isForceCompact = System.currentTimeMillis() - LASTCOMPACTTIME.get() > forceCompactLimit;
        Set<Map.Entry<Long, MapDBDataContainer>> entrySet = OFFHEAP_FILES_FOR_COMPACT.entrySet();
        customThreadPool.execute(() -> entrySet.parallelStream().forEach(entry -> {
            MapDBDataContainer dataStore = (MapDBDataContainer)entry.getValue();
            Lock lock = dataStore.getProcessingLock();
            lock.lock();
            try {
                MapDBCompactHandler.optimizeDataStore((Long)entry.getKey(), dataStore, isForceCompact);
            }
            finally {
                lock.unlock();
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void optimizeDataStore(Long ruleID, MapDBDataContainer dataStore, boolean isForceCompact) {
        Lock dataLock = dataStore.getStoreSwapLock();
        File file = new File(dataStore.getFilePath());
        if (!MapDBCompactHandler.checkCompactStatus(dataStore, file, isForceCompact)) {
            return;
        }
        long time = System.currentTimeMillis();
        LOGGER.log(Level.INFO, "Compact process started for ruleid - {0}", ruleID);
        Map<Long, CorrelationAction> actionContainer = CorrelationRuleContainer.getActionContainer(ruleID);
        actionContainer.values().forEach(action -> action.disableExecution());
        HashMap<String, NavigableMap> temp_memory_map = new HashMap<String, NavigableMap>();
        Map<String, SortedContainer> containers = dataStore.getRegisteredContainers();
        dataLock.lock();
        try {
            containers.forEach((uuid, container) -> {
                ConcurrentSkipListMap<Long, List<String>> tempFile = new ConcurrentSkipListMap<Long, List<String>>();
                container.swapDataContainer(tempFile);
                temp_memory_map.put((String)uuid, tempFile);
            });
            MapDBUtil.commitAndCompactMapDBStore(dataStore.getDatastore(), dataStore.getFilePath());
            File existingFile = new File(dataStore.getFilePath());
            File corrBackUPFIle = new File(CorrConfigInfo.BACKUP_FILE_PATH + existingFile.getName());
            if (MapDBUtil.checkAndResolveCorptn(existingFile, corrBackUPFIle)) {
                LOGGER.log(Level.INFO, "Compact process successfull for ruleid - {0}", ruleID);
                dataStore.changeStore(MapDBUtil.openMapDBFile(existingFile));
            } else {
                LOGGER.log(Level.INFO, "Compact process failed for ruleid - {0}", ruleID);
                String filePath = CorrConfigInfo.LIVE_FILE_PATH + MapDBUtil.getFormattedFileName(ruleID);
                dataStore.changeFilePath(filePath);
                dataStore.changeStore(MapDBUtil.createMapDB(new File(filePath)));
            }
            temp_memory_map.forEach((uuid, tempMap) -> {
                SortedContainer sortedContainer = (SortedContainer)containers.get(uuid);
                sortedContainer.swapDataContainer(dataStore.getMapFromDB((String)uuid));
            });
        }
        finally {
            dataLock.unlock();
        }
        temp_memory_map.forEach((uuid, tempMap) -> {
            SortedContainer sortedContainer = (SortedContainer)containers.get(uuid);
            sortedContainer.store((NavigableMap<Long, List<String>>)tempMap);
        });
        containers.values().forEach(container -> container.getAndResetClearedEntries());
        actionContainer.values().forEach(action -> action.enableExecution());
        LOGGER.log(Level.INFO, "Compact process completed for ruleid - {0}, Time taken  {1}, Filelength {2}", new Object[]{ruleID, System.currentTimeMillis() - time, new File(dataStore.getFilePath()).length()});
    }

    private static boolean checkCompactStatus(MapDBDataContainer dataStore, File file, boolean isForceCompact) {
        if (!file.exists()) {
            LOGGER.log(Level.INFO, "Compact request rejected for ruleid - {0}, File not found", dataStore.getIdentity());
            return false;
        }
        if (isForceCompact) {
            LOGGER.log(Level.INFO, "Force Compact process request approved for ruleid - {0}", dataStore.getIdentity());
            return true;
        }
        long maxStorageLimit = CorrConfigInfo.getDefault_mapdb_compact_limit();
        long minEntries = CorrConfigInfo.getDefault_mapdb_compact_min_entries();
        AtomicLong entriesRemoved = new AtomicLong(0L);
        Map<String, SortedContainer> containers = dataStore.getRegisteredContainers();
        AtomicBoolean cleanupStatus = new AtomicBoolean(true);
        containers.values().forEach(container -> {
            cleanupStatus.set(cleanupStatus.get() || !container.getCleanupStatus());
            entriesRemoved.addAndGet(container.getClearedEntries());
        });
        if (maxStorageLimit < file.length() && cleanupStatus.get() || minEntries < entriesRemoved.get()) {
            LOGGER.log(Level.INFO, "Compact request approved for ruleid - {0}, filelength {1}, clearedentries {2}", new Object[]{dataStore.getIdentity(), file.length(), entriesRemoved.get()});
            return true;
        }
        LOGGER.log(Level.INFO, "Compact request rejected for ruleid - {0}, filelength {1}, clearedentries {2} - No valid condition found", new Object[]{dataStore.getIdentity(), file.length(), entriesRemoved.get()});
        return false;
    }

    static {
        OFFHEAP_FILES_FOR_COMPACT = new ConcurrentHashMap<Long, MapDBDataContainer>();
        LASTCOMPACTTIME = new AtomicLong(System.currentTimeMillis());
        FILEOPTIMIZER = new ScheduledThreadPoolExecutor(1){

            @Override
            protected void beforeExecute(Thread paramThread, Runnable paramRunnable) {
                paramThread.setName("correlation[cache][optimization]");
                super.beforeExecute(paramThread, paramRunnable);
            }
        };
        FILEOPTIMIZER.scheduleWithFixedDelay(() -> {
            MapDBCompactHandler.optimizeFiles();
            LASTCOMPACTTIME.set(System.currentTimeMillis());
        }, 0L, CorrConfigInfo.getDefault_mapdb_compact_timeperiod(), TimeUnit.MILLISECONDS);
    }
}

