/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.data.mapdb;

import com.manageengine.ela.server.correlation.core.data.SortedContainer;
import com.manageengine.ela.server.correlation.core.data.mapdb.MapDBUtil;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.mapdb.DB;
import org.mapdb.Serializer;

class MapDBDataContainer {
    private String filePath;
    private DB datastore;
    private final Object identity;
    private final Map<String, SortedContainer> registeredSubContainers = new HashMap<String, SortedContainer>();
    private final Lock storeSwapLock = new ReentrantLock(true);
    private final Lock processingControl;

    public MapDBDataContainer(Object identity, DB datastore, String filepath, Lock processingControl) {
        this.datastore = Objects.requireNonNull(datastore);
        this.filePath = Objects.requireNonNull(filepath);
        this.identity = Objects.requireNonNull(identity);
        this.processingControl = Objects.requireNonNull(processingControl);
    }

    public DB getDatastore() {
        return this.datastore;
    }

    public String getFilePath() {
        return this.filePath;
    }

    void changeStore(DB datastore) {
        this.datastore = Objects.requireNonNull(datastore);
    }

    void changeFilePath(String filePath) {
        this.filePath = Objects.requireNonNull(filePath);
    }

    Map<String, SortedContainer> getRegisteredContainers() {
        return this.registeredSubContainers;
    }

    void clearRegisteredContainers() {
        this.registeredSubContainers.clear();
    }

    public SortedContainer getContainerFromDB(Object identity, String field, String fieldvalue, Long coldDataPeriod) {
        String containerID = MapDBUtil.getFormattedContainerID(identity.toString(), field, fieldvalue);
        return this.getContainerFromDB(containerID, coldDataPeriod);
    }

    public SortedContainer getContainerFromDB(String containerID, Long coldDataPeriod) {
        ConcurrentNavigableMap<Long, List<String>> offHeapMap = this.getMapFromDB(containerID);
        SortedContainer sortedContainer = new SortedContainer(coldDataPeriod, containerID, offHeapMap);
        this.registeredSubContainers.put(containerID, sortedContainer);
        return sortedContainer;
    }

    public ConcurrentNavigableMap<Long, List<String>> getMapFromDB(String containerID) {
        return this.datastore.treeMap(containerID).counterEnable().valuesOutsideNodesEnable().keySerializer(Serializer.LONG).valueSerializer(Serializer.ELSA).createOrOpen();
    }

    public List<String> getavailableFieldList() {
        LinkedList<String> dataList = new LinkedList<String>();
        this.datastore.getAllNames().forEach(dataList::add);
        return dataList;
    }

    public Lock getStoreSwapLock() {
        return this.storeSwapLock;
    }

    public Object getIdentity() {
        return this.identity;
    }

    public Lock getProcessingLock() {
        return this.processingControl;
    }
}

