/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.data.mapdb;

import com.manageengine.ela.server.correlation.core.data.DataStore;
import com.manageengine.ela.server.correlation.core.data.SortedContainer;
import com.manageengine.ela.server.correlation.core.data.mapdb.MapDBDataContainer;
import com.manageengine.ela.server.correlation.core.data.mapdb.MapDBHandler;
import com.manageengine.ela.server.correlation.core.data.mapdb.MapDBUtil;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MapDBDataStore
implements DataStore {
    private final MapDBDataContainer dataContainer;
    private final long coldDataPeriod;
    private final Long identity;
    private final AtomicBoolean isDataAccessAllowed = new AtomicBoolean(true);
    private static final Logger LOGGER = Logger.getLogger(MapDBDataStore.class.getName());

    public MapDBDataStore(Long identity, Lock dataController, long coldDataPeriod) {
        this.coldDataPeriod = coldDataPeriod;
        this.identity = identity;
        this.dataContainer = MapDBHandler.createNewMapDBStore(identity, dataController);
    }

    @Override
    public Map<String, Map<String, SortedContainer>> initializeAndLoadAvailableDataFromStore(Object childIdentity, Set<String> fieldSet) {
        if (this.isDataAccessAllowed.get()) {
            List<String> availableMapContainers = this.dataContainer.getavailableFieldList();
            ConcurrentHashMap<String, Map<String, SortedContainer>> convertedContainer = new ConcurrentHashMap<String, Map<String, SortedContainer>>();
            if (availableMapContainers.size() == 0) {
                fieldSet.forEach(field -> {
                    Map cfr_ignored_0 = convertedContainer.put((String)field, new ConcurrentHashMap());
                });
            } else {
                Map<String, Map<String, String>> existingContainers = MapDBUtil.getMatchingMAPContainer(availableMapContainers, childIdentity, fieldSet);
                if (existingContainers != null && existingContainers.size() > 0) {
                    fieldSet.forEach(field -> {
                        ConcurrentHashMap fieldSourceContainer = new ConcurrentHashMap();
                        convertedContainer.put((String)field, fieldSourceContainer);
                        Map fieldMapping = (Map)existingContainers.get(field);
                        fieldMapping.forEach((fieldSource, containerID) -> fieldSourceContainer.put(fieldSource, this.dataContainer.getContainerFromDB((String)containerID, this.coldDataPeriod)));
                    });
                } else {
                    fieldSet.forEach(field -> {
                        Map cfr_ignored_0 = convertedContainer.put((String)field, new ConcurrentHashMap());
                    });
                }
            }
            return convertedContainer;
        }
        throw new RuntimeException("Data access blocked in store");
    }

    @Override
    public void clearLiveData() {
        this.isDataAccessAllowed.set(false);
        MapDBHandler.deleteRuleCache(this.identity);
    }

    @Override
    public Lock getStoreSwapLock() {
        return this.dataContainer.getStoreSwapLock();
    }

    @Override
    public SortedContainer getContainerFromExistingStore(Object identity, String key, String value, long coldDataPeriod) {
        return this.dataContainer.getContainerFromDB(identity, key, value, coldDataPeriod);
    }

    @Override
    public void flushDataFromLive() {
        this.isDataAccessAllowed.set(false);
        MapDBUtil.commitAndCloseMapDBStore(this.dataContainer.getDatastore());
    }

    @Override
    public void restoreDataFromDisk() {
        this.dataContainer.changeStore(MapDBUtil.openMapDBFile(new File(this.dataContainer.getFilePath())));
        this.isDataAccessAllowed.set(true);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LOGGER.log(Level.INFO, "Shutdown hook received from JVM");
            MapDBHandler.commitAndCloseAll();
            LOGGER.log(Level.INFO, "MAPDB commit request completed");
        }));
    }
}

