/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.data.mapdb;

import com.manageengine.ela.server.correlation.core.config.CorrConfigInfo;
import com.manageengine.ela.server.correlation.core.data.mapdb.MapDBCompactHandler;
import com.manageengine.ela.server.correlation.core.data.mapdb.MapDBDataContainer;
import com.manageengine.ela.server.correlation.core.data.mapdb.MapDBUtil;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.mapdb.DB;

class MapDBHandler {
    private static final Map<Long, MapDBDataContainer> MAPDB_DATASTORE;
    private static final Logger LOGGER;

    MapDBHandler() {
    }

    public static MapDBDataContainer createNewMapDBStore(Long ruleID, Lock processingControl) {
        DB mapDB;
        String fileName2;
        File directory = new File(CorrConfigInfo.LIVE_FILE_PATH);
        String expctdFileName = ruleID + "_";
        File[] files = directory.listFiles((file, fileName) -> fileName.startsWith(expctdFileName));
        if (files != null && files.length == 0) {
            fileName2 = CorrConfigInfo.LIVE_FILE_PATH + MapDBUtil.getFormattedFileName(ruleID);
            mapDB = MapDBUtil.createMapDB(new File(fileName2));
        } else {
            String temp_File = MapDBHandler.getValidFileFromList(files);
            File existingFile = new File(temp_File);
            File corrBackUPFIle = new File(CorrConfigInfo.BACKUP_FILE_PATH + existingFile.getName());
            LOGGER.log(Level.FINER, "Loading mapdb store from existing file");
            if (MapDBUtil.checkAndResolveCorptn(existingFile, corrBackUPFIle)) {
                fileName2 = temp_File;
                mapDB = MapDBUtil.openMapDBFile(existingFile);
            } else {
                LOGGER.log(Level.INFO, "Unable to load mapDBFile, file may be corrupted - creating new file");
                fileName2 = CorrConfigInfo.LIVE_FILE_PATH + MapDBUtil.getFormattedFileName(ruleID);
                mapDB = MapDBUtil.createMapDB(new File(fileName2));
            }
        }
        MapDBDataContainer mapDBStore = new MapDBDataContainer(ruleID, mapDB, fileName2, processingControl);
        MapDBCompactHandler.registerForCompact(ruleID, mapDBStore);
        MAPDB_DATASTORE.put(ruleID, mapDBStore);
        return mapDBStore;
    }

    private static String getValidFileFromList(File[] files) {
        File selcFile = files[0];
        if (files.length == 1) {
            return selcFile.getAbsolutePath();
        }
        long timeFromName = 0L;
        for (File file : files) {
            String[] array = FilenameUtils.getName((String)file.getName()).split("_");
            if (array.length != 2) continue;
            try {
                long temp_time = Long.valueOf(FilenameUtils.removeExtension((String)array[1]));
                if (temp_time <= timeFromName) continue;
                timeFromName = temp_time;
                selcFile = file;
            }
            catch (Exception exp) {
                // empty catch block
            }
        }
        return selcFile.getAbsolutePath();
    }

    public static MapDBDataContainer getMapDBStore(Long ruleID) {
        return MAPDB_DATASTORE.get(ruleID);
    }

    public static void commitAndCloseAll() {
        ForkJoinPool customThreadPool = new ForkJoinPool(CorrConfigInfo.getDefault_mapdb_final_commit_threads());
        Collection<MapDBDataContainer> offHeapStores = MAPDB_DATASTORE.values();
        customThreadPool.execute(() -> offHeapStores.parallelStream().forEach(offHeapStore -> MapDBUtil.commitAndCloseMapDBStore(offHeapStore.getDatastore())));
    }

    public static void deleteRuleCache(Long ruleID) {
        MapDBDataContainer toBeRemoved = MAPDB_DATASTORE.remove(ruleID);
        MapDBCompactHandler.deRegisterForCompact(ruleID, toBeRemoved);
        MapDBUtil.deleteMapDBStore(toBeRemoved.getDatastore(), new File(toBeRemoved.getFilePath()));
    }

    static {
        LOGGER = Logger.getLogger(MapDBHandler.class.getName());
        MAPDB_DATASTORE = new ConcurrentHashMap<Long, MapDBDataContainer>();
        File directory = new File(CorrConfigInfo.LIVE_FILE_PATH);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        if (!(directory = new File(CorrConfigInfo.BACKUP_FILE_PATH)).exists()) {
            directory.mkdirs();
        }
    }
}

