/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.data.mapdb;

import com.manageengine.ela.server.common.cache.ServerDetailsBean;
import com.manageengine.ela.server.common.io.file.FileHandler;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mapdb.DB;
import org.mapdb.DBException;
import org.mapdb.DBMaker;

class MapDBUtil {
    private static final Logger LOGGER = Logger.getLogger(MapDBUtil.class.getName());
    private static final String LIVE_FILENAME_FORMAT = "%d_%d_MDB.dmp";
    private static final String MAP_NAME_FORMAT = "%s_PRE_%s_PRE_%s";

    MapDBUtil() {
    }

    public static void commitAndCompactMapDBStore(DB store, String file) {
        DB currentDataStore = store;
        if (ServerDetailsBean.getInstance().is64BitMachine()) {
            currentDataStore.commit();
            currentDataStore.close();
            DB temp_forCompact = DBMaker.fileDB((String)file).make();
            temp_forCompact.getStore().compact();
            temp_forCompact.close();
        } else {
            currentDataStore.commit();
            currentDataStore.getStore().compact();
            currentDataStore.close();
        }
    }

    public static void commitAndCloseMapDBStore(DB currentDataStore) {
        currentDataStore.commit();
        currentDataStore.close();
    }

    public static void deleteMapDBStore(DB dataStore, File file) {
        if (dataStore != null) {
            dataStore.close();
        }
        if (!file.delete()) {
            LOGGER.log(Level.INFO, "Could not delete off-heap store {0}", file);
            file.deleteOnExit();
        }
    }

    public static DB createMapDB(File requestedFile) {
        if (requestedFile.exists()) {
            return null;
        }
        return MapDBUtil.createOrOpenMapDBFile(requestedFile);
    }

    public static DB openMapDBFile(File requestedFile) {
        if (!requestedFile.exists()) {
            return null;
        }
        return MapDBUtil.createOrOpenMapDBFile(requestedFile);
    }

    public static boolean checkAndResolveCorptn(File currentFile, File crrpFIleBack) {
        if (!MapDBUtil.checkMapDBConsistency(currentFile)) {
            if (!FileHandler.renameFile(currentFile, crrpFIleBack)) {
                LOGGER.log(Level.INFO, "Cant move corrupted MapDB Store {0} to {1}", new Object[]{currentFile, crrpFIleBack});
                currentFile.deleteOnExit();
            }
            if (currentFile.exists()) {
                return false;
            }
        }
        return true;
    }

    public static DB createOrOpenMapDBFile(File file) {
        if (ServerDetailsBean.getInstance().is64BitMachine()) {
            return DBMaker.fileDB((File)file).fileMmapEnable().cleanerHackEnable().make();
        }
        return DBMaker.fileDB((File)file).make();
    }

    private static boolean checkMapDBConsistency(File store) {
        try {
            DBMaker.fileDB((File)store).fileLockDisable().make().close();
            return true;
        }
        catch (DBException.DataCorruption exception) {
            LOGGER.log(Level.WARNING, "MapDB header checksum broken. Wasn't closed properly.");
            return MapDBUtil.recoverFromCorruption(store);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Error occurred during MapDB init", exception.getMessage());
            return false;
        }
    }

    private static boolean recoverFromCorruption(File store) {
        try {
            DB mapDB = DBMaker.fileDB((File)store).fileLockDisable().checksumHeaderBypass().make();
            mapDB.commit();
            mapDB.close();
            LOGGER.log(Level.INFO, "MapDB closed successfully.");
            return true;
        }
        catch (Exception exp) {
            return false;
        }
    }

    public static Map<String, Map<String, String>> getMatchingMAPContainer(List<String> availableMapFieldsInStore, Object identity, Set<String> fieldSet) {
        HashMap<String, Map<String, String>> temp_map = new HashMap<String, Map<String, String>>();
        fieldSet.forEach(field -> {
            HashMap<String, String> fieldContainer = new HashMap<String, String>();
            temp_map.put((String)field, (Map<String, String>)fieldContainer);
            String compPrefix = String.format(MAP_NAME_FORMAT, String.valueOf(identity), field, "");
            Iterator itr = availableMapFieldsInStore.iterator();
            while (itr.hasNext()) {
                String mapIdentity = (String)itr.next();
                if (!mapIdentity.startsWith(compPrefix)) continue;
                String fieldValue = mapIdentity.split(compPrefix)[1];
                fieldContainer.put(fieldValue, mapIdentity);
                itr.remove();
            }
        });
        return temp_map;
    }

    public static String getFormattedContainerID(String identity, String field, String fieldvalue) {
        return String.format(MAP_NAME_FORMAT, identity, field, fieldvalue);
    }

    public static String getFormattedFileName(Long ruleID) {
        return String.format(LIVE_FILENAME_FORMAT, ruleID, System.currentTimeMillis());
    }
}

