/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.dispatcher;

import com.adventnet.persistence.DataObject;
import com.manageengine.ela.server.common.executors.processor.ConcurrentQueueProcessor;
import com.manageengine.ela.server.common.executors.queue.ConcurrentQueue;
import com.manageengine.ela.server.correlation.core.batchprocess.DOBatchProcessor;
import com.manageengine.ela.server.correlation.core.executors.CorrelationActionExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;

class ResultDispatcher
extends ConcurrentQueueProcessor<DataObject> {
    private DOBatchProcessor batchprocessor;
    private static final Logger LOGGER = Logger.getLogger(CorrelationActionExecutor.class.getName());

    public ResultDispatcher(ConcurrentQueue<DataObject> queue) throws IllegalArgumentException {
        super(queue);
        try {
            this.batchprocessor = DOBatchProcessor.create();
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    @Override
    public void postInvoke() {
        this.batchprocessor.shutdown();
        super.postInvoke();
    }

    @Override
    public void process(DataObject data) throws Exception {
        try {
            this.batchprocessor.insert(data);
        }
        catch (Exception exp) {
            LOGGER.log(Level.FINER, "Exception during result process {0}", exp.getMessage());
        }
    }
}

