/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.dispatcher;

import com.adventnet.persistence.DataObject;
import com.manageengine.ela.server.common.executors.processor.ProcessorPoolExecutor;
import com.manageengine.ela.server.common.executors.processor.ProcessorPoolExecutorImpl;
import com.manageengine.ela.server.common.executors.queue.CommonQueueImpl;
import com.manageengine.ela.server.common.executors.queue.ConcurrentQueue;
import com.manageengine.ela.server.correlation.core.config.CorrConfigInfo;
import com.manageengine.ela.server.correlation.core.dispatcher.ResultDispatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResultInflowManager {
    private static final List<ProcessorPoolExecutor> EXECUTORS = new ArrayList<ProcessorPoolExecutor>();
    private static final ConcurrentQueue<DataObject> QUEUE;
    private static final Logger LOGGER;
    private static final int MAX_QUEUE_SIZE;
    private static final int MAX_PROCESSOR_SIZE;
    private static final ScheduledExecutorService INFLOWMANAGER;

    public static void put(DataObject request) {
        try {
            QUEUE.put(request);
        }
        catch (Exception exp) {
            LOGGER.log(Level.FINER, "", exp);
        }
    }

    private static void adjustProcessors() {
        int size = QUEUE.size();
        if (size >= MAX_QUEUE_SIZE / 2) {
            ResultInflowManager.addNewProcessor();
        } else if (size < MAX_QUEUE_SIZE / 10) {
            ResultInflowManager.stopProcessor();
        }
    }

    private static void addNewProcessor() {
        if (MAX_PROCESSOR_SIZE > EXECUTORS.size()) {
            ResultDispatcher processor = new ResultDispatcher(QUEUE);
            ProcessorPoolExecutorImpl<DataObject> executor = new ProcessorPoolExecutorImpl<DataObject>(processor, "correlation[dispatcher]", 1);
            try {
                executor.addProcessor();
                EXECUTORS.add(executor);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private static void stopProcessor() {
        int totalExecutors = EXECUTORS.size();
        if (totalExecutors > 1) {
            try {
                EXECUTORS.get(totalExecutors - 1).forceShutdown();
                EXECUTORS.remove(totalExecutors - 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static {
        LOGGER = Logger.getLogger(ResultInflowManager.class.getName());
        MAX_QUEUE_SIZE = CorrConfigInfo.getResult_dispatcher_max_queuesize();
        MAX_PROCESSOR_SIZE = CorrConfigInfo.getResult_dispatcher_max_processors();
        INFLOWMANAGER = new ScheduledThreadPoolExecutor(1){

            @Override
            protected void beforeExecute(Thread paramThread, Runnable paramRunnable) {
                paramThread.setName("correlation[dispatcher][monitor]");
                super.beforeExecute(paramThread, paramRunnable);
            }
        };
        INFLOWMANAGER.scheduleWithFixedDelay(() -> ResultInflowManager.adjustProcessors(), 5L, 5L, TimeUnit.SECONDS);
        QUEUE = new CommonQueueImpl<DataObject>(MAX_QUEUE_SIZE);
        ResultInflowManager.addNewProcessor();
    }
}

