/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.dispatcher;

import com.adventnet.persistence.DataObject;
import com.manageengine.ela.server.common.executors.processor.ProcessorPoolExecutorImpl;
import com.manageengine.ela.server.common.executors.queue.CommonQueueImpl;
import com.manageengine.ela.server.common.executors.queue.ConcurrentQueue;
import com.manageengine.ela.server.correlation.core.config.CorrConfigInfo;
import com.manageengine.ela.server.correlation.core.dispatcher.ResultDispatcher;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SequentialResultInflowManager {
    private static final ConcurrentQueue<DataObject> SEQUENTIAL_QUEUE;
    private static final Logger LOGGER;
    private static final int MAX_QUEUE_SIZE;

    public static void put(DataObject request) {
        try {
            SEQUENTIAL_QUEUE.put(request);
        }
        catch (Exception exp) {
            LOGGER.log(Level.FINER, "Error occurred during dataObject processing {0}", exp);
        }
    }

    static {
        LOGGER = Logger.getLogger(SequentialResultInflowManager.class.getName());
        MAX_QUEUE_SIZE = CorrConfigInfo.getResult_dispatcher_max_queuesize();
        SEQUENTIAL_QUEUE = new CommonQueueImpl<DataObject>(MAX_QUEUE_SIZE);
        ResultDispatcher processor = new ResultDispatcher(SEQUENTIAL_QUEUE);
        ProcessorPoolExecutorImpl<DataObject> executor = new ProcessorPoolExecutorImpl<DataObject>(processor, "correlation[sequential-dispatcher]", 1);
        try {
            executor.addProcessor();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

