/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.executors;

import com.manageengine.ela.server.common.executors.processor.CommonQueueProcessor;
import com.manageengine.ela.server.common.executors.processor.ProcessorPoolExecutor;
import com.manageengine.ela.server.common.executors.processor.ProcessorPoolExecutorImpl;
import com.manageengine.ela.server.common.executors.queue.CommonQueueImpl;
import com.manageengine.ela.server.common.executors.queue.ConcurrentQueue;
import com.manageengine.ela.server.correlation.core.config.CorrConfigInfo;
import com.manageengine.ela.server.correlation.core.constants.ExecutorStatus;
import com.manageengine.ela.server.correlation.core.executors.CorrelationExecutor;
import com.manageengine.ela.server.correlation.core.executors.ProcessInflowManager;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CorrelationActionExecutor
extends CommonQueueProcessor<CorrelationExecutor> {
    private static final ProcessorPoolExecutor EXECUTOR;
    private static final ProcessInflowManager<CorrelationExecutor> INFLOW_HANDLER;
    private static final Logger LOGGER;
    private static final ConcurrentQueue<CorrelationExecutor> QUEUE;

    public CorrelationActionExecutor(ConcurrentQueue<CorrelationExecutor> queue) throws IllegalArgumentException {
        super(queue);
    }

    @Override
    protected CorrelationExecutor getData() throws InterruptedException {
        return QUEUE.get();
    }

    @Override
    public void process(CorrelationExecutor data) throws Exception {
        data.setStatus(ExecutorStatus.STARTED);
        try {
            data.execute();
        }
        catch (Exception exp) {
            LOGGER.log(Level.FINER, "Unable to process action", exp);
        }
        finally {
            data.setStatus(ExecutorStatus.IDLE);
        }
    }

    public static void add(CorrelationExecutor request) {
        INFLOW_HANDLER.add(request);
    }

    public static void put(CorrelationExecutor request) {
        INFLOW_HANDLER.put(request);
    }

    public static ConcurrentQueue<CorrelationExecutor> getQueue() {
        return QUEUE;
    }

    static {
        LOGGER = Logger.getLogger(CorrelationActionExecutor.class.getName());
        QUEUE = new CommonQueueImpl<CorrelationExecutor>(CorrConfigInfo.getDefault_action_processor_queuesize());
        int maxThreads = CorrConfigInfo.getDefault_max_action_processors();
        CorrelationActionExecutor processor = new CorrelationActionExecutor(QUEUE);
        EXECUTOR = new ProcessorPoolExecutorImpl<CorrelationExecutor>(processor, "correlation[action][processor]", maxThreads);
        INFLOW_HANDLER = new ProcessInflowManager<CorrelationExecutor>(QUEUE, false);
        for (int index = 0; index < maxThreads; ++index) {
            try {
                EXECUTOR.addProcessor();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

