/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.executors;

import com.manageengine.ela.server.common.executors.processor.CommonQueueProcessor;
import com.manageengine.ela.server.common.executors.processor.ProcessorPoolExecutor;
import com.manageengine.ela.server.common.executors.processor.ProcessorPoolExecutorImpl;
import com.manageengine.ela.server.common.executors.processor.extended.CommonTimerTask;
import com.manageengine.ela.server.common.executors.queue.CommonQueueImpl;
import com.manageengine.ela.server.common.executors.queue.ConcurrentQueue;
import com.manageengine.ela.server.correlation.core.config.CorrConfigInfo;
import com.manageengine.ela.server.correlation.core.constants.ExecutorStatus;
import com.manageengine.ela.server.correlation.core.executors.CorrelationExecutor;
import com.manageengine.ela.server.correlation.core.executors.ProcessInflowManager;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CorrelationRuleExecutor
extends CommonQueueProcessor<CorrelationExecutor> {
    private static final ProcessorPoolExecutor EXECUTOR;
    private static final ProcessInflowManager<CorrelationExecutor> INFLOW_HANDLER;
    private static final Logger LOGGER;
    private static final ConcurrentQueue<CorrelationExecutor> QUEUE;
    private static final long RULE_TIMEOUT;

    private CorrelationRuleExecutor(ConcurrentQueue<CorrelationExecutor> queue) throws IllegalArgumentException {
        super(queue);
    }

    @Override
    protected CorrelationExecutor getData() throws InterruptedException {
        return QUEUE.get();
    }

    @Override
    public void process(CorrelationExecutor data) throws Exception {
        data.setStatus(ExecutorStatus.STARTED);
        try {
            CommonTimerTask.execute(() -> {
                data.execute();
                return 0;
            }, RULE_TIMEOUT);
        }
        catch (ExecutionException | TimeoutException exp) {
            LOGGER.log(Level.INFO, "Rule process intrupted rule id- {0}", data.getIdentity());
            exp.printStackTrace();
        }
        catch (Exception exp) {
            LOGGER.log(Level.FINER, "Unable to process rule", exp);
        }
        finally {
            data.setStatus(ExecutorStatus.COMPLETED);
        }
    }

    public static void add(CorrelationExecutor request) {
        INFLOW_HANDLER.add(request);
    }

    public static ConcurrentQueue<CorrelationExecutor> getQueue() {
        return QUEUE;
    }

    static {
        LOGGER = Logger.getLogger(CorrelationRuleExecutor.class.getName());
        QUEUE = new CommonQueueImpl<CorrelationExecutor>(new LinkedBlockingQueue());
        RULE_TIMEOUT = CorrConfigInfo.getRule_processor_timeout();
        CorrelationRuleExecutor processor = new CorrelationRuleExecutor(QUEUE);
        int maxThreads = CorrConfigInfo.getDefault_max_rule_processors();
        EXECUTOR = new ProcessorPoolExecutorImpl<CorrelationExecutor>(processor, "correlation[rule][processor]", maxThreads);
        INFLOW_HANDLER = new ProcessInflowManager<CorrelationExecutor>(QUEUE, true);
        for (int index = 0; index < maxThreads; ++index) {
            try {
                EXECUTOR.addProcessor();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

