/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.executors;

import com.manageengine.ela.server.common.executors.queue.CommonQueue;
import com.manageengine.ela.server.correlation.core.config.CorrConfigInfo;
import com.manageengine.ela.server.correlation.core.constants.ExecutorStatus;
import com.manageengine.ela.server.correlation.core.executors.CorrelationExecutor;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcessInflowManager<T extends CorrelationExecutor>
implements CommonQueue<T> {
    private final Lock inflowLock = new ReentrantLock(true);
    private ConcurrentHashMap<T, Boolean> bsy_state_request = null;
    private ScheduledExecutorService bsy_status_request_handler = null;
    private boolean bsyStateHandling = false;
    private final CommonQueue<T> queue;
    private static final Logger LOGGER = Logger.getLogger(ProcessInflowManager.class.getName());

    public ProcessInflowManager(CommonQueue<T> queue, boolean handleBsyState) {
        this.queue = Objects.requireNonNull(queue);
        this.bsyStateHandling = handleBsyState;
        if (this.bsyStateHandling) {
            this.initBsyStateHandlers();
        }
    }

    private void initBsyStateHandlers() {
        this.bsy_state_request = new ConcurrentHashMap();
        this.bsy_status_request_handler = new ScheduledThreadPoolExecutor(1){

            @Override
            protected void beforeExecute(Thread paramThread, Runnable paramRunnable) {
                paramThread.setName("correlation[inflow][busy]");
                super.beforeExecute(paramThread, paramRunnable);
            }
        };
        this.bsy_status_request_handler.scheduleWithFixedDelay(() -> {
            this.inflowLock.lock();
            try {
                LOGGER.log(Level.FINER, "Busy request processor initiator : {0} ", this.bsy_state_request);
                ((ConcurrentHashMap.KeySetView)this.bsy_state_request.keySet()).forEach(request -> this.addWithBsyHandling(request, false));
            }
            finally {
                this.inflowLock.unlock();
            }
        }, CorrConfigInfo.getDefaultProcessorBsyRequestPrsPeriod(), CorrConfigInfo.getDefaultProcessorBsyRequestPrsPeriod(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void add(T data) {
        this.inflowLock.lock();
        try {
            if (this.bsyStateHandling) {
                this.addWithBsyHandling(data, true);
            } else {
                this.directAdd(data);
            }
        }
        finally {
            this.inflowLock.unlock();
        }
    }

    @Override
    public void put(T data) {
        this.inflowLock.lock();
        try {
            if (this.bsyStateHandling) {
                this.putWithBsyHandling(data, true);
            } else {
                this.directPut(data);
            }
        }
        finally {
            this.inflowLock.unlock();
        }
    }

    private void directAdd(T data) {
        if (!data.isBusy()) {
            data.setStatus(ExecutorStatus.QUEUED);
            try {
                this.queue.add(data);
            }
            catch (Exception exp) {
                data.setStatus(ExecutorStatus.IDLE);
            }
        }
    }

    private void directPut(T data) {
        if (!data.isBusy()) {
            data.setStatus(ExecutorStatus.QUEUED);
            try {
                this.queue.put(data);
            }
            catch (Exception exp) {
                data.setStatus(ExecutorStatus.IDLE);
            }
        }
    }

    private void addWithBsyHandling(T request, boolean update) {
        boolean isAlreadyExists = this.bsy_state_request.containsKey(request);
        if (!request.isBusy()) {
            if (isAlreadyExists) {
                this.bsy_state_request.remove(request);
            }
            request.setStatus(ExecutorStatus.QUEUED);
            try {
                this.queue.add(request);
            }
            catch (Exception exp) {
                request.setStatus(ExecutorStatus.IDLE);
            }
        } else if (!isAlreadyExists || update) {
            LOGGER.log(Level.FINER, "Correlation already running updating BSY_STATE_REQUEST Queue : {0}", request);
            this.bsy_state_request.put(request, Boolean.TRUE);
        }
    }

    private void putWithBsyHandling(T request, boolean update) {
        boolean isAlreadyExists = this.bsy_state_request.containsKey(request);
        if (!request.isBusy()) {
            if (isAlreadyExists) {
                this.bsy_state_request.remove(request);
            }
            request.setStatus(ExecutorStatus.QUEUED);
            try {
                this.queue.put(request);
            }
            catch (Exception exp) {
                request.setStatus(ExecutorStatus.IDLE);
            }
        } else if (!isAlreadyExists || update) {
            LOGGER.log(Level.FINER, "Correlation already running updating BSY_STATE_REQUEST Queue : {0}", request);
            this.bsy_state_request.put(request, Boolean.TRUE);
        }
    }
}

