/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.listener;

import com.manageengine.ela.server.correlation.callback.ActionCallBack;
import com.manageengine.ela.server.correlation.core.action.CorrActionUtil;
import com.manageengine.ela.server.correlation.core.executors.CorrelationExecutor;
import com.manageengine.ela.server.correlation.core.executors.CorrelationRuleExecutor;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CorrelationActionListener
implements ActionCallBack {
    private final Lock lock = new ReentrantLock(true);
    private volatile Set<Long> actionHit = new HashSet<Long>();
    private volatile Set<Long> bsyactionHit = new HashSet<Long>();
    private final CorrelationExecutor executor;
    private final Set<Long> totalActions;
    private final Long ruleID;
    private static final Logger LOGGER = Logger.getLogger(CorrelationActionListener.class.getName());

    public CorrelationActionListener(Long ruleID, Set<Long> totalActions, CorrelationExecutor executor) throws NullPointerException, IllegalAccessException {
        this.ruleID = Objects.requireNonNull(ruleID);
        this.executor = Objects.requireNonNull(executor);
        this.totalActions = Objects.requireNonNull(totalActions);
    }

    public CorrelationActionListener build() {
        this.actionHit.addAll(this.totalActions);
        this.bsyactionHit.addAll(this.totalActions);
        CorrActionUtil.resetAllActionStatus(this.ruleID);
        return this;
    }

    private void reFillActionStatus() {
        this.actionHit.addAll(this.bsyactionHit);
        this.bsyactionHit.addAll(this.totalActions);
    }

    @Override
    public void register(Long configuredActionID) {
        this.lock.lock();
        try {
            if (this.actionHit.contains(configuredActionID)) {
                this.actionHit.remove(configuredActionID);
            } else {
                this.bsyactionHit.remove(configuredActionID);
            }
            if (this.actionHit.isEmpty()) {
                CorrelationRuleExecutor.add(this.executor);
                this.reFillActionStatus();
            } else {
                LOGGER.log(Level.FINER, "remaining actions {0}", this.actionHit);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean skipVerification(Long actionID) {
        this.lock.lock();
        try {
            boolean bl = !this.actionHit.contains(actionID) && !this.bsyactionHit.contains(actionID);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }
}

