/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.listener;

import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.nf.NotificationManager;
import com.adventnet.sa.server.nf.NotificationProfile;
import com.manageengine.ela.server.common.schedule.ScheduledDocIdsResolver;
import com.manageengine.ela.server.correlation.auditdata.CorrNosqlIndexHandler;
import com.manageengine.ela.server.correlation.callback.CorrAuditHistoryResolvedCallBack;
import com.manageengine.ela.server.correlation.callback.CorrelationCallBack;
import com.manageengine.ela.server.correlation.core.data.ResponseContainer;
import com.manageengine.ela.server.correlation.core.data.SortedContainer;
import com.manageengine.ela.server.correlation.core.dispatcher.ResultInflowManager;
import com.manageengine.ela.server.correlation.notification.CorrNFProfile;
import com.manageengine.ela.server.correlation.notification.CorrNFProfileHandler;
import com.zoho.za.dae.elastic.LogIndexer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CorrelationAuditListener
implements CorrelationCallBack {
    private static CorrelationAuditListener instence;
    private static final Logger LOGGER;

    private CorrelationAuditListener() {
    }

    public static synchronized CorrelationAuditListener get() {
        if (instence == null) {
            instence = new CorrelationAuditListener();
        }
        return instence;
    }

    @Override
    public void callBack(Long ruleID, Map<Long, ResponseContainer> correlationInfo) {
        try {
            this.addAuditHistory(ruleID, correlationInfo);
            LOGGER.log(Level.FINER, "Successfully processed {0} correlation Entries for rule : {1}", new Object[]{correlationInfo.size(), ruleID});
        }
        catch (Exception exp) {
            LOGGER.log(Level.FINE, "Unable to create Correlation audit entry");
        }
    }

    private void addAuditHistory(Long ruleID, Map<Long, ResponseContainer> correlationInfo) throws DataAccessException {
        long startTime = 0L;
        long endTime = 0L;
        DataObject dobj = PersistenceDBUtil.getPersistence().constructDataObject();
        Row auditRow = new Row("CorrRuleSuccessHistory");
        auditRow.set("RULE_ID", (Object)ruleID);
        dobj.addRow(auditRow);
        Iterator<Map.Entry<Long, ResponseContainer>> dataItr = correlationInfo.entrySet().iterator();
        LinkedHashMap<Long, LinkedHashMap<String, Object>> actionIdsVsDocIds = new LinkedHashMap<Long, LinkedHashMap<String, Object>>();
        while (dataItr.hasNext()) {
            Map.Entry<Long, ResponseContainer> docEntry = dataItr.next();
            Long configuredAction = docEntry.getKey();
            ResponseContainer response = docEntry.getValue();
            actionIdsVsDocIds.put(configuredAction, this.loadDocIDInfo(dobj, auditRow, configuredAction, response));
            Long docfirstTime = response.firstKey();
            if (startTime == 0L || docfirstTime < startTime) {
                startTime = docfirstTime;
            }
            Long docEndTime = response.lastKey();
            if (endTime == 0L || docEndTime > endTime) {
                endTime = docEndTime;
            }
            LOGGER.log(Level.FINER, "Successfully processed Action : {0}  correlation Entries for Action :{1} ", new Object[]{configuredAction, response.getSelectedData()});
        }
        auditRow.set("START_TIME", (Object)startTime);
        auditRow.set("END_TIME", (Object)endTime);
        ResultInflowManager.put(dobj);
        this.handleCorrelationNotification(ruleID, startTime, endTime, actionIdsVsDocIds);
    }

    private LinkedHashMap<String, Object> loadDocIDInfo(DataObject dobj, Row auditRow, Long configActionID, ResponseContainer responseContainer) throws DataAccessException {
        SortedContainer orgContainer = responseContainer.getOriginalContainer();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        responseContainer.getSelectedData().descendingMap().entrySet().stream().allMatch(entry -> {
            Long time = (Long)entry.getKey();
            Integer limit = (Integer)entry.getValue();
            String indexName = LogIndexer.getIndexName((Object)time);
            LOGGER.log(Level.FINER, " IndexName : {0}", indexName);
            List<String> original = orgContainer.get(time);
            for (int index = limit - 1; index >= 0; --index) {
                try {
                    Row docIDData = new Row("CorrDocIDDetails");
                    docIDData.set("RULE_HISTORY_ID", auditRow.get("HISTORY_ID"));
                    docIDData.set("ACTION_CONFIG_ID", (Object)configActionID);
                    docIDData.set("INDEX_ID", (Object)CorrNosqlIndexHandler.getIndexID(indexName));
                    docIDData.set("DOC_ID", (Object)original.get(index));
                    dobj.addRow(docIDData);
                    map.put(original.get(index), indexName);
                    continue;
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                }
            }
            return true;
        });
        return map;
    }

    private void handleCorrelationNotification(Long ruleID, Long startTime, Long endTime, HashMap<Long, LinkedHashMap<String, Object>> actionIdsVsDocIds) {
        try {
            CorrNFProfile profile = CorrNFProfileHandler.getNotificationProfile(ruleID);
            if (profile == null) {
                return;
            }
            NotificationProfile nfProfile = NotificationManager.getInstance().getNotificationProfile(profile.getNfID());
            if (nfProfile != null && nfProfile.isNotifEnabled()) {
                CorrAuditHistoryResolvedCallBack callBack = new CorrAuditHistoryResolvedCallBack(ruleID, profile.getNfID(), startTime, endTime, actionIdsVsDocIds);
                ScheduledDocIdsResolver.insert(callBack);
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.FINER, "Unable to process correlation notification : ", exp);
        }
    }

    static {
        LOGGER = Logger.getLogger(CorrelationAuditListener.class.getName());
    }
}

