/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.listener;

import com.manageengine.ela.server.correlation.core.action.CorrelationAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NotificationListener {
    private static final Map<Long, Map<Long, CorrelationAction>> NOTIFMAPPING = new ConcurrentHashMap<Long, Map<Long, CorrelationAction>>();
    private static final Lock LOCK = new ReentrantLock(true);
    private static final Logger LOGGER = Logger.getLogger(NotificationListener.class.getName());

    public static boolean process(Long notifID, Map<?, ?> log) {
        boolean status = false;
        String docID = String.valueOf(log.get("UUID"));
        Long time = (Long)log.get("TIME");
        if (time == null || docID == null) {
            return status;
        }
        NotificationListener.notifyCorrelationProcessor(time, notifID, log, docID);
        status = true;
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyCorrelationProcessor(Long time, Long notifID, Map<?, ?> log, String docID) {
        LOCK.lock();
        try {
            Map<Long, CorrelationAction> corrProcessors = NOTIFMAPPING.get(notifID);
            if (corrProcessors != null) {
                corrProcessors.values().parallelStream().allMatch(action -> {
                    try {
                        action.process(time, log, docID);
                    }
                    catch (Exception exp) {
                        LOGGER.log(Level.FINER, "Exception while processing correlation action ", exp);
                    }
                    return true;
                });
            }
        }
        finally {
            LOCK.unlock();
        }
    }

    public static void registerCorrelationActions(Map<Long, Map<Long, CorrelationAction>> correlation) {
        LOCK.lock();
        try {
            correlation.forEach((nitifID, corrvalues) -> {
                Map<Long, CorrelationAction> intrestedActions = NOTIFMAPPING.get(nitifID);
                if (intrestedActions == null) {
                    intrestedActions = new HashMap<Long, CorrelationAction>();
                    NOTIFMAPPING.put((Long)nitifID, intrestedActions);
                }
                intrestedActions.putAll((Map<Long, CorrelationAction>)corrvalues);
            });
        }
        finally {
            LOCK.unlock();
        }
    }

    public static void removeCorrelationActions(Map<Long, List<Long>> correlation) {
        LOCK.lock();
        try {
            correlation.forEach((nitifID, corrvalues) -> {
                Map<Long, CorrelationAction> intrestedActions = NOTIFMAPPING.get(nitifID);
                if (intrestedActions != null) {
                    for (Long key : corrvalues) {
                        intrestedActions.remove(key);
                    }
                    if (intrestedActions.isEmpty()) {
                        NOTIFMAPPING.remove(nitifID);
                    }
                }
            });
        }
        finally {
            LOCK.unlock();
        }
    }

    public static Map<Long, Map<Long, CorrelationAction>> getNOTIFMAPPING() {
        return NOTIFMAPPING;
    }
}

