/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.matcher;

import com.manageengine.ela.server.correlation.core.analyzer.SkipDataAnalyzer;
import com.manageengine.ela.server.correlation.core.criteria.ActionDelimiter;
import com.manageengine.ela.server.correlation.core.data.SortedContainer;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CommonRelationMatcher {
    private static final Logger LOGGER = Logger.getLogger(CommonRelationMatcher.class.getName());
    private static CommonRelationMatcher instence = null;

    public static CommonRelationMatcher get() {
        if (instence == null) {
            instence = new CommonRelationMatcher();
        }
        return instence;
    }

    public boolean match(ActionDelimiter relation, SortedContainer history) {
        if (relation == null) {
            return !history.isEmpty();
        }
        int occurance = relation.getOccurrence();
        long period = relation.getPeriod();
        return this.checkCountinTimePeriod(history, occurance, period);
    }

    private boolean checkCountinTimePeriod(SortedContainer history, int occurance, long period) {
        if (history == null || history.isEmpty()) {
            return false;
        }
        Long startPoint = SkipDataAnalyzer.getPossibleSASPoint(history, occurance, false);
        NavigableMap<Long, List<String>> docinfo = startPoint == null ? history.headMap(history.lastKey(), true) : history.subMap(startPoint, history.lastKey());
        AtomicInteger size = new AtomicInteger(0);
        LinkedList dataList = new LinkedList();
        return docinfo.entrySet().stream().anyMatch(entry -> {
            AtomicInteger total = size;
            Long time = (Long)entry.getKey();
            int listSize = ((List)entry.getValue()).size();
            if (listSize == 0) {
                history.removeIfEmpty(time);
            } else {
                dataList.add(time);
                size.addAndGet(listSize);
            }
            try {
                if ((Long)dataList.getLast() - (Long)dataList.getFirst() > period) {
                    total.accumulateAndGet(((List)docinfo.get(dataList.removeFirst())).size(), (x, y) -> x - y);
                }
            }
            catch (NoSuchElementException exp) {
                LOGGER.log(Level.WARNING, "No Such Element");
                LOGGER.log(Level.FINER, "Error occurred at checkCountinTimePeriod {0}", exp);
            }
            return total.get() >= occurance;
        });
    }
}

