/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.matcher;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.correlation.core.criteria.FieldCriteria;
import com.manageengine.ela.server.correlation.core.matcher.MatchType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FieldCriteriaMatcher {
    private static FieldCriteriaMatcher instence = null;
    private static HashMap<Integer, MatchType> operation_method_map = null;

    public static FieldCriteriaMatcher get() {
        if (instence == null) {
            instence = new FieldCriteriaMatcher();
            operation_method_map = new HashMap();
            try {
                SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"NoSqlIndexCriteria"));
                query.addSelectColumn(Column.getColumn(null, (String)"*"));
                DataObject dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
                Iterator itr = dobj.getRows("NoSqlIndexCriteria");
                while (itr.hasNext()) {
                    Row row = (Row)itr.next();
                    try {
                        if (row.get("EXECUTABLE_CLASS") == null) continue;
                        operation_method_map.put(Integer.parseInt(row.get("OPERATION").toString()), (MatchType)Class.forName(row.get("EXECUTABLE_CLASS").toString()).newInstance());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (DataAccessException e1) {
                e1.printStackTrace();
            }
        }
        return instence;
    }

    public boolean match(FieldCriteria criteria, Map<?, ?> log, Map<String, List<String>> filedTranslation) {
        if (criteria.isConnector()) {
            FieldCriteria left = criteria.getLeftCriteria();
            FieldCriteria right = criteria.getRightCriteria();
            if (criteria.getConnector() == 0) {
                return this.match(left, log, filedTranslation) & this.match(right, log, filedTranslation);
            }
            return this.match(left, log, filedTranslation) | this.match(right, log, filedTranslation);
        }
        return this.matchCriterion(criteria.getCriterion(), log, filedTranslation);
    }

    private boolean matchCriterion(FieldCriteria.FieldCriterion criterian, Map<?, ?> log, Map<String, List<String>> filedTranslation) {
        String fieldName = criterian.getField();
        Object fieldValue = criterian.getFieldvalue();
        Object fieldOrgValue = this.getFieldValueTobeVerified(fieldName, log, filedTranslation);
        if (fieldValue == null) {
            if (criterian.getComparator() == 0) {
                return fieldOrgValue == null;
            }
            return fieldOrgValue != null;
        }
        if (fieldOrgValue == null) {
            return false;
        }
        return this.matchbytype(criterian, fieldValue, fieldOrgValue);
    }

    private Object getFieldValueTobeVerified(String crifieldName, Map<?, ?> log, Map<String, List<String>> filedTranslation) {
        List<String> availableConvFields;
        List<String> list = availableConvFields = filedTranslation != null ? filedTranslation.get(crifieldName) : null;
        if (availableConvFields != null) {
            for (String avField : availableConvFields) {
                Object filedsConvValue = log.get(avField);
                if (filedsConvValue == null) continue;
                return filedsConvValue;
            }
        } else {
            return log.get(crifieldName);
        }
        return null;
    }

    private boolean matchbytype(FieldCriteria.FieldCriterion criterion, Object fieldValue, Object fieldOrgValue) {
        try {
            return operation_method_map.get(criterion.getComparator()).check(criterion, fieldValue, fieldOrgValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Invalid FieldCriterion");
        }
    }
}

