/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.matcher;

import com.manageengine.ela.server.correlation.core.CorrelationRuleContainer;
import com.manageengine.ela.server.correlation.core.criteria.ActionDelimiter;
import com.manageengine.ela.server.correlation.core.data.RuleContainer;
import com.manageengine.ela.server.correlation.core.data.SortedContainer;
import com.manageengine.ela.server.correlation.core.matcher.CommonRelationMatcher;
import java.util.List;
import java.util.Map;

public class SharedFieldMatcher {
    private static SharedFieldMatcher instence = null;

    public static SharedFieldMatcher get() {
        if (instence == null) {
            instence = new SharedFieldMatcher();
        }
        return instence;
    }

    public boolean match(Long configuredAction, Map<String, List<Map.Entry<Long, String>>> sharedFieldRef, ActionDelimiter relation, RuleContainer container) {
        if (sharedFieldRef == null) {
            return true;
        }
        Map<String, Map<String, SortedContainer>> currentInitiatedAction = container.getFieldDataContainer(configuredAction).getDirectMap();
        return sharedFieldRef.entrySet().stream().allMatch(entry -> {
            String keyValyue = (String)entry.getKey();
            List refLink = (List)entry.getValue();
            Map localDataContainer = (Map)currentInitiatedAction.get(keyValyue);
            if (localDataContainer == null) {
                return false;
            }
            return localDataContainer.entrySet().stream().anyMatch(valueEntry -> {
                String fieldSource = (String)valueEntry.getKey();
                SortedContainer sortedContainer = (SortedContainer)valueEntry.getValue();
                if (!CommonRelationMatcher.get().match(relation, sortedContainer)) {
                    return false;
                }
                return refLink.stream().allMatch(refEntry -> {
                    Long remoteAction = (Long)refEntry.getKey();
                    String remoteField = (String)refEntry.getValue();
                    ActionDelimiter remoteActionDelimiter = CorrelationRuleContainer.getActionDelimiter(container.getId(), remoteAction);
                    Map<String, SortedContainer> remoteDataContainer = container.getFieldDataContainer(remoteAction).getDirectMap().get(remoteField);
                    if (remoteDataContainer == null) {
                        return false;
                    }
                    SortedContainer remoteSortedContainer = remoteDataContainer.get(fieldSource);
                    if (remoteSortedContainer == null) {
                        return false;
                    }
                    return CommonRelationMatcher.get().match(remoteActionDelimiter, sortedContainer);
                });
            });
        });
    }
}

