/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.schedule;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Criteria;
import com.adventnet.sa.server.util.DBUtil;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import com.manageengine.ela.server.common.cache.ServerDetailsBean;
import com.manageengine.ela.server.correlation.auditdata.CorrelationArchivedData;
import com.manageengine.ela.server.correlation.core.config.CorrConfigInfo;
import com.manageengine.ela.server.correlation.util.CorrelationUtil;
import com.zoho.za.dae.schedule.ArchiveManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class CorrelationColdDataProcessor
implements Task {
    public void executeTask(TaskContext taskInput) throws TaskExecutionException {
        if (!ServerDetailsBean.getInstance().isAdminServer()) {
            int days = CorrConfigInfo.getRetentionPeriod();
            if (days != -1) {
                ArchiveManager.deleteCorrIndices((int)days);
                long millisec = System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(days, TimeUnit.DAYS);
                try {
                    List<Map<String, Object>> archivedData = CorrelationArchivedData.get().getArchivedTablesInfoFromEnd(millisec);
                    if (archivedData.size() > 0) {
                        ArrayList<String> tablesToBeDeleted = new ArrayList<String>(archivedData.size() * 2);
                        for (int index = 0; index < archivedData.size(); ++index) {
                            Map<String, Object> dataMap = archivedData.get(index);
                            tablesToBeDeleted.add((String)dataMap.get("CorrRuleSuccessHistory"));
                            tablesToBeDeleted.add((String)dataMap.get("CorrDocIDDetails"));
                        }
                        RelationalAPI.getInstance().getArchiveAdapter().deleteArchiveTable(tablesToBeDeleted);
                    }
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                }
                Criteria criteria = CorrelationUtil.getTimeBasedCustomTableSuccessCriteria("CorrRuleSuccessHistory", null, millisec);
                DBUtil.deleteExistingRows("CorrRuleSuccessHistory", criteria, new boolean[0]);
            }
        } else {
            try {
                this.stopTask();
            }
            catch (TaskExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    public void stopTask() throws TaskExecutionException {
    }
}

