/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.schedule;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.db.archive.ArchiveNotificationHandler;
import com.adventnet.db.archive.ArchivePolicyInfo;
import com.adventnet.db.archive.TableArchiverUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.DerivedColumn;
import com.adventnet.ds.query.DerivedTable;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.QueryConstructionException;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UnionQueryImpl;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.DBUtil;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import com.manageengine.ela.server.common.cache.ServerDetailsBean;
import com.manageengine.ela.server.correlation.core.listener.CorrelationDBArchiveListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CorrelationDBArchiveTask
implements Task {
    private static final Lock SYNC = new ReentrantLock();
    private static final Logger LOGGER = Logger.getLogger(CorrelationDBArchiveTask.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask(TaskContext paramTaskContext) throws TaskExecutionException {
        if (!ServerDetailsBean.getInstance().isAdminServer()) {
            SYNC.lock();
            try {
                Iterator iterator = paramTaskContext.getDefaultTaskInputs();
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    this.startArchiveProcess(Long.parseLong((String)row.get("VARIABLE_VALUE")));
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            finally {
                SYNC.unlock();
            }
        } else {
            try {
                this.stopTask();
            }
            catch (TaskExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    public void test(Long policyID) throws Exception {
        this.startArchiveProcess(policyID);
    }

    private void startArchiveProcess(Long policyID) throws Exception {
        ArchivePolicyInfo policyInfo = TableArchiverUtil.getPolicy((Long)policyID);
        while (this.isTableFilled(policyInfo)) {
            Long upperLimit = policyInfo.getThreshold() / 2L;
            int maxRowsAllowed = upperLimit.intValue();
            long oldmethod = System.nanoTime();
            this.getFirstAndLastRow_old_way2(policyInfo, maxRowsAllowed);
            oldmethod = System.nanoTime() - oldmethod;
            long newmethod = System.nanoTime();
            Map<String, Long> identity = this.getFirstAndLastRow_new_way2(policyInfo, maxRowsAllowed);
            newmethod = System.nanoTime() - newmethod;
            if (identity == null || identity.size() == 0) break;
            LOGGER.log(Level.INFO, "Time taken to find first and last row old {0}  new {1}", new Object[]{oldmethod, newmethod});
            policyInfo.setCriteria(" ( ( $.HISTORY_ID <= " + identity.get("HISTORY_ID_MAX") + " ) AND ( $.HISTORY_ID >= " + identity.get("HISTORY_ID_MIN") + " ) ) ");
            policyInfo.setNotificationHandler((ArchiveNotificationHandler)new CorrelationDBArchiveListener(identity.get("TIME_MIN"), identity.get("TIME_MAX")));
            RelationalAPI.getInstance().getArchiveAdapter().startArchive(policyInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Long> getFirstAndLastRow_new_way2(ArchivePolicyInfo policyInfo, int upperLimit) throws DataAccessException, SQLException, QueryConstructionException {
        HashMap<String, Long> seletedDetails = new HashMap<String, Long>();
        SelectQueryImpl subQuery = new SelectQueryImpl(Table.getTable((String)policyInfo.getTableName()));
        subQuery.setRange(new Range(1, upperLimit));
        Column pkColumn = Column.getColumn((String)policyInfo.getTableName(), (String)"HISTORY_ID");
        Column startTimeColumn = Column.getColumn((String)policyInfo.getTableName(), (String)"START_TIME");
        Column endTimeColumn = Column.getColumn((String)policyInfo.getTableName(), (String)"END_TIME");
        subQuery.addSelectColumn(pkColumn);
        subQuery.addSelectColumn(startTimeColumn);
        subQuery.addSelectColumn(endTimeColumn);
        subQuery.addSortColumn(new SortColumn(Column.getColumn((String)"CorrRuleSuccessHistory", (String)"HISTORY_ID"), true));
        DerivedTable dtab = new DerivedTable(policyInfo.getTableName(), (Query)subQuery);
        SelectQueryImpl query = new SelectQueryImpl((Table)dtab);
        query.addSelectColumn(pkColumn.minimum());
        query.addSelectColumn(pkColumn.maximum());
        query.addSelectColumn(startTimeColumn.minimum());
        query.addSelectColumn(endTimeColumn.maximum());
        Connection con = null;
        DataSet dSet = null;
        try {
            con = RelationalAPI.getInstance().getConnection();
            dSet = RelationalAPI.getInstance().executeQuery((Query)query, con);
            while (dSet.next()) {
                seletedDetails.put("HISTORY_ID_MIN", Objects.requireNonNull(dSet.getAsLong(1)));
                seletedDetails.put("HISTORY_ID_MAX", Objects.requireNonNull(dSet.getAsLong(2)));
                seletedDetails.put("TIME_MIN", Objects.requireNonNull(dSet.getAsLong(3)));
                seletedDetails.put("TIME_MAX", Objects.requireNonNull(dSet.getAsLong(4)));
            }
        }
        catch (Exception exp) {
            try {
                exp.printStackTrace();
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSetOrDataSet(null, dSet);
                DBUtil.closeStmtAndConnection(null, con);
                throw throwable;
            }
            DBUtil.closeResultSetOrDataSet(null, dSet);
            DBUtil.closeStmtAndConnection(null, con);
        }
        DBUtil.closeResultSetOrDataSet(null, dSet);
        DBUtil.closeStmtAndConnection(null, con);
        return seletedDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, Row> getFirstAndLastRow_old_way2(ArchivePolicyInfo policyInfo, int upperLimit) throws DataAccessException, SQLException, QueryConstructionException {
        TreeMap<Long, Row> seletedDetails = new TreeMap<Long, Row>();
        SelectQueryImpl subQuery = new SelectQueryImpl(Table.getTable((String)policyInfo.getTableName()));
        subQuery.setRange(new Range(0, 1));
        subQuery.addSelectColumn(Column.getColumn(null, (String)"*"));
        SelectQueryImpl selectFirstAndLast = new SelectQueryImpl(Table.getTable((String)policyInfo.getTableName()));
        selectFirstAndLast.addSelectColumn(Column.getColumn(null, (String)"*"));
        selectFirstAndLast.addSortColumn(new SortColumn(Column.getColumn((String)"CorrRuleSuccessHistory", (String)"HISTORY_ID"), true));
        selectFirstAndLast.setRange(new Range(upperLimit, 1));
        UnionQueryImpl unionquery = new UnionQueryImpl((Query)selectFirstAndLast, (Query)subQuery, true);
        Connection con = null;
        DataSet dSet = null;
        try {
            con = RelationalAPI.getInstance().getConnection();
            dSet = RelationalAPI.getInstance().executeQuery((Query)unionquery, con);
            while (dSet.next()) {
                Row row = new Row(policyInfo.getTableName());
                List columns = row.getColumns();
                for (Object obj : columns) {
                    String colName = (String)obj;
                    row.set(colName, dSet.getValue(colName));
                }
                seletedDetails.put((Long)row.get("HISTORY_ID"), row);
            }
        }
        catch (Exception exp) {
            try {
                exp.printStackTrace();
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSetOrDataSet(null, dSet);
                DBUtil.closeStmtAndConnection(null, con);
                throw throwable;
            }
            DBUtil.closeResultSetOrDataSet(null, dSet);
            DBUtil.closeStmtAndConnection(null, con);
        }
        DBUtil.closeResultSetOrDataSet(null, dSet);
        DBUtil.closeStmtAndConnection(null, con);
        return seletedDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Row> getFirstAndLastRow_old_way1(ArchivePolicyInfo policyInfo, int upperLimit) throws DataAccessException, SQLException, QueryConstructionException {
        SelectQueryImpl subQuery = new SelectQueryImpl(Table.getTable((String)policyInfo.getTableName()));
        subQuery.setRange(new Range(0, upperLimit));
        Column pkColumn = Column.getColumn((String)policyInfo.getTableName(), (String)"HISTORY_ID");
        subQuery.addSelectColumn(pkColumn);
        DerivedTable dtab = new DerivedTable(policyInfo.getTableName(), (Query)subQuery);
        SelectQueryImpl minvalue = new SelectQueryImpl((Table)dtab);
        minvalue.addSelectColumn(Column.getColumn((String)policyInfo.getTableName(), (String)"HISTORY_ID").minimum());
        SelectQueryImpl maxvalue = new SelectQueryImpl((Table)dtab);
        maxvalue.addSelectColumn(Column.getColumn((String)policyInfo.getTableName(), (String)"HISTORY_ID").maximum());
        DerivedColumn derivedMinColumn = new DerivedColumn(policyInfo.getTableName(), (SelectQuery)minvalue);
        DerivedColumn derivedMaxColumn = new DerivedColumn(policyInfo.getTableName(), (SelectQuery)maxvalue);
        SelectQueryImpl finalQuery = new SelectQueryImpl(Table.getTable((String)policyInfo.getTableName()));
        finalQuery.addSelectColumn(Column.getColumn(null, (String)"*"));
        Criteria criteria = new Criteria(Column.getColumn((String)policyInfo.getTableName(), (String)"HISTORY_ID"), (Object)derivedMinColumn, 0);
        criteria = criteria.or(new Criteria(Column.getColumn((String)policyInfo.getTableName(), (String)"HISTORY_ID"), (Object)derivedMaxColumn, 0));
        finalQuery.setCriteria(criteria);
        ArrayList<Row> arrayList = new ArrayList<Row>(2);
        Connection con = null;
        DataSet dSet = null;
        try {
            con = RelationalAPI.getInstance().getConnection();
            dSet = RelationalAPI.getInstance().executeQuery((Query)finalQuery, con);
            while (dSet.next()) {
                Row row = new Row(policyInfo.getTableName());
                List columns = row.getColumns();
                for (Object obj : columns) {
                    String colName = (String)obj;
                    row.set(colName, dSet.getValue(colName));
                }
                arrayList.add(row);
            }
        }
        catch (Exception exp) {
            try {
                exp.printStackTrace();
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSetOrDataSet(null, dSet);
                DBUtil.closeStmtAndConnection(null, con);
                throw throwable;
            }
            DBUtil.closeResultSetOrDataSet(null, dSet);
            DBUtil.closeStmtAndConnection(null, con);
        }
        DBUtil.closeResultSetOrDataSet(null, dSet);
        DBUtil.closeStmtAndConnection(null, con);
        return arrayList;
    }

    private boolean isTableFilled(ArchivePolicyInfo policyInfo) {
        return DBUtil.getCountLong(policyInfo.getTableName(), null) > policyInfo.getThreshold();
    }

    public void stopTask() throws TaskExecutionException {
    }

    private void updateArchiveHistoryTableInfo(Row firstRow, Row lastRow, Long archiveFileID) {
        Row fileHistory = new Row("CorrArchivedTablesInfo");
        fileHistory.set("START_TIME", firstRow.get("START_TIME"));
        fileHistory.set("FILE_ID", (Object)archiveFileID);
        fileHistory.set("END_TIME", firstRow.get("END_TIME"));
        DBUtil.createNewRow(fileHistory, new boolean[0]);
    }
}

