/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.schedule;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.QueryConstructor;
import com.adventnet.persistence.Row;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import com.manageengine.ela.server.common.cache.ServerDetailsBean;
import com.manageengine.ela.server.correlation.auditdata.CorrNosqlIndexHandler;
import com.manageengine.ela.server.correlation.core.config.CorrConfigInfo;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CorrelationDocIDResolver
implements Task {
    private static final Logger LOGGER = Logger.getLogger(CorrelationDocIDResolver.class.getName());
    private static final Lock SYNC = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask(TaskContext paramTaskContext) {
        if (!ServerDetailsBean.getInstance().isAdminServer()) {
            LOGGER.log(Level.FINER, "Correlation audit listener intiated ");
            long time = System.currentTimeMillis();
            AtomicInteger successEntries = new AtomicInteger(0);
            AtomicInteger totalEntries = new AtomicInteger(0);
            SYNC.lock();
            try {
                Criteria rangeCriteria = null;
                Criteria commonCriteria = new Criteria(Column.getColumn((String)"CorrDocIDDetails", (String)"IS_RESOLVED"), (Object)Boolean.FALSE, 0);
                do {
                    Criteria combined = rangeCriteria != null ? rangeCriteria.and(commonCriteria) : commonCriteria;
                    SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"NoSqlIndexDetails"));
                    query.addSelectColumn(Column.getColumn((String)"NoSqlIndexDetails", (String)"INDEX_ID", (String)"INDEX_FIELD_ID"));
                    query.addSelectColumn(Column.getColumn((String)"NoSqlIndexDetails", (String)"INDEX_NAME"));
                    List joins = QueryConstructor.getJoins(Arrays.asList("NoSqlIndexDetails", "CorrDocIDDetails", "CorrRuleSuccessHistory"));
                    for (Object join : joins) {
                        query.addJoin((Join)join);
                    }
                    query.addSelectColumn(Column.getColumn((String)"CorrDocIDDetails", (String)"DOC_HISTORY_ID"));
                    query.addSelectColumn(Column.getColumn((String)"CorrDocIDDetails", (String)"RULE_HISTORY_ID"));
                    query.addSelectColumn(Column.getColumn((String)"CorrDocIDDetails", (String)"ACTION_CONFIG_ID"));
                    query.addSelectColumn(Column.getColumn((String)"CorrDocIDDetails", (String)"INDEX_ID", (String)"SUCCESS_INDEX_ID"));
                    query.addSelectColumn(Column.getColumn((String)"CorrDocIDDetails", (String)"DOC_ID"));
                    query.addSelectColumn(Column.getColumn((String)"CorrDocIDDetails", (String)"IS_RESOLVED"));
                    query.addSelectColumn(Column.getColumn((String)"CorrRuleSuccessHistory", (String)"HISTORY_ID"));
                    query.addSelectColumn(Column.getColumn((String)"CorrRuleSuccessHistory", (String)"RULE_ID"));
                    query.addSelectColumn(Column.getColumn((String)"CorrRuleSuccessHistory", (String)"START_TIME"));
                    query.addSelectColumn(Column.getColumn((String)"CorrRuleSuccessHistory", (String)"END_TIME"));
                    query.setCriteria(combined);
                    query.addSortColumn(new SortColumn(Column.getColumn((String)"CorrDocIDDetails", (String)"DOC_HISTORY_ID"), true));
                    query.setRange(new Range(1, CorrConfigInfo.getDefault_temp_dataobject_maxsize()));
                    DataObject dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
                    if (dobj.isEmpty()) {
                        break;
                    }
                    totalEntries.addAndGet(dobj.size("CorrDocIDDetails"));
                    Long lastID = this.resolveAnprocessCorrIndex(dobj, successEntries);
                    PersistenceDBUtil.getPersistence().update(dobj);
                    if (lastID == null) {
                        break;
                    }
                    rangeCriteria = new Criteria(Column.getColumn((String)"CorrDocIDDetails", (String)"DOC_HISTORY_ID"), (Object)lastID, 5);
                } while (totalEntries.get() <= CorrConfigInfo.getAuditrecord_maxdocid_percall());
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            finally {
                SYNC.unlock();
            }
            LOGGER.log(Level.INFO, "Processed Indexes {0},  successfully migrated {1} indexes , Time taken to process {2}", new Object[]{totalEntries.get(), successEntries.get(), System.currentTimeMillis() - time});
        } else {
            try {
                this.stopTask();
            }
            catch (TaskExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    private Long resolveAnprocessCorrIndex(DataObject dobj, AtomicInteger successEntries) throws DataAccessException {
        Iterator itr = dobj.getRows("CorrDocIDDetails");
        Long lastIndex = null;
        while (itr.hasNext()) {
            Row docInfo = (Row)itr.next();
            lastIndex = (Long)docInfo.get("DOC_HISTORY_ID");
            Criteria criteria = new Criteria(Column.getColumn((String)"NoSqlIndexDetails", (String)"INDEX_ID"), docInfo.get("INDEX_ID"), 0);
            Row indexInfo = dobj.getRow("NoSqlIndexDetails", criteria);
            criteria = new Criteria(Column.getColumn((String)"CorrRuleSuccessHistory", (String)"HISTORY_ID"), docInfo.get("RULE_HISTORY_ID"), 0);
            Row successInfo = dobj.getRow("CorrRuleSuccessHistory", criteria);
            Map.Entry<String, String> response = CorrNosqlIndexHandler.indexCorrelationDocInfo((String)indexInfo.get("INDEX_NAME"), (String)docInfo.get("DOC_ID"), (Long)docInfo.get("ACTION_CONFIG_ID"), (Long)successInfo.get("RULE_ID"));
            if (response == null) continue;
            docInfo.set("IS_RESOLVED", (Object)true);
            docInfo.set("DOC_ID", (Object)response.getValue());
            docInfo.set("INDEX_ID", (Object)CorrNosqlIndexHandler.getIndexID(response.getKey()));
            dobj.updateRow(docInfo);
            successEntries.incrementAndGet();
        }
        return lastIndex;
    }

    public void stopTask() throws TaskExecutionException {
    }
}

