/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.status;

import com.manageengine.ela.server.correlation.core.constants.ExecutorStatus;
import com.manageengine.ela.server.correlation.core.status.StatusHandler;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class StatusHandlerImpl
implements StatusHandler {
    private final Lock lock = new ReentrantLock(true);
    private ExecutorStatus status = ExecutorStatus.IDLE;

    @Override
    public ExecutorStatus getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(ExecutorStatus status) {
        this.lock.lock();
        try {
            this.status = status;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isBusy() {
        this.lock.lock();
        try {
            boolean bl = this.status == ExecutorStatus.STARTED || this.status == ExecutorStatus.QUEUED;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void reset() {
        this.lock.lock();
        try {
            this.status = ExecutorStatus.IDLE;
        }
        finally {
            this.lock.unlock();
        }
    }
}

