/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.notification;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.cache.Cache;
import com.manageengine.ela.server.correlation.notification.CorrNFProfile;
import com.manageengine.ela.server.correlation.util.CorrelationUtil;
import java.util.Iterator;

public class CorrNFProfileHandler {
    private static final Cache<Long, CorrNFProfile> PROFILE_LIST = new Cache();

    public static boolean init(DataObject dobj) throws DataAccessException {
        boolean status = false;
        if (dobj != null && dobj.containsTable("CorrRuleInfo")) {
            Iterator itr = dobj.getRows("CorrNotificationMapping");
            while (itr.hasNext()) {
                Row notifMapping = (Row)itr.next();
                CorrNFProfile profile = new CorrNFProfile((Long)notifMapping.get("RULE_ID"), (Long)notifMapping.get("NOTIFID"));
                Row ruleInfo = dobj.getRow("CorrRuleInfo", new Criteria(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID"), (Object)profile.getRuleID(), 0));
                if (ruleInfo == null) continue;
                profile.setRuleName((String)ruleInfo.get("RULE_DISPLAY_NAME"));
                PROFILE_LIST.put(profile.getRuleID(), profile);
                status = true;
            }
        }
        return status;
    }

    public static void remove(Long ruleID) {
        PROFILE_LIST.remove(ruleID);
    }

    public static CorrNFProfile getNotificationProfile(Long ruleID) throws DataAccessException {
        return CorrNFProfileHandler.getProfileFromCache(ruleID);
    }

    private static CorrNFProfile getProfileFromCache(Long ruleID) throws DataAccessException {
        CorrNFProfile profile = PROFILE_LIST.get(ruleID);
        if (profile == null && CorrNFProfileHandler.init(CorrelationUtil.getCorrelationAlertDO(ruleID))) {
            profile = PROFILE_LIST.get(ruleID);
        }
        return profile;
    }
}

