/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.notification;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.nf.NewHTMLTemplate;
import com.adventnet.sa.server.nf.NotificationManager;
import com.manageengine.ela.server.correlation.auditdata.CorrNosqlIndexHandler;
import com.manageengine.ela.server.correlation.util.CorrelationUtil;
import com.zoho.za.dae.utils.ElasticUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CorrelationNotificationHandler {
    public static CorrelationNotificationHandler instance = null;
    public static final String FIELD_VALUES_KEY = "FIELD_VALUES";
    private static final List<String> IMPORTANT_FIELDS = Arrays.asList("USERNAME", "HOSTNAME", "REMOTEHOST", "DOMAIN", "SOURCE_IP");
    private static final List<String> DEFAULT_MSG_FIELDS = Arrays.asList(ElasticUtils.DEFAULT_MESSAGE_FIELDS);
    private static final List<String> DEFAULT_FIELDS = Arrays.asList("RULE_NAME", "TRIGGERED_TIME");

    private CorrelationNotificationHandler() {
    }

    public static CorrelationNotificationHandler getInstance() {
        if (instance == null) {
            instance = new CorrelationNotificationHandler();
        }
        return instance;
    }

    public String replaceFields(String text, Hashtable log, boolean forSubject) {
        HashMap fieldValues = (HashMap)log.get(FIELD_VALUES_KEY);
        Pattern actionFieldsPattern = Pattern.compile("\\%(\\d+)_([A-Z_]+)\\%");
        Matcher actionFieldsMatcher = actionFieldsPattern.matcher(text);
        StringBuffer sb = new StringBuffer();
        try {
            while (actionFieldsMatcher.find()) {
                String macrosActionId = actionFieldsMatcher.group(1);
                String macrosField = actionFieldsMatcher.group(2);
                if (macrosField.equals("ACTNDESC")) {
                    actionFieldsMatcher.appendReplacement(sb, CorrelationUtil.getActionDescription(Long.parseLong(macrosActionId)));
                    continue;
                }
                Iterator iterator = ((LinkedHashMap)fieldValues.get(Long.parseLong(macrosActionId))).entrySet().iterator();
                String result = "";
                Map value = (Map)iterator.next().getValue();
                String val = DEFAULT_MSG_FIELDS.contains(macrosField) ? (forSubject ? " " : CorrNosqlIndexHandler.getMessageField(value)) : (String)value.get(macrosField);
                if (val != null && !val.isEmpty()) {
                    result = val;
                } else {
                    List<String> assFields = CorrelationUtil.getAssociatedFields(Long.parseLong(macrosActionId), macrosField);
                    for (String field : assFields) {
                        val = (String)value.get(field);
                        if (val == null || val.isEmpty()) continue;
                        result = val;
                        break;
                    }
                }
                if (result.length() != 0) {
                    actionFieldsMatcher.appendReplacement(sb, Matcher.quoteReplacement(result));
                    continue;
                }
                actionFieldsMatcher.appendReplacement(sb, "-");
            }
            actionFieldsMatcher.appendTail(sb);
            text = sb.toString();
            for (int i = 0; i < DEFAULT_FIELDS.size(); ++i) {
                text = text.replaceAll("\\%" + DEFAULT_FIELDS.get(i) + "\\%", Matcher.quoteReplacement((String)log.get(DEFAULT_FIELDS.get(i))));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return text;
    }

    public boolean isCorrelationProfile(Long notifId) {
        boolean result = false;
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("NotificationType"));
            query.addSelectColumn(Column.getColumn((String)"NotificationType", (String)"NOTIFID"));
            query.addSelectColumn(Column.getColumn((String)"NotificationType", (String)"TYPE"));
            Criteria crit = new Criteria(Column.getColumn((String)"NotificationType", (String)"NOTIFID"), (Object)notifId, 0);
            query.setCriteria(crit);
            DataObject dObj = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
            Long type = (Long)dObj.getFirstValue("NotificationType", "TYPE");
            if (type != null && type == -1002L) {
                result = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getDefaultCorrEmailMessage(Long ruleId, boolean isHTMLFormat) {
        NewHTMLTemplate nht = isHTMLFormat ? new NewHTMLTemplate("CorrAlertMailContent.html", null, true) : new NewHTMLTemplate("CorrAlertMailContentPlain.txt", null, false);
        String message = nht.getContent();
        ProductBundle rb = ProductBundle.getInstance();
        try {
            StringBuilder messageBuilder = new StringBuilder();
            if (ruleId != null) {
                JSONArray ruleActions = CorrelationUtil.getActionsAndFields(ruleId);
                this.createTable(messageBuilder, ruleActions, rb, isHTMLFormat);
            }
            message = message.replaceAll("\\%RULE_CONTENT\\%", Matcher.quoteReplacement(messageBuilder.toString()));
            message = message.replaceAll("\\%RULE_NAME\\%", Matcher.quoteReplacement(CorrelationUtil.getRuleName(ruleId)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message;
    }

    public static List<Long> getAllCorrNotifIds() {
        ArrayList<Long> notifIds = new ArrayList<Long>();
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"CorrNotificationMapping"));
            selectQuery.addJoin(new Join("CorrNotificationMapping", "NotfnConfiguration", new String[]{"NOTIFID"}, new String[]{"NOTIFID"}, 2));
            selectQuery.addSelectColumn(Column.getColumn((String)"CorrNotificationMapping", (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)"NotfnConfiguration", (String)"NOTIFID"));
            DataObject notifs = DataAccess.get((SelectQuery)selectQuery);
            Iterator itr = notifs.getRows("NotfnConfiguration");
            while (itr.hasNext()) {
                Row r = (Row)itr.next();
                notifIds.add(Long.parseLong(r.get("NOTIFID").toString()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return notifIds;
    }

    private void createTable(StringBuilder builder, JSONArray actions, ProductBundle rb, boolean isHTMLFormat) {
        try {
            boolean tableFlag = false;
            boolean plainTableFlag = false;
            for (int i = 0; i < 5 && i < actions.length(); ++i) {
                JSONObject action = actions.getJSONObject(i);
                JSONArray fields = action.getJSONArray("FIELDS");
                ArrayList<JSONObject> availableFields = new ArrayList<JSONObject>();
                for (int j = 0; j < fields.length(); ++j) {
                    JSONObject field = fields.getJSONObject(j);
                    if (!IMPORTANT_FIELDS.contains(field.getString("FIELD_INDEX_NAME"))) continue;
                    availableFields.add(field);
                }
                if (availableFields.size() <= 0) continue;
                if (isHTMLFormat && !tableFlag) {
                    builder.append("<div style=\"font-family:Gotham, 'Verdana',Helvetica Neue, Helvetica, Arial, sans-serif;font-size:11px;line-height:30px;color:#585858;margin-top:10px;\">").append(rb.getString("AlertMailNewHead6")).append("<br></div>");
                    builder.append("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"border:1px solid #e4e4e4\">");
                    tableFlag = true;
                } else if (!isHTMLFormat && !plainTableFlag) {
                    builder.append("\n").append(rb.getString("AlertMailNewHead6"));
                    plainTableFlag = true;
                }
                this.appendActionTable(builder, action, availableFields, rb, isHTMLFormat);
            }
            if (tableFlag) {
                builder.append("</table>");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void appendActionTable(StringBuilder builder, JSONObject action, List<JSONObject> availableFields, ProductBundle rb, boolean isHTMLFormat) throws JSONException {
        int occurance = action.getInt("HITS");
        String desc = action.getString("DESCRIPTION");
        String actionConfigId = action.getString("ACTION_CONFIG_ID");
        if (occurance > 1) {
            if (desc.endsWith(".")) {
                desc = desc.substring(0, desc.length() - 1);
            }
            desc = desc.concat(" " + occurance + " " + ProductBundle.getInstance().getString("EditAlert.times") + ".");
        }
        if (isHTMLFormat) {
            builder.append("<tr valign=\"top\">");
            builder.append("<td  style=\"font-family:Gotham, 'Verdana',Helvetica Neue, Helvetica, Arial, sans-serif;font-size:10px;line-height:22px;background-color:#fafafa;border-right:1px solid #e4e4e4;text-align:right;padding-right:10px;padding-top:5px;border-bottom:1px solid #e4e4e4;\">%").append(actionConfigId).append("_").append("ACTNTIME%<div style=\"color:#585858;line-height:14px;\">&nbsp;%").append(actionConfigId).append("_").append("ACTNDATE%</div></td>");
            builder.append("<td  style=\"padding:5px;border-bottom:1px solid #e4e4e4;\">");
            builder.append("<div style=\"font-family:Gotham, 'Verdana',Helvetica Neue, Helvetica, Arial, sans-serif;font-size:11px;line-height:22px;padding-left:10px;\"><p><span style=\"color:#000;font-weight:bold;\">");
            builder.append(desc).append("</p></span></div>");
            builder.append("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"color: #444;\">");
            for (JSONObject field : availableFields) {
                builder.append("<tr>");
                builder.append("<td  style=\"font-family:Gotham, 'Verdana',Helvetica Neue, Helvetica, Arial, sans-serif;font-size:11px;line-height:22px;padding-left:10px;color:#000;\">").append(field.getString("NAME")).append("</td>");
                builder.append("<td  style=\"font-family:Gotham, 'Verdana',Helvetica Neue, Helvetica, Arial, sans-serif;font-size:11px;line-height:22px;padding-left:5px;\">: %").append(actionConfigId).append("_").append(field.getString("FIELD_INDEX_NAME")).append("%</td>");
                builder.append("</tr>");
            }
            builder.append("</table></td></tr>");
        } else {
            builder.append("\n\n%").append(actionConfigId).append("_").append("ACTNTIME% %").append(actionConfigId).append("_").append("ACTNDATE% : ");
            builder.append(desc);
            builder.append("\n");
            for (JSONObject field : availableFields) {
                builder.append("\n");
                builder.append(field.getString("NAME")).append(" : ");
                builder.append("%").append(actionConfigId).append("_").append(field.getString("FIELD_INDEX_NAME")).append("%");
            }
        }
    }

    public void reconfigureAlertMailContent(Long ruleId) {
        try {
            List<String> tableList = Arrays.asList("CorrNotificationMapping", "NotificationType", "NotfnConfiguration");
            Criteria criteria = new Criteria(Column.getColumn((String)"CorrNotificationMapping", (String)"RULE_ID"), (Object)ruleId, 0);
            DataObject dataObject = PersistenceDBUtil.getPersistence().get(tableList, criteria);
            if (dataObject != null && dataObject.containsTable("NotfnConfiguration")) {
                Long notifId = (Long)dataObject.getFirstValue("CorrNotificationMapping", "NOTIFID");
                Row row = dataObject.getFirstRow("NotfnConfiguration");
                row.set("MAIL_CONTENT", (Object)this.getDefaultCorrEmailMessage(ruleId, true));
                row.set("MAIL_CONTENT_PLAIN", (Object)this.getDefaultCorrEmailMessage(ruleId, false));
                dataObject.updateRow(row);
                PersistenceDBUtil.getPersistence().update(dataObject);
                NotificationManager.getInstance().refreshNotifier(notifId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

