/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.correlation.common.data.CommonDataHelper;
import com.manageengine.ela.server.correlation.core.constants.CorrelationStatus;
import com.manageengine.ela.server.correlation.session.builder.ActivityRuleInitializer;
import com.manageengine.ela.server.correlation.session.config.ActivityProfileContainer;
import com.manageengine.ela.server.correlation.session.data.cache.ActivityPrimaryDocHandler;
import com.manageengine.ela.server.correlation.session.info.ActivityProfileInfo;
import com.manageengine.ela.server.correlation.session.info.ActivityProviderInfo;
import com.manageengine.ela.server.correlation.session.util.ActivityUtil;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ActivityHandler {
    private static final Logger LOGGER = Logger.getLogger(ActivityHandler.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeActivities() {
        try {
            DataObject dataObject = ActivityUtil.getCompleteActivityData();
            Iterator activityIterator = dataObject.getRows("ActivityMonitorProfile");
            while (activityIterator.hasNext()) {
                Row activityProfile = (Row)activityIterator.next();
                Long profileID = (Long)activityProfile.get("PROFILE_ID");
                ActivityProfileInfo profileInfo = new ActivityProfileInfo(profileID);
                Criteria providerCriteria = new Criteria(Column.getColumn((String)"ActivityRuleProviders", (String)"PROFILE_ID"), (Object)profileID, 0);
                Iterator providerIterator = dataObject.getRows("ActivityRuleProviders", providerCriteria);
                while (providerIterator.hasNext()) {
                    Row ruleProvider = (Row)providerIterator.next();
                    ActivityProviderInfo providerInfo = ActivityRuleInitializer.initActivityProvider(ruleProvider, dataObject);
                    if (providerInfo == null) continue;
                    profileInfo.addProvider(providerInfo);
                }
                ActivityProfileContainer.load(profileInfo, CorrelationStatus.getStatus((Long)activityProfile.get("STATUS")));
            }
            ActivityPrimaryDocHandler.init();
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, "Error occurred during correlation activity initialization {0}", new Object[]{exp.getMessage()});
        }
        finally {
            CommonDataHelper.initializeArchiveProcessors();
        }
    }
}

