/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.adapter;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.TimePack;
import com.manageengine.ela.server.common.client.adapters.ClientDBArchiveAdapter;
import com.manageengine.ela.server.common.ember.datasource.DefaultDataSource;
import com.manageengine.ela.server.correlation.session.auditdata.ActivityArchivedData;
import com.manageengine.ela.server.correlation.session.search.tablesearch.ActivityTableSearchHandler;
import com.manageengine.ela.server.correlation.session.util.ActivityUtil;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class ActivityArchiveAdapter
implements ClientDBArchiveAdapter {
    private final TimePack timePack;
    private final List<Map<String, Object>> archivedTableInfo;
    private JSONObject searchData;

    public ActivityArchiveAdapter(TimePack pack) {
        this.timePack = pack;
        this.archivedTableInfo = ActivityArchivedData.get().getArchivedTablesInfo(pack);
    }

    @Override
    public long getTotalCount(SelectQuery query) {
        if (this.archivedTableInfo != null && !this.archivedTableInfo.isEmpty()) {
            Object ruleID = this.findRuleID(query.getCriteria());
            return ActivityArchivedData.get().getHistoryCount(this.archivedTableInfo, ruleID, this.timePack);
        }
        return 0L;
    }

    @Override
    public LinkedList<HashMap<Column, Object>> page(SelectQuery query, int offset, int limit) throws Exception {
        if (limit == 0 || this.archivedTableInfo == null || this.archivedTableInfo.isEmpty()) {
            return null;
        }
        if (limit > 500) {
            limit = 500;
        }
        LinkedList<HashMap<Column, Object>> outerTable = new LinkedList<HashMap<Column, Object>>();
        Column column = Column.getColumn((String)"ActivityArchivedTablesInfo", (String)"INIT_DOC_TABLE_ID");
        Object providerID = this.findRuleID(query.getCriteria());
        for (Map<String, Object> tableInfo : this.archivedTableInfo) {
            long totalCount;
            String archivedTableName = (String)tableInfo.get("ActivityHistory");
            Long docIDArchiveTableID = (Long)tableInfo.get("DOCID_ARCHIVED_TABLE_ID");
            if (offset != 0 && (totalCount = ActivityArchivedData.get().getHistoryCount(archivedTableName, providerID, this.timePack)) < (long)offset) {
                offset = (int)((long)offset - totalCount);
                continue;
            }
            SelectQueryImpl customQuery = new SelectQueryImpl(Table.getTable((String)archivedTableName));
            customQuery.setRange(new Range(offset, limit));
            List columns = query.getSelectColumns();
            for (Column col : columns) {
                customQuery.addSelectColumn(Column.getColumn((String)archivedTableName, (String)col.getColumnName(), (String)col.getColumnAlias()));
            }
            Criteria timeCriteria = ActivityUtil.getTimeBasedCustomTableSuccessCriteria(archivedTableName, this.timePack);
            Criteria combined = providerID != null ? timeCriteria.and(new Criteria(Column.getColumn((String)archivedTableName, (String)"PROVIDER_ID"), providerID, 0)) : timeCriteria;
            combined = combined.and(new Criteria(Column.getColumn((String)archivedTableName, (String)"IS_PRIMARY"), (Object)true, 0));
            if (this.searchData != null) {
                JSONObject extraInfo = this.searchData.getJSONObject("EXTRA_PARAMS");
                boolean isFiltering = extraInfo.has("IS_FILTERING") && extraInfo.getBoolean("IS_FILTERING");
                Criteria criteria = ActivityTableSearchHandler.prepareSearchCriteria((Long)providerID, offset, limit, extraInfo.getString("UUID"), isFiltering, this.searchData.getJSONObject("SEARCH"), archivedTableName, this.timePack);
                if (criteria != null) {
                    combined = combined.and(criteria);
                }
            }
            customQuery.setCriteria(combined);
            LinkedList<HashMap<Column, Object>> archivedDataInfo = new LinkedList<HashMap<Column, Object>>();
            limit -= DefaultDataSource.loadArchiveRequestResult("ActivityHistory", (SelectQuery)customQuery, archivedDataInfo);
            for (HashMap hashMap : archivedDataInfo) {
                hashMap.put(column, docIDArchiveTableID);
                outerTable.add(hashMap);
            }
            if (limit <= 0) break;
            offset = 0;
        }
        return outerTable;
    }

    public void setSearchCriteria(JSONObject searchData) {
        this.searchData = searchData;
    }

    private Object findRuleID(Criteria parentCriteria) {
        if (parentCriteria == null) {
            return null;
        }
        if (parentCriteria.getLeftCriteria() != null && parentCriteria.getRightCriteria() != null) {
            Object ruleID = this.findRuleID(parentCriteria.getLeftCriteria());
            if (ruleID != null) {
                return ruleID;
            }
            ruleID = this.findRuleID(parentCriteria.getRightCriteria());
            if (ruleID != null) {
                return ruleID;
            }
            return null;
        }
        if (this.isValidCriteria(parentCriteria)) {
            return parentCriteria.getValue();
        }
        return null;
    }

    private boolean isValidCriteria(Criteria result) {
        Column column = result.getColumn();
        if (column != null) {
            return column.getTableAlias().equals("ActivityHistory") && column.getColumnName().equals("PROVIDER_ID");
        }
        return false;
    }
}

