/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.adapter;

import com.manageengine.ela.server.common.client.adapters.ClientAggIndexTableDataAdapter;
import com.manageengine.ela.server.common.client.datasource.FieldInfo;
import com.manageengine.ela.server.common.client.structure.TableUniqueIdentifier;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.cardinality.Cardinality;
import org.json.JSONArray;

public class FieldBasedIndexAdapter
extends ClientAggIndexTableDataAdapter {
    public static final String AGGREGATION_COUNT_KEY = "COUNT";
    public static final String PRIMARY_AGGREGATION_KEY = "PRIMARY";
    public static final String SECONDARY_AGGREGATION_KEY = "SECONDARY";
    private static final Logger LOGGER = Logger.getLogger(FieldBasedIndexAdapter.class.getName());

    public FieldBasedIndexAdapter(TableUniqueIdentifier tableIdentifier, Locale locale, TimeZone timeZone, Long userID) throws BaseStatusCode {
        super(tableIdentifier, locale, timeZone, userID);
    }

    @Override
    protected JSONArray normalizeData(SearchResponse response, int start, int pageLength) {
        LinkedList<HashMap<FieldInfo<String>, Object>> res = new LinkedList<HashMap<FieldInfo<String>, Object>>();
        try {
            if (response != null && response.getHits().getTotalHits() > 0L) {
                int begin;
                List<FieldInfo<String>> fields = this.getAllColumns();
                Terms uNames = (Terms)response.getAggregations().get(PRIMARY_AGGREGATION_KEY);
                Cardinality count = (Cardinality)response.getAggregations().get(AGGREGATION_COUNT_KEY);
                this.hitCount = count.getValue();
                for (int i = begin = start - 1; i < begin + pageLength && (long)i < this.hitCount; ++i) {
                    Terms.Bucket bucket = (Terms.Bucket)uNames.getBuckets().get(i);
                    String mainField = bucket.getKeyAsString();
                    Long aggrCount = bucket.getDocCount();
                    if (bucket.getAggregations().getAsMap().size() <= 0) continue;
                    HashMap<FieldInfo<String>, Object> map = new HashMap<FieldInfo<String>, Object>();
                    Terms hNames = (Terms)bucket.getAggregations().get(SECONDARY_AGGREGATION_KEY);
                    String subField = hNames.getBuckets().stream().map(MultiBucketsAggregation.Bucket::getKeyAsString).collect(Collectors.joining(", "));
                    map.put(fields.get(0), mainField);
                    map.put(fields.get(1), aggrCount);
                    map.put(fields.get(2), subField);
                    res.add(map);
                }
                return this.getTransformedData(res);
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.INFO, "Error occurred during normalization {0}", exp.getMessage());
        }
        return new JSONArray();
    }

    @Override
    protected SearchResponse checkAndGetResponse(SearchResponse response, int maxNeeded) {
        Terms uNames;
        if (response != null && (uNames = (Terms)response.getAggregations().get(PRIMARY_AGGREGATION_KEY)).getBuckets().size() >= maxNeeded) {
            return response;
        }
        return null;
    }
}

