/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.analyzer;

import com.google.common.collect.ImmutableMap;
import com.manageengine.ela.server.correlation.core.analyzer.AnalyzerInput;
import com.manageengine.ela.server.correlation.core.analyzer.CommonAnalyzer;
import com.manageengine.ela.server.correlation.core.analyzer.selector.PreProcessDataSelector;
import com.manageengine.ela.server.correlation.core.analyzer.selector.RuleSelector;
import com.manageengine.ela.server.correlation.core.data.FieldDataContainer;
import com.manageengine.ela.server.correlation.core.data.ResponseContainer;
import com.manageengine.ela.server.correlation.core.data.SortedContainer;
import com.manageengine.ela.server.correlation.session.constants.ActivityRuleType;
import com.manageengine.ela.server.correlation.session.data.ActPreProcessDataHandler;
import com.manageengine.ela.server.correlation.session.data.ActivityDataHelper;
import com.manageengine.ela.server.correlation.session.info.ActivityProviderInfo;
import com.manageengine.ela.server.correlation.session.listener.ActivitySuccessListener;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BreakerAnalyzer
extends CommonAnalyzer {
    private static final Logger LOGGER = Logger.getLogger(BreakerAnalyzer.class.getName());
    FieldDataContainer breakerContainer;
    ActivityProviderInfo providerInfo;

    public BreakerAnalyzer(AnalyzerInput input, ActivitySuccessListener callBack, FieldDataContainer breakerContainer, ActivityProviderInfo providerInfo) {
        super(input, callBack, ((CommonAnalyzer)providerInfo.getExecutor()).getStatusHandler());
        this.breakerContainer = breakerContainer;
        this.providerInfo = providerInfo;
    }

    @Override
    protected void startCorrelationAnalysisProcess() {
        LOGGER.log(Level.FINE, "Invoked activity breaker analyzer.");
        AnalyzerInput input = super.getAnalyzerInput();
        RuleSelector selector = this.getDefaultRuleSelector(input);
        if (selector == null) {
            LOGGER.log(Level.INFO, "RuleSelector is null. Aborted");
            return;
        }
        long initRuleID = this.providerInfo.getInitiator().getRuleID();
        selector.attachDependentFields(initRuleID, ActivityDataHelper.prepareDependentFieldSelectors(this.providerInfo, initRuleID));
        int combinations = 0;
        do {
            Map<Long, SortedContainer> processThis;
            if ((processThis = selector.next()) == null || processThis.isEmpty()) continue;
            ++combinations;
            LOGGER.log(Level.FINER, "Selector moved to next point : {0}", processThis);
            this.process(selector, processThis);
        } while (selector.hasNext());
        LOGGER.log(Level.FINER, "Breaker analyzer process completed for rule : {0},  combinations {1}", new Object[]{input.getIdentity(), combinations});
    }

    @Override
    protected final RuleSelector getDefaultRuleSelector(AnalyzerInput input) {
        Long initRuleID = this.providerInfo.getInitiator().getRuleID();
        Long breakerID = this.providerInfo.getBreaker().getRuleID();
        ImmutableMap containerMap = ImmutableMap.of((Object)initRuleID, (Object)input.getContainer().getFieldDataContainer(initRuleID), (Object)breakerID, (Object)this.breakerContainer);
        ActPreProcessDataHandler dataHandler = new ActPreProcessDataHandler(this.providerInfo.getRuleID(), containerMap.keySet(), (Map<Long, FieldDataContainer>)containerMap, ActivityRuleType.INIT_BREAKER_RULE);
        Map<Long, Map<String, Map<String, Long>>> limitMap = PreProcessDataSelector.getCurrentProcessingLimitMap(dataHandler);
        if (limitMap == null || limitMap.isEmpty()) {
            return null;
        }
        return PreProcessDataSelector.createRuleContainerSelector(limitMap, dataHandler);
    }

    protected void process(RuleSelector selector, Map<Long, SortedContainer> data) {
        try {
            Long initiatorID = this.providerInfo.getInitiator().getRuleID();
            Long breakerID = this.providerInfo.getBreaker().getRuleID();
            SortedContainer initiatorContainer = data.get(initiatorID);
            SortedContainer breakerContainer = data.get(breakerID);
            block2: for (Map.Entry breakerEntry : breakerContainer.getDirectMap().entrySet()) {
                List termDocList = (List)breakerEntry.getValue();
                Long breakerTime = (Long)breakerEntry.getKey();
                ResponseContainer breakerResponse = new ResponseContainer(breakerContainer);
                for (int i = 0; i < termDocList.size(); ++i) {
                    ResponseContainer initiatorResponse = new ResponseContainer(initiatorContainer);
                    for (Map.Entry initiatorEntry : initiatorContainer.getDirectMap().entrySet()) {
                        if ((Long)initiatorEntry.getKey() > breakerTime) break;
                        initiatorResponse.setLimit((Long)initiatorEntry.getKey(), ((List)initiatorEntry.getValue()).size());
                    }
                    if (initiatorResponse.getSelectedData().isEmpty()) continue block2;
                    breakerResponse.setLimit(breakerTime, 1);
                    ImmutableMap responseMap = ImmutableMap.of((Object)initiatorID, (Object)initiatorResponse, (Object)breakerID, (Object)breakerResponse);
                    ((ActivitySuccessListener)super.getCallBack()).callBack((Map<Long, ResponseContainer>)responseMap, this.providerInfo, ActivityRuleType.INIT_BREAKER_RULE);
                    super.clean(selector, data, (Map<Long, ResponseContainer>)responseMap);
                }
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.INFO, "Error occurred during activity processing {0}", exp.getMessage());
        }
    }
}

