/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.analyzer;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.correlation.core.constants.ExecutorStatus;
import com.manageengine.ela.server.correlation.core.executors.CorrelationExecutor;
import com.manageengine.ela.server.correlation.core.status.StatusHandler;
import com.manageengine.ela.server.correlation.core.status.StatusHandlerImpl;
import com.manageengine.ela.server.correlation.session.constants.ActivityConstants;
import com.manageengine.ela.server.correlation.session.data.ActivityDocData;
import com.manageengine.ela.server.correlation.session.info.ActivityProviderInfo;
import com.manageengine.ela.server.correlation.session.listener.helper.WinListenerHelper;
import com.manageengine.ela.server.correlation.session.search.ActivityNoSqlSearch;
import com.manageengine.ela.server.correlation.session.search.NoSqlSearchRequest;
import com.manageengine.ela.server.correlation.session.util.ActivityUtil;
import com.zoho.za.dae.elastic.LogIndexer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;

public class WinActivityInitiatorAnalyzer
implements CorrelationExecutor {
    private static final Logger LOGGER = Logger.getLogger(WinActivityInitiatorAnalyzer.class.getName());
    private static final WinActivityInitiatorAnalyzer INSTANCE = new WinActivityInitiatorAnalyzer(new StatusHandlerImpl());
    private final Map<String, ActivityDocData> activityDocDataList;
    private StatusHandler statusHandler;
    private Lock mainLock;

    private WinActivityInitiatorAnalyzer(StatusHandler statusHandler) {
        this.statusHandler = statusHandler;
        this.activityDocDataList = new ConcurrentHashMap<String, ActivityDocData>();
        this.mainLock = new ReentrantLock(true);
    }

    public static WinActivityInitiatorAnalyzer getInstance() {
        return INSTANCE;
    }

    public int enqueue(ActivityDocData data) {
        this.mainLock.lock();
        try {
            this.activityDocDataList.put(data.getDocID(), data);
            LOGGER.log(Level.FINEST, "Entry added to win analyzer {0} size = {1}", new Object[]{data.getDocID(), this.activityDocDataList.size()});
            int n = this.activityDocDataList.size();
            return n;
        }
        finally {
            this.mainLock.unlock();
        }
    }

    public int getQueueSize() {
        return this.activityDocDataList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        LOGGER.log(Level.FINER, "No.of logs to process {0}", this.activityDocDataList.size());
        this.mainLock.lock();
        try {
            ArrayList<String> toDelete = new ArrayList<String>();
            Map<String, Map<String, Object>> logData = ActivityNoSqlSearch.resolveLogs(this.getDocList(), this.getIndices());
            if (logData == null) {
                LOGGER.log(Level.FINE, "Skipping total {0} logs for now since it is not properly indexed, yet.", this.activityDocDataList.size());
                return;
            }
            for (ActivityDocData entry : this.activityDocDataList.values()) {
                String logonID = null;
                try {
                    entry.setIndexUpdateNeeded(false);
                    boolean isDummyEvent = false;
                    Map<String, Object> source = logData.get(entry.getDocID());
                    logonID = source.get("LOGONID").toString();
                    boolean isLockUnlock = this.isLockUnlockEvent(entry, source);
                    LOGGER.log(Level.FINER, "Starting analysis on windows session log with logon id {0}", logonID);
                    if (isLockUnlock) {
                        LOGGER.log(Level.FINE, "Skipping session {0} since it is lock unlock event. LogonID = {1}", new Object[]{entry.getDocID(), logonID});
                    } else {
                        LOGGER.log(Level.FINER, "Not a lock unlock event. Checking for duplicate  {0}", logonID);
                        SearchResponse response = ActivityNoSqlSearch.doSearch(this.getSearchRequest(source));
                        if (response == null) {
                            LOGGER.log(Level.WARNING, "Elastic search failed during duplicate event check for session {0}", logonID);
                        } else {
                            SearchHits hits = ActivityNoSqlSearch.doSearch(this.getSearchRequest(source)).getHits();
                            if (hits.getTotalHits() > 1L) {
                                LOGGER.log(Level.FINEST, "Duplicate hit count is more than 1, {0}", hits.getTotalHits());
                                SearchHit primaryHit = null;
                                SearchHit secHit = null;
                                if (hits.getTotalHits() == 2L) {
                                    if (hits.getAt(0).getSource().get("LOGONID").equals(logonID)) {
                                        primaryHit = hits.getAt(0);
                                        secHit = hits.getAt(1);
                                    } else if (hits.getAt(1).getSource().get("LOGONID").equals(logonID)) {
                                        primaryHit = hits.getAt(1);
                                        secHit = hits.getAt(0);
                                    }
                                } else {
                                    Map.Entry<SearchHit, SearchHit> result = this.resolveHit(hits, logonID, ActivityUtil.getProviderInfo(entry.getProviderID()).getInitiator().getID());
                                    primaryHit = result.getKey();
                                    secHit = result.getValue();
                                }
                                if (primaryHit != null && secHit != null) {
                                    LOGGER.log(Level.FINEST, "Primary and secondary hits are found! {0}", entry.getDocID());
                                    Long initID = ActivityUtil.getProviderInfo(entry.getProviderID()).getInitiator().getID();
                                    DataObject dataObject = this.getLinkData(initID, new String[]{secHit.getId()});
                                    if (dataObject.containsTable("ActivityInitiatorDocID")) {
                                        Long historyID = WinListenerHelper.getInstance().registerSession(entry, source, Boolean.FALSE);
                                        Row initDocID = dataObject.getFirstRow("ActivityInitiatorDocID");
                                        Row row = new Row("WinActivityLinkInfo");
                                        row.set("PRIMARY_HISTORY_ID", initDocID.get("HISTORY_ID"));
                                        row.set("SECONDARY_HISTORY_ID", (Object)historyID);
                                        row.set("SEC_LOGON_ID", primaryHit.getSource().get("LOGONID"));
                                        dataObject.addRow(row);
                                        PersistenceDBUtil.getPersistence().update(dataObject);
                                        isDummyEvent = true;
                                        LOGGER.log(Level.FINER, "{0} has been registered as duplicate", logonID);
                                    } else {
                                        LOGGER.log(Level.FINEST, "Duplicate match was skipped since first DB entry is not registered. {0}", entry.getDocID());
                                    }
                                }
                            } else {
                                LOGGER.log(Level.FINER, "Duplicate check search returned non-positive result {0} for doc {1}", new Object[]{hits.getTotalHits(), entry.getDocID()});
                            }
                        }
                        if (!isDummyEvent) {
                            Long historyID = WinListenerHelper.getInstance().registerSession(entry, source, Boolean.TRUE);
                            ActivityProviderInfo providerInfo = ActivityUtil.getProviderInfo(entry.getProviderID());
                            Map<String, Object> indexMap = ActivityUtil.getDefaultIndexUpdateData(entry.getProviderID(), historyID, providerInfo.getInitiator().getPrimaryActionID());
                            indexMap.put("ACT_FLAG", "IN");
                            ActivityUtil.updateIndexedLog(indexMap, entry.getDocID(), LogIndexer.getIndexName((Object)entry.getTime()));
                            LOGGER.log(Level.FINE, "New windows session added with logon id {0} and docID {1}", new Object[]{source.get("LOGONID"), entry.getDocID()});
                        } else {
                            LOGGER.log(Level.FINE, "Skipping session {0} having logonID {1} since it is dummy event.", new Object[]{entry.getDocID(), logonID});
                        }
                    }
                    toDelete.add(entry.getDocID());
                }
                catch (Exception exp) {
                    LOGGER.log(Level.WARNING, "Error occurred during windows activity processing {0}", new Object[]{exp.getMessage()});
                }
                LOGGER.log(Level.FINER, "Completed analysis for session with logon id {0}", logonID);
            }
            LOGGER.log(Level.FINER, "Wiping processed entries {0}", toDelete);
            toDelete.forEach(this.activityDocDataList::remove);
            toDelete.clear();
            LOGGER.log(Level.FINER, "WinActivityInitiatorAnalyzer revoked. Current list size = {0}", this.activityDocDataList.size());
        }
        finally {
            this.mainLock.unlock();
        }
    }

    @Override
    public Object getIdentity() {
        return "Win-Session init processor";
    }

    private Map.Entry<SearchHit, SearchHit> resolveHit(SearchHits hits, String logonID, Long initID) {
        SearchHit primaryHit = null;
        SearchHit secondaryHit = null;
        try {
            LOGGER.log(Level.FINEST, "Invoked resolveHit with total hits = {0}", hits.getHits().length);
            HashMap<String, SearchHit> map = new HashMap<String, SearchHit>();
            for (int i = 0; i < hits.getHits().length; ++i) {
                SearchHit searchHit = hits.getAt(i);
                if (searchHit.getSource().get("LOGONID").equals(logonID)) {
                    LOGGER.log(Level.FINEST, "Primary hit position = {0}", i);
                    primaryHit = searchHit;
                    continue;
                }
                map.put(searchHit.getId(), searchHit);
            }
            DataObject dataObject = this.getLinkData(initID, map.keySet().toArray(new String[map.keySet().size()]));
            if (dataObject != null && dataObject.containsTable("ActivityInitiatorDocID")) {
                String docID = (String)dataObject.getFirstValue("ActivityInitiatorDocID", "DOC_ID");
                SearchHit searchHit = (SearchHit)map.get(docID);
                if (searchHit != null) {
                    LOGGER.log(Level.FINEST, "Secondary hit found! {0}", searchHit.getId());
                    secondaryHit = searchHit;
                } else {
                    LOGGER.log(Level.FINEST, "Map resolution failed");
                }
            } else {
                LOGGER.log(Level.FINEST, "resolved hits couldn't find any duplicated entries in the db for {0}", logonID);
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.INFO, "Error occurred during processing resolveHit {0}", exp.getMessage());
        }
        return new AbstractMap.SimpleEntry<Object, Object>(primaryHit, secondaryHit);
    }

    @Override
    public void setStatus(ExecutorStatus status) {
        this.statusHandler.setStatus(status);
    }

    @Override
    public boolean isBusy() {
        return this.statusHandler.isBusy();
    }

    private NoSqlSearchRequest getSearchRequest(Map log) {
        List<String> commonFields = Arrays.asList("USERNAME", "LOGONTYPE", "HOSTNAME");
        Long time = Long.parseLong(log.get("TIME").toString());
        Long timeDisplacement = 1000L;
        Long startTime = time - timeDisplacement;
        Long endTime = time + timeDisplacement;
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.rangeQuery((String)"TIME").from((Object)startTime).to((Object)endTime));
        for (String field : commonFields) {
            queryBuilder = queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)field, log.get(field)));
        }
        queryBuilder = queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"EVENTID", (Object)ActivityConstants.ACCOUNT_LOGON_EVENT_ID));
        return new NoSqlSearchRequest(startTime, endTime).setQuery((QueryBuilder)queryBuilder).setSize(10);
    }

    private DataObject getLinkData(Long initID, String[] docs) throws DataAccessException {
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ActivityInitiatorDocID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ActivityInitiatorDocID", (String)"*"));
        Criteria criteria = new Criteria(Column.getColumn((String)"ActivityInitiatorDocID", (String)"DOC_ID"), (Object)docs, 8).and(new Criteria(Column.getColumn((String)"ActivityInitiatorDocID", (String)"INITIATOR_ID"), (Object)initID, 0));
        selectQuery.setCriteria(criteria);
        return PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
    }

    private boolean isLockUnlockEvent(ActivityDocData docData, Map log) throws Exception {
        Long time = Long.parseLong(log.get("TIME").toString());
        Long endTime = time + 4000L;
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.rangeQuery((String)"TIME").from((Object)time).to((Object)endTime));
        queryBuilder = queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"LOGONID", log.get("LOGONID")));
        BoolQueryBuilder events = QueryBuilders.boolQuery();
        events = events.should((QueryBuilder)QueryBuilders.termQuery((String)"EVENTID", (Object)ActivityConstants.ACCOUNT_LOGOFF_EVENT_ID));
        SearchResponse response = ActivityNoSqlSearch.doSearch(new NoSqlSearchRequest(time, endTime).setQuery((QueryBuilder)(queryBuilder = queryBuilder.must((QueryBuilder)(events = events.should((QueryBuilder)QueryBuilders.termQuery((String)"EVENTID", (Object)ActivityConstants.USER_INITIATED_LOGOFF_EVENT_ID)))))).setSize(2));
        if (response == null) {
            throw BaseStatusCode.getBaseStatusCode(16386);
        }
        if (response.getHits().totalHits() > 0L) {
            LOGGER.log(Level.FINE, "{0} is related to lock unlock event. Not a proper session", docData.getDocID());
            return true;
        }
        return false;
    }

    private List<String> getDocList() {
        return this.activityDocDataList.values().stream().map(ActivityDocData::getDocID).collect(Collectors.toList());
    }

    private String[] getIndices() {
        HashSet<String> indices = new HashSet<String>();
        for (ActivityDocData data : this.activityDocDataList.values()) {
            indices.add(LogIndexer.getIndexName((Object)data.getTime()));
        }
        return indices.toArray(new String[indices.size()]);
    }
}

