/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.analyzer;

import com.manageengine.ela.server.correlation.common.handler.ExecutorServiceHandler;
import com.manageengine.ela.server.correlation.session.analyzer.WinActivityInitiatorAnalyzer;
import com.manageengine.ela.server.correlation.session.data.ActivityDocData;
import com.manageengine.ela.server.correlation.session.processor.ActivityRequestExecutor;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WinActivityInitiatorReqHandler {
    private static final Logger LOGGER = Logger.getLogger(WinActivityInitiatorReqHandler.class.getName());
    private static final ScheduledExecutorService DISPATCHER;
    private static final WinActivityInitiatorReqHandler INSTANCE;

    public static WinActivityInitiatorReqHandler getInstance() {
        return INSTANCE;
    }

    public static void enqueueDoc(ActivityDocData docData, Map map) {
        int size = WinActivityInitiatorAnalyzer.getInstance().enqueue(docData);
        if (size > 10) {
            WinActivityInitiatorReqHandler.processRequests();
            LOGGER.log(Level.FINER, "Activity initiator queue size limit exceeded. Doing force process. Size = {0}", size);
        }
        LOGGER.log(Level.FINER, "Queued doc for win-session analysis {0} Current queue size {1}", new Object[]{docData.getDocID(), size});
    }

    private static void processRequests() {
        try {
            ActivityRequestExecutor.add(WinActivityInitiatorAnalyzer.getInstance());
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, "Error occurred during windows activity initiator processing {0}", exp.getMessage());
        }
    }

    private static void handleRequests() {
        if (WinActivityInitiatorAnalyzer.getInstance().getQueueSize() > 0) {
            LOGGER.log(Level.FINE, "Invoking windows initiator analyzer");
            WinActivityInitiatorReqHandler.processRequests();
        }
    }

    static {
        INSTANCE = new WinActivityInitiatorReqHandler();
        DISPATCHER = new ScheduledThreadPoolExecutor(1){

            @Override
            protected void beforeExecute(Thread paramThread, Runnable paramRunnable) {
                paramThread.setName("correlation[session][init][dispatcher]");
                super.beforeExecute(paramThread, paramRunnable);
            }
        };
        DISPATCHER.scheduleWithFixedDelay(() -> {
            try {
                WinActivityInitiatorReqHandler.handleRequests();
            }
            catch (Throwable throwable) {
                LOGGER.log(Level.WARNING, "Error occurred during windows activity processing {0}", throwable);
            }
        }, 0L, 10000L, TimeUnit.MILLISECONDS);
        ExecutorServiceHandler.registerExecutorForShutdown(DISPATCHER);
    }
}

