/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.auditdata;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.TimePack;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ela.server.correlation.auditdata.CorrelationNosqlData;
import com.manageengine.ela.server.correlation.session.auditdata.ActivityArchivedData;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ActNoSqlIndexData {
    private static final Logger LOGGER = Logger.getLogger(ActNoSqlIndexData.class.getName());

    protected static Map<Long, Map<Long, Map<String, List<String>>>> getFormattedDocIDInfo(DataSet dataSet, Map<Long, Map<Long, Map<String, List<String>>>> formattedDocIDs) throws SQLException {
        while (dataSet.next()) {
            Long actionConfigID = dataSet.getAsLong(1);
            Long ruleHistoryID = dataSet.getAsLong(2);
            String docID = dataSet.getAsString(3);
            String indexName = dataSet.getAsString(4);
            Map actionConfigMap = formattedDocIDs.computeIfAbsent(ruleHistoryID, k -> new HashMap());
            Map indexMap = actionConfigMap.computeIfAbsent(actionConfigID, k -> new HashMap());
            List docIDList = indexMap.computeIfAbsent(indexName, k -> new ArrayList());
            docIDList.add(docID);
        }
        return formattedDocIDs;
    }

    public static Map<Long, Map<Long, List<Map<String, Object>>>> resolveCustomFieldsInfo(List<Long> historyID_direct, Map<Long, List<Long>> docID_archive, TimePack pack) throws DataAccessException {
        Map<Long, Map<Long, Map<String, List<String>>>> liveDocIDs;
        HashMap<Long, Map<Long, Map<String, List<String>>>> formattedDocIDs = new HashMap<Long, Map<Long, Map<String, List<String>>>>();
        if (historyID_direct != null && !historyID_direct.isEmpty()) {
            SelectQuery query = ActNoSqlIndexData.prepareSelectQuery(historyID_direct, "ActivityInitiatorDocID");
            ActNoSqlIndexData.resolveCustomFieldsInfo(query, formattedDocIDs);
            query = ActNoSqlIndexData.prepareSelectQuery(historyID_direct, "ActivityEndDocID");
            ActNoSqlIndexData.resolveCustomFieldsInfo(query, formattedDocIDs);
        }
        if (docID_archive != null && !docID_archive.isEmpty() && (liveDocIDs = ActNoSqlIndexData.getFormattedDocIDInfoFromArchiveLimited(docID_archive)) != null) {
            formattedDocIDs.putAll(liveDocIDs);
        }
        return CorrelationNosqlData.searchIndexForCustomFields(formattedDocIDs, pack);
    }

    private static SelectQuery prepareSelectQuery(List<Long> historyID_direct, String docTableName) {
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ActivityHistory"));
        query.addJoin(new Join("ActivityHistory", docTableName, new String[]{"HISTORY_ID"}, new String[]{"HISTORY_ID"}, 2));
        query.addJoin(new Join(docTableName, "NoSqlIndexDetails", new String[]{"INDEX_ID"}, new String[]{"INDEX_ID"}, 2));
        query.setCriteria(new Criteria(Column.getColumn((String)"ActivityHistory", (String)"HISTORY_ID"), (Object)historyID_direct.toArray(new Long[historyID_direct.size()]), 8));
        query.addSelectColumn(Column.getColumn((String)docTableName, (String)"ACTION_CONFIG_ID"));
        query.addSelectColumn(Column.getColumn((String)docTableName, (String)"HISTORY_ID"));
        query.addSelectColumn(Column.getColumn((String)docTableName, (String)"DOC_ID"));
        query.addSelectColumn(Column.getColumn((String)"NoSqlIndexDetails", (String)"INDEX_NAME"));
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resolveCustomFieldsInfo(SelectQuery query, Map<Long, Map<Long, Map<String, List<String>>>> formattedDocIDs) throws DataAccessException {
        block5: {
            Connection connection = null;
            DataSet dataSet = null;
            try {
                RelationalAPI api = RelationalAPI.getInstance();
                connection = api.getConnection();
                dataSet = api.executeQuery((Query)query, connection);
                ActNoSqlIndexData.getFormattedDocIDInfo(dataSet, formattedDocIDs);
                DBUtil.closeResultSetOrDataSet(null, dataSet);
            }
            catch (Exception exp) {
                exp.printStackTrace();
                break block5;
            }
            finally {
                DBUtil.closeResultSetOrDataSet(null, dataSet);
                DBUtil.closeStmtAndConnection(null, connection);
            }
            DBUtil.closeStmtAndConnection(null, connection);
        }
    }

    protected static Map<Long, Map<Long, Map<String, List<String>>>> getFormattedDocIDInfoFromArchiveLimited(Map<Long, List<Long>> docID_archive) throws DataAccessException {
        HashMap<Long, Map<Long, Map<Long, List<String>>>> unresolvedIndexAndDocIDMap = new HashMap<Long, Map<Long, Map<Long, List<String>>>>();
        docID_archive.forEach((docIDTable, historyIDList) -> {
            try {
                Map<Long, Map<Long, Map<Long, List<String>>>> indInfo = ActivityArchivedData.get().getArchivedDocInfoLimited((Long)docIDTable, (List<Long>)historyIDList);
                if (indInfo != null && !indInfo.isEmpty()) {
                    unresolvedIndexAndDocIDMap.putAll(indInfo);
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        });
        return CorrelationNosqlData.resolveIndexNameFromIndexID(unresolvedIndexAndDocIDMap);
    }
}

