/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.auditdata;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.la.TimePack;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ela.server.correlation.common.archive.ArchivedData;
import com.manageengine.ela.server.correlation.session.util.ActivityUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ActivityArchivedData
extends ArchivedData {
    private static final ActivityArchivedData INSTANCE = new ActivityArchivedData();

    public static ActivityArchivedData get() {
        return INSTANCE;
    }

    @Override
    protected String getArchiveDataTableName() {
        return "ActivityArchivedTablesInfo";
    }

    @Override
    protected String getBaseTableName() {
        return "ActivityHistory";
    }

    @Override
    public long getHistoryCount(String customTableName, Object ruleID, TimePack timePack) {
        SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)customTableName));
        Column countColumn = Column.getColumn(null, (String)"*");
        sq.addSelectColumn(countColumn.count());
        Criteria criteria = new Criteria(Column.getColumn((String)customTableName, (String)"PROVIDER_ID"), ruleID, 0).and(new Criteria(Column.getColumn((String)customTableName, (String)"IS_PRIMARY"), (Object)true, 0));
        sq.setCriteria(criteria.and(ActivityUtil.getTimeBasedCustomTableSuccessCriteria(customTableName, timePack)));
        return DBUtil.getTotalLongCountArchiveTable((SelectQuery)sq);
    }

    @Override
    public Map<Long, Map<Long, Map<Long, List<String>>>> getArchivedDocInfoLimited(Long docIDTable, List<Long> historyIDList) throws DataAccessException {
        String tableName = this.getArchivedTableName(docIDTable);
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)tableName));
        query.addSelectColumn(Column.getColumn((String)tableName, (String)"ACTION_CONFIG_ID"));
        query.addSelectColumn(Column.getColumn((String)tableName, (String)"HISTORY_ID"));
        query.addSelectColumn(Column.getColumn((String)tableName, (String)"INDEX_ID"));
        query.addSelectColumn(Column.getColumn((String)tableName, (String)"DOC_ID"));
        query.addSortColumn(new SortColumn(Column.getColumn((String)tableName, (String)"UNIQUE_ID"), true));
        query.setCriteria(new Criteria(Column.getColumn((String)tableName, (String)"HISTORY_ID"), (Object)historyIDList.toArray(new Long[historyIDList.size()]), 8));
        return this.getArchivedDocIDInfo((SelectQuery)query);
    }

    @Override
    protected List<Map<String, Object>> getArchivedTablesInfo(Criteria criteria) {
        String HISTORY_TABLE = "HISTORY_TABLE";
        String INIT_DOCID_TABLE = "INIT_DOCID_TABLE";
        String END_DOCID_TABLE = "END_DOCID_TABLE";
        String WIN_LINK_TABLE = "WIN_LINK_TABLE";
        String WIN_STATUS_TABLE = "WIN_STATUS_TABLE";
        String tableName = this.getArchiveDataTableName();
        Table corrArchiveInfo = Table.getTable((String)tableName);
        ArrayList<Map<String, Object>> archivedTables = new ArrayList<Map<String, Object>>();
        SelectQueryImpl query = new SelectQueryImpl(corrArchiveInfo);
        query.addJoin(new Join(corrArchiveInfo, Table.getTable((String)"ArchiveTableDetails", (String)"HISTORY_TABLE"), new String[]{"HISTORY_TABLE_ID"}, new String[]{"ARCHIVE_TABLE_ID"}, 2));
        query.addJoin(new Join(corrArchiveInfo, Table.getTable((String)"ArchiveTableDetails", (String)"INIT_DOCID_TABLE"), new String[]{"INIT_DOC_TABLE_ID"}, new String[]{"ARCHIVE_TABLE_ID"}, 2));
        query.addJoin(new Join(corrArchiveInfo, Table.getTable((String)"ArchiveTableDetails", (String)"END_DOCID_TABLE"), new String[]{"END_DOC_TABLE_ID"}, new String[]{"ARCHIVE_TABLE_ID"}, 2));
        query.addJoin(new Join(corrArchiveInfo, Table.getTable((String)"ArchiveTableDetails", (String)"WIN_LINK_TABLE"), new String[]{"WIN_LINK_TABLE_ID"}, new String[]{"ARCHIVE_TABLE_ID"}, 2));
        query.addJoin(new Join(corrArchiveInfo, Table.getTable((String)"ArchiveTableDetails", (String)"WIN_STATUS_TABLE"), new String[]{"WIN_ACT_STATUS_TABLE_ID"}, new String[]{"ARCHIVE_TABLE_ID"}, 2));
        query.setCriteria(criteria);
        query.addSelectColumn(Column.getColumn(null, (String)"*"));
        query.addSortColumn(new SortColumn(Column.getColumn((String)tableName, (String)"ARCHIVE_ID"), true));
        try {
            DataObject dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
            if (dobj.isEmpty()) {
                return archivedTables;
            }
            Iterator itr = dobj.getRows(tableName);
            while (itr.hasNext()) {
                HashMap<String, Object> tableMap = new HashMap<String, Object>();
                Row row = (Row)itr.next();
                Criteria archiveFile = new Criteria(Column.getColumn((String)"HISTORY_TABLE", (String)"ARCHIVE_TABLE_ID"), row.get("HISTORY_TABLE_ID"), 0);
                Row historyTableRow = dobj.getRow("HISTORY_TABLE", archiveFile);
                tableMap.put((String)historyTableRow.get("ACTUAL_TABLENAME"), historyTableRow.get("ARCHIVED_TABLENAME"));
                archiveFile = new Criteria(Column.getColumn((String)"INIT_DOCID_TABLE", (String)"ARCHIVE_TABLE_ID"), row.get("INIT_DOC_TABLE_ID"), 0);
                Row initDocIDRow = dobj.getRow("INIT_DOCID_TABLE", archiveFile);
                tableMap.put((String)initDocIDRow.get("ACTUAL_TABLENAME"), initDocIDRow.get("ARCHIVED_TABLENAME"));
                archiveFile = new Criteria(Column.getColumn((String)"END_DOCID_TABLE", (String)"ARCHIVE_TABLE_ID"), row.get("END_DOC_TABLE_ID"), 0);
                Row endDocIDRow = dobj.getRow("END_DOCID_TABLE", archiveFile);
                tableMap.put((String)endDocIDRow.get("ACTUAL_TABLENAME"), endDocIDRow.get("ARCHIVED_TABLENAME"));
                archiveFile = new Criteria(Column.getColumn((String)"WIN_LINK_TABLE", (String)"ARCHIVE_TABLE_ID"), row.get("WIN_LINK_TABLE_ID"), 0);
                Row winLinkRow = dobj.getRow("WIN_LINK_TABLE", archiveFile);
                tableMap.put((String)winLinkRow.get("ACTUAL_TABLENAME"), winLinkRow.get("ARCHIVED_TABLENAME"));
                archiveFile = new Criteria(Column.getColumn((String)"WIN_STATUS_TABLE", (String)"ARCHIVE_TABLE_ID"), row.get("WIN_ACT_STATUS_TABLE_ID"), 0);
                Row winStatusRow = dobj.getRow("WIN_STATUS_TABLE", archiveFile);
                tableMap.put((String)winStatusRow.get("ACTUAL_TABLENAME"), winStatusRow.get("ARCHIVED_TABLENAME"));
                tableMap.put("DOCID_ARCHIVED_TABLE_ID", row.get("INIT_DOC_TABLE_ID"));
                tableMap.put("START_TIME", row.get("START_TIME"));
                tableMap.put("END_TIME", row.get("END_TIME"));
                archivedTables.add(tableMap);
            }
            return archivedTables;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return archivedTables;
        }
    }

    public long loadActivityTrendData(Long providerID, TimePack time, long interval, Map<Long, Long> timeMap) throws Exception {
        List<Map<String, Object>> archivedTablesInfo = this.getArchivedTablesInfo(time);
        long totalLength = 0L;
        for (Map<String, Object> map : archivedTablesInfo) {
            String tableName = (String)map.get("ActivityHistory");
            SelectQueryImpl archiveQuery = new SelectQueryImpl(Table.getTable((String)tableName));
            archiveQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"START_TIME"));
            Criteria archiveCriteria = new Criteria(Column.getColumn((String)tableName, (String)"PROVIDER_ID"), (Object)providerID, 0);
            archiveQuery.setCriteria(archiveCriteria.and(ActivityUtil.getTimeBasedCustomTableSuccessCriteria(tableName, time)));
            totalLength += this.fillArchiveTrendInformation((SelectQuery)archiveQuery, interval, timeMap);
        }
        return totalLength;
    }
}

