/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.auditdata;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.la.TimePack;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.client.structure.ClientTableStructure;
import com.manageengine.ela.server.common.export.generators.MultiColumnJRXMLGenerator;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.util.DateFormatUtil;
import com.manageengine.ela.server.correlation.auditdata.CorrCustomDataHandler;
import com.manageengine.ela.server.correlation.core.constants.CorrelationStatus;
import com.manageengine.ela.server.correlation.session.auditdata.ActNoSqlIndexData;
import com.manageengine.ela.server.correlation.session.config.ActivityConfigMapping;
import com.manageengine.ela.server.correlation.session.constants.ActivityStatus;
import com.manageengine.ela.server.correlation.session.dataloader.ActArchiveDataLoader;
import com.manageengine.ela.server.correlation.session.dataloader.DataLoader;
import com.manageengine.ela.server.correlation.session.dataloader.DataLoaderController;
import com.manageengine.ela.server.correlation.session.info.ActivityProviderInfo;
import com.manageengine.ela.server.correlation.session.util.ActivityDataTransformUtil;
import com.manageengine.ela.server.correlation.session.util.ActivityUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.math.NumberUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ActivityCustomDataHandler {
    private static final Logger LOGGER = Logger.getLogger(ActivityCustomDataHandler.class.getName());

    public static JSONArray customizeDefaultTable(Long providerID, JSONArray resultJsonArray, Integer limit, TimePack pack, boolean isExport) throws BaseStatusCode {
        try {
            JSONArray result = ActivityCustomDataHandler.customizeDefaultTable(ActivityCustomDataHandler.getConfiguredColumns(providerID), providerID, resultJsonArray, pack);
            return ActivityCustomDataHandler.resolveSessionStatuses(result, providerID, isExport, pack);
        }
        catch (Exception exp) {
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
    }

    private static JSONArray customizeDefaultTable(Map<Long, List<Map<String, Object>>> configuredColumns, Long providerID, JSONArray resultJsonArray, TimePack pack) {
        try {
            if (resultJsonArray != null) {
                ArrayList<Long> historyID_direct = new ArrayList<Long>();
                HashMap<Long, List<Long>> docID_archive = new HashMap<Long, List<Long>>();
                String archiveColumn = "ActivityArchivedTablesInfo_INIT_DOC_TABLE_ID";
                for (int index = 0; index < resultJsonArray.length(); ++index) {
                    JSONObject object = resultJsonArray.getJSONObject(index);
                    Long historyID = object.getLong("ActivityHistory_HISTORY_ID");
                    if (object.has(archiveColumn)) {
                        Long docArchiveTableID = object.getLong(archiveColumn);
                        List list2 = docID_archive.computeIfAbsent(docArchiveTableID, k -> new ArrayList());
                        list2.add(historyID);
                    } else {
                        historyID_direct.add(historyID);
                    }
                    object.put("ActivityHistory_PROFILE_ID", (Object)ActivityConfigMapping.get().getProfileID(providerID));
                }
                Map<Long, Map<Long, List<Map<String, Object>>>> historyIDvsCustomFields = ActNoSqlIndexData.resolveCustomFieldsInfo(historyID_direct, docID_archive, pack);
                for (int index = 0; index < resultJsonArray.length(); ++index) {
                    try {
                        JSONObject object = resultJsonArray.getJSONObject(index);
                        Long historyID = object.getLong("ActivityHistory_HISTORY_ID");
                        Map<Long, List<Map<String, Object>>> resolveExtendedFields = historyIDvsCustomFields.get(historyID);
                        if (resolveExtendedFields == null) continue;
                        configuredColumns.forEach((ruleID, list) -> {
                            List data = (List)resolveExtendedFields.get(ruleID);
                            if (data != null) {
                                for (Map map2 : list) {
                                    try {
                                        String displayName = (String)map2.get("DISPLAY_NAME");
                                        String indexName = (String)map2.get("INDEX_NAME");
                                        StringBuilder builder = new StringBuilder();
                                        Object obj = ((Map)data.get(0)).get(indexName);
                                        builder.append(obj);
                                        object.put(displayName, (Object)(builder.length() > 0 ? builder.toString() : "-"));
                                    }
                                    catch (JSONException exp) {
                                        LOGGER.log(Level.FINE, "Error occurred during loading data {0}", exp);
                                    }
                                }
                            }
                        });
                        continue;
                    }
                    catch (Exception exp) {
                        LOGGER.log(Level.FINE, "Error occurred during loading data {0}", exp);
                    }
                }
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.FINE, "Error occurred during loading data {0}", exp);
        }
        return resultJsonArray;
    }

    private static JSONArray resolveSessionStatuses(JSONArray resultJsonArray, Long providerID, boolean isExport, TimePack timePack) throws Exception {
        CorrelationStatus currentRuleStatus = ActivityUtil.getProviderStatus(providerID);
        DataLoader loader = DataLoaderController.getLoader(providerID);
        ArrayList<Long> histList = new ArrayList<Long>();
        for (int index = 0; index < resultJsonArray.length(); ++index) {
            JSONObject object = resultJsonArray.getJSONObject(index);
            histList.add(object.getLong("ActivityHistory_HISTORY_ID"));
        }
        Map<Long, JSONObject> response = loader.getCurrentActivityStatus(histList, timePack);
        response.putAll(ActivityCustomDataHandler.resolveForArchivedData(resultJsonArray));
        SimpleDateFormat dateFormat = DateFormatUtil.getClientDateFormat2();
        dateFormat.setTimeZone(timePack.getTimeZone());
        for (int index = 0; index < resultJsonArray.length(); ++index) {
            JSONObject object = resultJsonArray.getJSONObject(index);
            ActivityStatus status = ActivityStatus.INITIATED;
            if (response.containsKey(object.getLong("ActivityHistory_HISTORY_ID"))) {
                Long endTime;
                JSONObject statusData = response.get(object.getLong("ActivityHistory_HISTORY_ID"));
                status = ActivityStatus.getStatus(statusData.getLong("STATUS"));
                Long startTime = dateFormat.parse(object.getString("ActivityHistory_START_TIME")).getTime();
                if (statusData.has("END_TIME")) {
                    endTime = statusData.getLong("END_TIME");
                    object.put("ActivityHistory_END_TIME", (Object)DateFormatUtil.getFormattedTimeForClient_1(endTime, timePack.getTimeZone()));
                    object.put("ActivityHistory_DURATION", (Object)ActivityUtil.getDefaultDuration(startTime, endTime));
                } else if (currentRuleStatus == CorrelationStatus.DISABLE && object.isNull("ActivityHistory_END_TIME") || status == ActivityStatus.INTERRUPTED) {
                    object.put("ActivityHistory_DURATION", (Object)new JSONObject().put("DURATION", (Object)"-"));
                } else if (object.has("ActivityHistory_END_TIME")) {
                    endTime = dateFormat.parse(object.getString("ActivityHistory_END_TIME")).getTime();
                    object.put("ActivityHistory_DURATION", (Object)ActivityUtil.getDefaultDuration(startTime, endTime));
                } else {
                    object.put("ActivityHistory_DURATION", (Object)ActivityUtil.getDefaultDuration(startTime, null));
                }
            }
            if (isExport) {
                object.put("ActivityHistory_STATUS", (Object)ActivityDataTransformUtil.prepareStatusObject(status).getString("STATUS_MESSAGE"));
                JSONObject durationInfo = object.getJSONObject("ActivityHistory_DURATION");
                String durationData = durationInfo.getString("DURATION");
                if (NumberUtils.isNumber((String)durationData)) {
                    object.put("ActivityHistory_DURATION", (Object)ActivityUtil.getDefaultDurationString(Long.parseLong(durationData)));
                    continue;
                }
                object.put("ActivityHistory_DURATION", (Object)durationData);
                continue;
            }
            object.put("ActivityHistory_STATUS", (Object)ActivityDataTransformUtil.prepareStatusObject(status));
        }
        return resultJsonArray;
    }

    private static Map<Long, JSONObject> resolveForArchivedData(JSONArray resultJsonArray) throws Exception {
        String archiveColumn = "ActivityArchivedTablesInfo_INIT_DOC_TABLE_ID";
        HashMap<Long, List> archivedData = new HashMap<Long, List>();
        for (int index = 0; index < resultJsonArray.length(); ++index) {
            JSONObject object = resultJsonArray.getJSONObject(index);
            if (!object.has(archiveColumn)) continue;
            Long docArchiveTableID = object.getLong(archiveColumn);
            Long historyID = object.getLong("ActivityHistory_HISTORY_ID");
            List data = archivedData.computeIfAbsent(docArchiveTableID, k -> new ArrayList());
            data.add(historyID);
        }
        HashMap<Long, JSONObject> resolvedData = new HashMap<Long, JSONObject>();
        for (Map.Entry entry : archivedData.entrySet()) {
            resolvedData.putAll(ActArchiveDataLoader.getActivityStatus((Long)entry.getKey(), ((List)entry.getValue()).toArray(new Long[((List)entry.getValue()).size()])));
        }
        return resolvedData;
    }

    public static Map<Long, List<Map<String, Object>>> getConfiguredColumns(Long providerID) throws BaseStatusCode {
        try {
            SelectQueryImpl configuredFields = new SelectQueryImpl(Table.getTable((String)"ActivityTableViewConfig"));
            configuredFields.addJoin(new Join(Table.getTable((String)"ActivityTableViewConfig"), Table.getTable((String)"CorrConfiguredActions"), new String[]{"ACTION_CONFIG_ID"}, new String[]{"CONFIG_ID"}, 1));
            configuredFields.addJoin(new Join(Table.getTable((String)"CorrConfiguredActions"), Table.getTable((String)"CorrActionCondnFields"), new String[]{"ACTION_ID"}, new String[]{"ACTION_ID"}, 1));
            configuredFields.addJoin(new Join(Table.getTable((String)"CorrActionCondnFields"), Table.getTable((String)"NoSqlIndexFields"), new String[]{"CONDN_FIELD_ID"}, new String[]{"FIELD_ID"}, 1));
            Criteria criteria = new Criteria(Column.getColumn((String)"ActivityTableViewConfig", (String)"PROVIDER_ID"), (Object)providerID, 0);
            configuredFields.setCriteria(criteria);
            configuredFields.addSelectColumn(Column.getColumn((String)"CorrConfiguredActions", (String)"CONFIG_ID"));
            configuredFields.addSelectColumn(Column.getColumn((String)"CorrActionCondnFields", (String)"FIELD_CONFIG_ID"));
            configuredFields.addSelectColumn(Column.getColumn((String)"CorrActionCondnFields", (String)"CONDN_FIELD_ID"));
            configuredFields.addSelectColumn(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_ID"));
            configuredFields.addSelectColumn(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_INDEX_NAME"));
            configuredFields.addSelectColumn(Column.getColumn((String)"ActivityTableViewConfig", (String)"TABLE_VIEW_ID"));
            configuredFields.addSelectColumn(Column.getColumn((String)"ActivityTableViewConfig", (String)"DISPLAY_NAME"));
            configuredFields.addSelectColumn(Column.getColumn((String)"ActivityTableViewConfig", (String)"DISPLAY_TYPE"));
            configuredFields.addSelectColumn(Column.getColumn((String)"ActivityTableViewConfig", (String)"FIELD_CONFIG_ID"));
            configuredFields.addSelectColumn(Column.getColumn((String)"ActivityTableViewConfig", (String)"ACTION_CONFIG_ID"));
            configuredFields.addSelectColumn(Column.getColumn((String)"ActivityTableViewConfig", (String)"RULE_ID"));
            configuredFields.addSelectColumn(Column.getColumn((String)"ActivityTableViewConfig", (String)"PROVIDER_ID"));
            configuredFields.addSortColumn(new SortColumn(Column.getColumn((String)"ActivityTableViewConfig", (String)"DISPLAY_ORDER"), true));
            DataObject dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)configuredFields);
            Iterator iterator = dobj.getRows("ActivityTableViewConfig");
            HashMap<Long, List<Map<String, Object>>> configuredCols = new HashMap<Long, List<Map<String, Object>>>();
            while (iterator.hasNext()) {
                try {
                    Row row = (Row)iterator.next();
                    if (!configuredCols.containsKey((Long)row.get("ACTION_CONFIG_ID"))) {
                        configuredCols.put((Long)row.get("ACTION_CONFIG_ID"), new ArrayList());
                    }
                    List columnList = (List)configuredCols.get(row.get("ACTION_CONFIG_ID"));
                    HashMap<String, Object> obj = new HashMap<String, Object>();
                    Criteria crit = new Criteria(Column.getColumn((String)"CorrActionCondnFields", (String)"FIELD_CONFIG_ID"), row.get("FIELD_CONFIG_ID"), 0);
                    Row actionCondnRow = dobj.getRow("CorrActionCondnFields", crit);
                    crit = new Criteria(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_ID"), actionCondnRow.get("CONDN_FIELD_ID"), 0);
                    Row indexRow = dobj.getRow("NoSqlIndexFields", crit);
                    String displayName = String.format("Rule_%s_Action_%s_Field_%s_", row.get("RULE_ID"), row.get("ACTION_CONFIG_ID"), row.get("FIELD_CONFIG_ID"));
                    obj.put("DISPLAY_NAME", displayName);
                    obj.put("INDEX_NAME", indexRow.get("FIELD_INDEX_NAME"));
                    obj.put("DISPLAY_TYPE", row.get("DISPLAY_TYPE"));
                    columnList.add(obj);
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                }
            }
            return configuredCols;
        }
        catch (Exception exp) {
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
    }

    public static long fillTrendData(Map<Long, Long> data, long interval, Map<Long, Long> timeMap) {
        long totalLength = 0L;
        for (Map.Entry<Long, Long> entry : data.entrySet()) {
            long insertTime = entry.getKey();
            long count = entry.getValue();
            if (timeMap.containsKey(insertTime = CorrCustomDataHandler.getNormalizedTime(insertTime, interval))) {
                long val = timeMap.get(insertTime);
                timeMap.put(insertTime, val + count);
            } else {
                timeMap.put(insertTime, count);
            }
            totalLength += count;
        }
        return totalLength;
    }

    public static JSONObject getAllColumns(long providerID, Locale locale) throws JSONException, DataAccessException {
        JSONObject response = new JSONObject();
        ActivityProviderInfo providerInfo = ActivityUtil.getProviderInfo(providerID);
        Long initRuleID = providerInfo.getInitiator().getRuleID();
        Long termRuleID = providerInfo.getTerminator().getRuleID();
        JSONArray initActionData = ActivityCustomDataHandler.getAllColumns(initRuleID, locale);
        JSONArray termActionData = ActivityCustomDataHandler.getAllColumns(termRuleID, locale);
        JSONObject initContainer = new JSONObject();
        initContainer.put("RULE_ID", (Object)initRuleID);
        initContainer.put("ACTION_LIST", (Object)initActionData);
        JSONObject termContainer = new JSONObject();
        termContainer.put("RULE_ID", (Object)termRuleID);
        termContainer.put("ACTION_LIST", (Object)termActionData);
        response.put("INITIATOR", (Object)initContainer);
        response.put("TERMINATOR", (Object)termContainer);
        return response;
    }

    public static JSONArray getAllColumns(Long ruleID, Locale locale) throws JSONException, DataAccessException {
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"CorrConfiguredActions"));
        query.addJoin(new Join("CorrConfiguredActions", "CorrActionCondnFields", new String[]{"ACTION_ID"}, new String[]{"ACTION_ID"}, 2));
        query.addJoin(new Join("CorrActionCondnFields", "NoSqlIndexFields", new String[]{"CONDN_FIELD_ID"}, new String[]{"FIELD_ID"}, 2));
        query.addJoin(new Join("CorrConfiguredActions", "ActivityTableViewConfig", new String[]{"CONFIG_ID"}, new String[]{"ACTION_CONFIG_ID"}, 1));
        query.addJoin(new Join("CorrConfiguredActions", "CorrActionInfo", new String[]{"ACTION_ID"}, new String[]{"ACTION_ID"}, 1));
        query.addSelectColumn(Column.getColumn((String)"CorrConfiguredActions", (String)"CONFIG_ID"));
        query.addSelectColumn(Column.getColumn((String)"CorrConfiguredActions", (String)"ACTION_ID"));
        query.addSelectColumn(Column.getColumn((String)"CorrActionCondnFields", (String)"FIELD_CONFIG_ID"));
        query.addSelectColumn(Column.getColumn((String)"CorrActionCondnFields", (String)"ACTION_ID", (String)"ACTION_CONDN_FIELDID"));
        query.addSelectColumn(Column.getColumn((String)"CorrActionCondnFields", (String)"CONDN_FIELD_ID"));
        query.addSelectColumn(Column.getColumn((String)"CorrActionCondnFields", (String)"DISPLAY_NAME"));
        query.addSelectColumn(Column.getColumn((String)"CorrActionCondnFields", (String)"DESCRIPTION"));
        query.addSelectColumn(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_ID"));
        query.addSelectColumn(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_DISPLAY_NAME"));
        query.addSelectColumn(Column.getColumn((String)"ActivityTableViewConfig", (String)"TABLE_VIEW_ID"));
        query.addSelectColumn(Column.getColumn((String)"ActivityTableViewConfig", (String)"PROVIDER_ID"));
        query.addSelectColumn(Column.getColumn((String)"ActivityTableViewConfig", (String)"ACTION_CONFIG_ID"));
        query.addSelectColumn(Column.getColumn((String)"ActivityTableViewConfig", (String)"FIELD_CONFIG_ID"));
        query.addSelectColumn(Column.getColumn((String)"ActivityTableViewConfig", (String)"DISPLAY_NAME"));
        query.addSelectColumn(Column.getColumn((String)"ActivityTableViewConfig", (String)"DISPLAY_TYPE"));
        query.addSelectColumn(Column.getColumn((String)"ActivityTableViewConfig", (String)"DISPLAY_ORDER"));
        query.addSelectColumn(Column.getColumn((String)"ActivityTableViewConfig", (String)"IS_RESOLVED"));
        query.addSelectColumn(Column.getColumn((String)"CorrActionInfo", (String)"ACTION_ID", (String)"CORR_ACTION_ID"));
        query.addSelectColumn(Column.getColumn((String)"CorrActionInfo", (String)"IS_SYSTEMGENERATED"));
        query.addSelectColumn(Column.getColumn((String)"CorrActionInfo", (String)"DISPLAY_NAME"));
        query.addSelectColumn(Column.getColumn((String)"CorrActionInfo", (String)"DESCRIPTION"));
        query.addSortColumn(new SortColumn(Column.getColumn((String)"CorrConfiguredActions", (String)"CONFIG_ORDER"), true));
        Criteria criteria = new Criteria(Column.getColumn((String)"CorrConfiguredActions", (String)"RULE_ID"), (Object)ruleID, 0);
        criteria = criteria.and(new Criteria(Column.getColumn((String)"CorrActionCondnFields", (String)"TABLECOLUMN_ALLOWED"), (Object)true, 0));
        query.setCriteria(criteria);
        DataObject dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
        return CorrCustomDataHandler.loadColSelectionData(dobj, "ActivityTableViewConfig", locale);
    }

    public static boolean addRemColumn(JSONObject request, Locale locale) throws JSONException, DataAccessException, BaseStatusCode {
        Long providerID = request.getLong("PROVIDER_ID");
        ActivityProviderInfo providerInfo = ActivityUtil.getProviderInfo(providerID);
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ActivityTableViewConfig"));
        query.addSelectColumn(Column.getColumn((String)"ActivityTableViewConfig", (String)"TABLE_VIEW_ID"));
        query.addSelectColumn(Column.getColumn((String)"ActivityTableViewConfig", (String)"ACTION_CONFIG_ID"));
        query.addSelectColumn(Column.getColumn((String)"ActivityTableViewConfig", (String)"PROVIDER_ID"));
        query.addSelectColumn(Column.getColumn((String)"ActivityTableViewConfig", (String)"RULE_ID"));
        query.addSelectColumn(Column.getColumn((String)"ActivityTableViewConfig", (String)"FIELD_CONFIG_ID"));
        query.setCriteria(new Criteria(Column.getColumn((String)"ActivityTableViewConfig", (String)"PROVIDER_ID"), (Object)providerID, 0));
        DataObject dataObject = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
        Long initRuleID = providerInfo.getInitiator().getRuleID();
        Long termRuleID = providerInfo.getTerminator().getRuleID();
        query = new SelectQueryImpl(Table.getTable((String)"CorrConfiguredActions"));
        query.addJoin(new Join("CorrConfiguredActions", "CorrActionInfo", new String[]{"ACTION_ID"}, new String[]{"ACTION_ID"}, 2));
        query.addJoin(new Join("CorrActionInfo", "CorrActionCondnFields", new String[]{"ACTION_ID"}, new String[]{"ACTION_ID"}, 2));
        query.addSelectColumn(Column.getColumn((String)"CorrConfiguredActions", (String)"CONFIG_ID"));
        query.addSelectColumn(Column.getColumn((String)"CorrConfiguredActions", (String)"ACTION_ID"));
        query.addSelectColumn(Column.getColumn((String)"CorrConfiguredActions", (String)"RULE_ID"));
        query.addSelectColumn(Column.getColumn((String)"CorrActionInfo", (String)"ACTION_ID", (String)"ACTN_INFO_ID"));
        query.addSelectColumn(Column.getColumn((String)"CorrActionCondnFields", (String)"ACTION_ID", (String)"CNDN_ACTN_ID"));
        query.addSelectColumn(Column.getColumn((String)"CorrActionCondnFields", (String)"FIELD_CONFIG_ID", (String)"ACTN_CNDN_FIELD_CONF"));
        query.addSelectColumn(Column.getColumn((String)"CorrActionCondnFields", (String)"DISPLAY_NAME"));
        query.setCriteria(new Criteria(Column.getColumn((String)"CorrConfiguredActions", (String)"RULE_ID"), (Object)new long[]{initRuleID, termRuleID}, 8));
        DataObject actionCondnFields = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
        if (request.has("INITIATOR")) {
            JSONObject initConfigCols = request.getJSONObject("INITIATOR");
            ActivityCustomDataHandler.updateConfiguredCols(initConfigCols, providerID, initRuleID, dataObject, actionCondnFields, locale);
        }
        if (request.has("TERMINATOR")) {
            JSONObject termConfigCols = request.getJSONObject("TERMINATOR");
            ActivityCustomDataHandler.updateConfiguredCols(termConfigCols, providerID, termRuleID, dataObject, actionCondnFields, locale);
        }
        PersistenceDBUtil.getPersistence().update(dataObject);
        ClientTableStructure.removeTableStructureFromCache(request.getString("UNIQUE_ID"));
        MultiColumnJRXMLGenerator.removeJRXMLCache(request.getString("UNIQUE_ID"));
        return true;
    }

    private static void updateConfiguredCols(JSONObject request, Long providerID, Long ruleID, DataObject dataObject, DataObject actionCondnFields, Locale locale) throws JSONException, DataAccessException, BaseStatusCode {
        JSONArray actionArray = request.getJSONArray("CONFIGURED_COLUMNS");
        for (int i = 0; i < actionArray.length(); ++i) {
            JSONObject action = actionArray.getJSONObject(i);
            Long actionConfigID = action.getLong("ACTION_CONFIG_ID");
            JSONArray fieldArray = action.getJSONArray("FIELDS");
            Long[] fields = new Long[fieldArray.length()];
            Criteria criteria = new Criteria(Column.getColumn((String)"ActivityTableViewConfig", (String)"ACTION_CONFIG_ID"), (Object)actionConfigID, 0).and(new Criteria(Column.getColumn((String)"ActivityTableViewConfig", (String)"RULE_ID"), (Object)ruleID, 0));
            for (int j = 0; j < fieldArray.length(); ++j) {
                JSONObject field = fieldArray.getJSONObject(j);
                fields[j] = field.getLong("FIELD_CONFIG_ID");
                if (field.get("DISPLAY_NAME") == null || field.getString("DISPLAY_NAME").trim().isEmpty()) {
                    throw BaseStatusCode.getBaseStatusCode(7428);
                }
                Criteria criteria1 = criteria.and(new Criteria(Column.getColumn((String)"ActivityTableViewConfig", (String)"FIELD_CONFIG_ID"), (Object)field.getLong("FIELD_CONFIG_ID"), 0));
                Criteria fieldCriteria = new Criteria(Column.getColumn((String)"CorrActionCondnFields", (String)"FIELD_CONFIG_ID"), (Object)field.getLong("FIELD_CONFIG_ID"), 0);
                Row row = dataObject.getRow("ActivityTableViewConfig", criteria1);
                Row fieldRow = actionCondnFields.getRow("CorrActionCondnFields", fieldCriteria);
                String displayName = field.getString("DISPLAY_NAME");
                Boolean isResolutionRequired = Boolean.FALSE;
                if (fieldRow != null && fieldRow.get("DISPLAY_NAME") != null) {
                    String dispNameForField = (String)fieldRow.get("DISPLAY_NAME");
                    String resolvedDispName = ProductBundle.getInstance().getString(locale, dispNameForField);
                    if (resolvedDispName.equals(displayName.trim())) {
                        displayName = dispNameForField;
                        isResolutionRequired = Boolean.TRUE;
                    }
                }
                if (row == null) {
                    row = new Row("ActivityTableViewConfig");
                    row.set("RULE_ID", (Object)ruleID);
                    row.set("ACTION_CONFIG_ID", (Object)actionConfigID);
                    row.set("PROVIDER_ID", (Object)providerID);
                    row.set("FIELD_CONFIG_ID", (Object)field.getLong("FIELD_CONFIG_ID"));
                    row.set("DISPLAY_NAME", (Object)displayName);
                    row.set("DISPLAY_TYPE", (Object)field.getInt("DISPLAY_TYPE"));
                    row.set("DISPLAY_ORDER", (Object)field.getInt("DISPLAY_ORDER"));
                    row.set("IS_RESOLVED", (Object)isResolutionRequired);
                    row.set("VISIBILITY", (Object)true);
                    dataObject.addRow(row);
                    continue;
                }
                row.set("DISPLAY_NAME", (Object)displayName);
                row.set("DISPLAY_TYPE", (Object)field.getInt("DISPLAY_TYPE"));
                row.set("DISPLAY_ORDER", (Object)field.getInt("DISPLAY_ORDER"));
                row.set("IS_RESOLVED", (Object)isResolutionRequired);
                dataObject.updateRow(row);
            }
            Criteria subCrit = criteria.and(new Criteria(Column.getColumn((String)"ActivityTableViewConfig", (String)"FIELD_CONFIG_ID"), (Object)fields, 9));
            dataObject.deleteRows("ActivityTableViewConfig", subCrit);
        }
    }
}

