/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.auditdata;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.TimePack;
import com.manageengine.ela.server.correlation.auditdata.CorrelationGraphData;
import com.manageengine.ela.server.correlation.session.auditdata.ActivityArchivedData;
import com.manageengine.ela.server.correlation.session.util.ActivityUtil;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class ActivityGraphData {
    private static final Logger LOGGER = Logger.getLogger(ActivityGraphData.class.getName());

    public static JSONObject getActivityTrendGraphData(Long ruleID, TimePack time, long interval) {
        JSONObject activityTrend = new JSONObject();
        try {
            long totalLength = 0L;
            TreeMap<Long, Long> timeMap = new TreeMap<Long, Long>();
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ActivityHistory"));
            query.addSelectColumn(Column.getColumn((String)"ActivityHistory", (String)"START_TIME"));
            Criteria criteria = new Criteria(Column.getColumn((String)"ActivityHistory", (String)"PROVIDER_ID"), (Object)ruleID, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"ActivityHistory", (String)"IS_PRIMARY"), (Object)true, 0));
            query.setCriteria(criteria.and(ActivityUtil.getTimeBasedCustomTableSuccessCriteria("ActivityHistory", time)));
            totalLength += CorrelationGraphData.fillTrendInformation((Query)query, interval, timeMap);
            JSONArray countMap = new JSONArray();
            timeMap.forEach((key, value) -> countMap.put((Object)new JSONArray().put(key).put(value)));
            activityTrend.put("DATA", (Object)countMap);
            activityTrend.put("TOTAL_LENGTH", totalLength += ActivityArchivedData.get().loadActivityTrendData(ruleID, time, interval, timeMap));
            activityTrend.put("INTERVAL", interval);
        }
        catch (Exception exp) {
            LOGGER.log(Level.INFO, "Error occurred during Activity Graph Data fetch {0}", exp.getMessage());
        }
        return activityTrend;
    }
}

