/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.auditdata;

import com.adventnet.la.TimePack;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.correlation.session.auditdata.ActivityCustomDataHandler;
import com.manageengine.ela.server.correlation.session.search.ActivityNoSqlSearch;
import com.manageengine.ela.server.correlation.session.search.NoSqlSearchRequest;
import com.manageengine.ela.server.correlation.session.search.tablesearch.ActivityTableSearchHandler;
import com.manageengine.ela.server.correlation.session.util.ActivityUtil;
import java.util.Map;
import java.util.TreeMap;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ActivityNoSqlGraphData {
    public static final String PRIMARY = "PRIMARY";

    public static JSONObject getActivityTrendGraphData(Long providerID, String aggFieldName, TimePack time) throws JSONException, BaseStatusCode {
        Long startTime = time.getStartTimeInLong();
        Long endTime = time.getEndTimeInLong();
        ExistsQueryBuilder providerQuery = QueryBuilders.existsQuery((String)ActivityUtil.getProviderIndexFieldName(providerID));
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)providerQuery);
        MatchQueryBuilder fieldQuery = QueryBuilders.matchQuery((String)"ACT_FLAG", (Object)"IN");
        queryBuilder = queryBuilder.must((QueryBuilder)fieldQuery);
        RangeQueryBuilder timeRange = QueryBuilders.rangeQuery((String)"TIME").from(time.getStartTimeInLong()).to(time.getEndTimeInLong());
        queryBuilder.must((QueryBuilder)timeRange);
        TermsBuilder aggregation = ((TermsBuilder)AggregationBuilders.terms((String)PRIMARY).field(aggFieldName)).size(10);
        NoSqlSearchRequest request = new NoSqlSearchRequest(startTime, endTime).setQuery((QueryBuilder)queryBuilder).setAggregation((AbstractAggregationBuilder)aggregation).setSize(0);
        return ActivityNoSqlGraphData.normalizeResponse(ActivityNoSqlSearch.doSearch(request));
    }

    public static JSONObject getFilterBasedGraphData(String uniqueID, Long interval) throws JSONException {
        JSONObject result = new JSONObject();
        JSONArray entries = new JSONArray();
        Map<Long, Long> graphData = ActivityTableSearchHandler.getGraphData(uniqueID);
        TreeMap<Long, Long> timeData = new TreeMap<Long, Long>();
        long count = 0L;
        if (graphData != null) {
            count = ActivityCustomDataHandler.fillTrendData(graphData, interval, timeData);
            for (Map.Entry<Long, Long> entry : timeData.entrySet()) {
                entries.put((Object)new JSONArray().put((Object)entry.getKey()).put((Object)entry.getValue()));
            }
        }
        result.put("DATA", (Object)entries);
        result.put("TOTAL_LENGTH", count);
        result.put("INTERVAL", (Object)interval);
        return result;
    }

    private static JSONObject normalizeResponse(SearchResponse response) throws JSONException {
        JSONObject res = new JSONObject();
        if (response == null) {
            return res;
        }
        JSONArray primaryKeyList = new JSONArray();
        JSONArray xList = new JSONArray();
        JSONArray yList = new JSONArray();
        Terms uNames = (Terms)response.getAggregations().get(PRIMARY);
        for (Terms.Bucket bucket : uNames.getBuckets()) {
            primaryKeyList.put(bucket.getKey());
            xList.put(bucket.getKey());
            yList.put(bucket.getDocCount());
        }
        res.put("primaryKeyList", (Object)primaryKeyList);
        res.put("xList", (Object)xList);
        res.put("yList", (Object)yList);
        return res;
    }
}

