/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.builder;

import com.google.common.collect.ImmutableSet;
import com.manageengine.ela.server.correlation.core.analyzer.AnalyzerInput;
import com.manageengine.ela.server.correlation.core.analyzer.MultiActionAnalyzer;
import com.manageengine.ela.server.correlation.core.builder.CorrelationBuilder;
import com.manageengine.ela.server.correlation.core.constants.CorrelationStatus;
import com.manageengine.ela.server.correlation.core.criteria.CrossActionChain;
import com.manageengine.ela.server.correlation.core.data.DataStore;
import com.manageengine.ela.server.correlation.core.data.DocDataManager;
import com.manageengine.ela.server.correlation.core.data.RuleContainer;
import com.manageengine.ela.server.correlation.core.status.StatusHandlerImpl;
import com.manageengine.ela.server.correlation.session.info.ActivityBreakerInfo;
import com.manageengine.ela.server.correlation.session.info.ActivityInitiatorInfo;
import com.manageengine.ela.server.correlation.session.info.ActivityProviderInfo;
import com.manageengine.ela.server.correlation.session.info.ActivityTerminatorInfo;
import com.manageengine.ela.server.correlation.session.listener.ActivitySuccessListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ActivityBuilder {
    private final ActivityProviderInfo provider;
    private DataStore.StoreType storeType;

    public ActivityBuilder(Long providerID, Long ruleID) {
        this.provider = new ActivityProviderInfo(providerID, ruleID);
        this.storeType = DataStore.StoreType.JAVAHEAP;
    }

    public ActivityBuilder terminator(ActivityTerminatorInfo terminator) {
        this.provider.setTerminator(terminator);
        return this;
    }

    public ActivityBuilder initiator(ActivityInitiatorInfo initiatorInfo) {
        this.provider.setInitiator(initiatorInfo);
        return this;
    }

    public ActivityBuilder breaker(ActivityBreakerInfo breakerInfo) {
        this.provider.setBreaker(breakerInfo);
        return this;
    }

    public ActivityBuilder addLinkedFields(Map<String, String> linkedFields) {
        this.provider.setLinkedFields(linkedFields);
        return this;
    }

    public ActivityBuilder setColdDataPeriod(Long timeLimit) {
        this.provider.setDataTimeLimit(timeLimit);
        return this;
    }

    public ActivityBuilder setType(Integer providerType) {
        this.provider.setType(providerType);
        return this;
    }

    public ActivityBuilder setStatus(CorrelationStatus status) {
        this.provider.setStatus(status);
        return this;
    }

    public ActivityBuilder setStoreType(DataStore.StoreType storeType) {
        this.storeType = storeType;
        return this;
    }

    private void addTerminatorAnalyzer() {
        CrossActionChain chain = CrossActionChain.create(this.provider.getInitiator().getRuleID(), null, 1);
        chain.add(this.provider.getTerminator().getRuleID(), null, 1);
        AnalyzerInput input = new AnalyzerInput(this.provider.getRuleID(), chain, this.provider.getContainer());
        MultiActionAnalyzer analyzer = new MultiActionAnalyzer(input, ActivitySuccessListener.get(), new StatusHandlerImpl());
        this.provider.setExecutor(analyzer);
    }

    public ActivityProviderInfo build() {
        if (!this.provider.isValid()) {
            throw new IllegalStateException("Invalid ActivityProfile");
        }
        HashMap<Long, Set<String>> fields = new HashMap<Long, Set<String>>();
        ImmutableSet configuredActions = ImmutableSet.of((Object)this.provider.getInitiator().getRuleID(), (Object)this.provider.getTerminator().getRuleID());
        fields.put(this.provider.getInitiator().getRuleID(), this.provider.getInitLinkedFields());
        fields.put(this.provider.getTerminator().getRuleID(), this.provider.getTermLinkedFields());
        CorrelationBuilder.create().setIdentity(this.provider.getRuleID()).delete();
        RuleContainer container = DocDataManager.get().createRuleContainer(this.provider.getRuleID()).initialize((Set<Long>)configuredActions, fields, this.provider.getDataTimeLimit(), this.storeType);
        this.provider.setContainer(container);
        this.addTerminatorAnalyzer();
        return this.provider;
    }
}

