/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.builder;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.correlation.core.config.CorrConfigInfo;
import com.manageengine.ela.server.correlation.core.constants.CorrelationStatus;
import com.manageengine.ela.server.correlation.core.data.DataStore;
import com.manageengine.ela.server.correlation.session.builder.ActivityBuilder;
import com.manageengine.ela.server.correlation.session.info.ActivityBreakerInfo;
import com.manageengine.ela.server.correlation.session.info.ActivityInitiatorInfo;
import com.manageengine.ela.server.correlation.session.info.ActivityProviderInfo;
import com.manageengine.ela.server.correlation.session.info.ActivityTerminatorInfo;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ActivityRuleInitializer {
    private static final Logger LOGGER = Logger.getLogger(ActivityRuleInitializer.class.getName());

    public static ActivityProviderInfo initActivityProvider(Row ruleProvider, DataObject activityDataObject) throws BaseStatusCode {
        try {
            Long providerID = (Long)ruleProvider.get("PROVIDER_ID");
            Long ruleID = (Long)ruleProvider.get("RULE_ID");
            CorrelationStatus providerStatus = CorrelationStatus.getStatus((Long)ruleProvider.get("STATUS"));
            Criteria criteria = new Criteria(Column.getColumn((String)"ActivityInitiatorInfo", (String)"PROVIDER_ID"), (Object)providerID, 0);
            Row initiatorInfo = activityDataObject.getRow("ActivityInitiatorInfo", criteria);
            if (initiatorInfo == null) {
                throw BaseStatusCode.getBaseStatusCode(16385);
            }
            criteria = new Criteria(Column.getColumn((String)"ActivityTerminatorInfo", (String)"PROVIDER_ID"), (Object)providerID, 0);
            Row terminatorInfo = activityDataObject.getRow("ActivityTerminatorInfo", criteria);
            if (terminatorInfo == null) {
                throw BaseStatusCode.getBaseStatusCode(16385);
            }
            criteria = new Criteria(Column.getColumn((String)"ActivityBreakerInfo", (String)"PROVIDER_ID"), (Object)providerID, 0);
            Row breakerInfo = activityDataObject.getRow("ActivityBreakerInfo", criteria);
            ActivityInitiatorInfo activityInitiatorInfo = new ActivityInitiatorInfo((Long)initiatorInfo.get("INITIATOR_ID"), (Long)initiatorInfo.get("RULE_ID"), (Long)initiatorInfo.get("PRIMARY_ACTIONID"));
            ActivityTerminatorInfo activityTerminatorInfo = new ActivityTerminatorInfo((Long)terminatorInfo.get("TERMINATOR_ID"), (Long)terminatorInfo.get("RULE_ID"), (Long)terminatorInfo.get("PRIMARY_ACTIONID"));
            ActivityBreakerInfo activityBreakerInfo = null;
            if (breakerInfo != null) {
                activityBreakerInfo = new ActivityBreakerInfo((Long)breakerInfo.get("BREAKER_ID"), (Long)breakerInfo.get("RULE_ID"), (Long)breakerInfo.get("PRIMARY_ACTIONID"));
                criteria = new Criteria(Column.getColumn((String)"ActivityBreakerFields", (String)"BREAKER_ID"), breakerInfo.get("BREAKER_ID"), 0);
                Iterator fieldIterator = activityDataObject.getRows("ActivityBreakerFields", criteria);
                while (fieldIterator.hasNext()) {
                    Row row = (Row)fieldIterator.next();
                    criteria = new Criteria(Column.getColumn((String)"NoSqlIndexFields_INIT_BREAK", (String)"FIELD_ID"), row.get("INIT_FIELD_ID"), 0);
                    String initFieldName = (String)activityDataObject.getRow("NoSqlIndexFields_INIT_BREAK", criteria).get("FIELD_INDEX_NAME");
                    criteria = new Criteria(Column.getColumn((String)"NoSqlIndexFields_BREAK", (String)"FIELD_ID"), row.get("BREAKER_FIELD_ID"), 0);
                    String breakerFieldName = (String)activityDataObject.getRow("NoSqlIndexFields_BREAK", criteria).get("FIELD_INDEX_NAME");
                    activityBreakerInfo.addBreakerFields(initFieldName, breakerFieldName);
                }
            }
            HashMap<String, String> linkedFields = new HashMap<String, String>();
            int providerType = (Integer)ruleProvider.get("TYPE");
            criteria = new Criteria(Column.getColumn((String)"ActivityRuleLinkedFields", (String)"PROVIDER_ID"), (Object)providerID, 0);
            Iterator fieldIterator = activityDataObject.getRows("ActivityRuleLinkedFields", criteria);
            while (fieldIterator.hasNext()) {
                Row row = (Row)fieldIterator.next();
                criteria = new Criteria(Column.getColumn((String)"NoSqlIndexFields_INIT", (String)"FIELD_ID"), row.get("INIT_FIELD_ID"), 0);
                String initIndexName = (String)activityDataObject.getRow("NoSqlIndexFields_INIT", criteria).get("FIELD_INDEX_NAME");
                criteria = new Criteria(Column.getColumn((String)"NoSqlIndexFields_TERN", (String)"FIELD_ID"), row.get("TERM_FIELD_ID"), 0);
                String termIndexName = (String)activityDataObject.getRow("NoSqlIndexFields_TERN", criteria).get("FIELD_INDEX_NAME");
                linkedFields.put(initIndexName, termIndexName);
            }
            criteria = new Criteria(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID"), ruleProvider.get("RULE_ID"), 0);
            Integer storeTypeVal = (Integer)activityDataObject.getValue("CorrRuleInfo", "STORE_TYPE", criteria);
            return new ActivityBuilder(providerID, ruleID).initiator(activityInitiatorInfo).terminator(activityTerminatorInfo).breaker(activityBreakerInfo).addLinkedFields(linkedFields).setStatus(providerStatus).setType(providerType).setStoreType(DataStore.StoreType.getStoreType(storeTypeVal)).setColdDataPeriod(CorrConfigInfo.getDefault_cold_period_for_generated_activity()).build();
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, "Error occurred during correlation activity initialization - activity profile preparation {0}", new Object[]{exp.getMessage()});
            LOGGER.log(Level.FINE, "Exception =  {0}", exp);
            return null;
        }
    }
}

