/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.config;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ela.server.common.client.structure.ClientTableStructure;
import com.manageengine.ela.server.common.client.structure.TableUniqueIdentifier;
import com.manageengine.ela.server.common.database.actions.DataBaseReqestProcessor;
import com.manageengine.ela.server.common.delegation.info.UserAccessResource;
import com.manageengine.ela.server.common.export.generators.MultiColumnJRXMLGenerator;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.util.JSONUtil;
import com.manageengine.ela.server.correlation.config.CorrelationConfigHandler;
import com.manageengine.ela.server.correlation.core.constants.CorrelationStatus;
import com.manageengine.ela.server.correlation.session.builder.ActivityRuleInitializer;
import com.manageengine.ela.server.correlation.session.config.ActivityConfigMapping;
import com.manageengine.ela.server.correlation.session.config.ActivityProfileContainer;
import com.manageengine.ela.server.correlation.session.config.ActivityProviderController;
import com.manageengine.ela.server.correlation.session.config.ActivityRuleController;
import com.manageengine.ela.server.correlation.session.constants.ActivityRuleType;
import com.manageengine.ela.server.correlation.session.info.ActivityProfileInfo;
import com.manageengine.ela.server.correlation.session.info.ActivityProviderInfo;
import com.manageengine.ela.server.correlation.session.util.ActivityUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.math.NumberUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ActivityConfigHandler {
    private static final Logger LOGGER = Logger.getLogger(ActivityConfigHandler.class.getName());

    public static boolean addNewActivityProvider(JSONObject providerConfig, UserAccessResource accessControl, Locale locale) throws DataAccessException, BaseStatusCode {
        DataObject dataObject = PersistenceDBUtil.getPersistence().constructDataObject();
        try {
            if (ActivityUtil.isRuleNameAlreadyUsed(providerConfig.getJSONObject("RULE_DATA").getJSONObject("RULE_INFO").getString("DISPLAY_NAME"), locale)) {
                throw BaseStatusCode.getBaseStatusCode(7432);
            }
            ActivityConfigHandler.populateDatabase(providerConfig, accessControl.getUserID(), locale, dataObject);
            ActivityConfigHandler.handleRuleNotification(dataObject);
            Long profileID = (Long)dataObject.getFirstValue("ActivityRuleProviders", "PROFILE_ID");
            Row providerInfo = dataObject.getFirstRow("ActivityRuleProviders");
            ActivityProviderInfo activityProviderInfo = ActivityRuleInitializer.initActivityProvider(providerInfo, dataObject);
            ActivityProviderController.load(profileID, activityProviderInfo, CorrelationStatus.ENABLE);
            return true;
        }
        catch (BaseStatusCode statusCode) {
            throw statusCode;
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, "Error occurred during activity provider creation {0}", exp.getMessage());
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
    }

    public static boolean deleteProvider(JSONObject requestData) throws BaseStatusCode {
        try {
            if (ActivityUtil.isEditableActivityProvider(requestData.getLong("PROVIDER_ID")).booleanValue()) {
                Long profileID = requestData.getLong("PROFILE_ID");
                Long providerID = requestData.getLong("PROVIDER_ID");
                ActivityProviderController.unload(profileID, providerID);
                ActivityProviderController.delete(profileID, providerID);
                return true;
            }
            throw BaseStatusCode.getBaseStatusCode(16388);
        }
        catch (BaseStatusCode baseStatusCode) {
            throw baseStatusCode;
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, "Error occurred during activity provider deletion {0}", exp.getMessage());
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
    }

    public static boolean updateSearchLinkedFields(JSONObject request) throws BaseStatusCode {
        try {
            JSONArray fieldData = request.getJSONArray("FIELD_DATA");
            HashMap<Long, Boolean> fieldMap = new HashMap<Long, Boolean>();
            for (int i = 0; i < fieldData.length(); ++i) {
                JSONObject entry = fieldData.getJSONObject(i);
                fieldMap.put(entry.getLong("ID"), entry.getBoolean("STATUS"));
            }
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ActivitySharedFieldStatus"));
            selectQuery.addSelectColumn(Column.getColumn((String)"ActivitySharedFieldStatus", (String)"UNIQUE_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"ActivitySharedFieldStatus", (String)"LINKED_FIELD_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"ActivitySharedFieldStatus", (String)"STATUS"));
            selectQuery.setCriteria(new Criteria(Column.getColumn((String)"ActivitySharedFieldStatus", (String)"LINKED_FIELD_ID"), (Object)fieldMap.keySet().toArray(), 8));
            DataObject dataObject = PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
            Iterator iterator = dataObject.getRows("ActivitySharedFieldStatus");
            while (iterator.hasNext()) {
                Boolean newStatus;
                Row row = (Row)iterator.next();
                Long id = (Long)row.get("LINKED_FIELD_ID");
                Boolean oldStatus = (Boolean)row.get("STATUS");
                if (oldStatus == (newStatus = (Boolean)fieldMap.get(id))) continue;
                row.set("STATUS", (Object)newStatus);
                dataObject.updateRow(row);
            }
            if (!dataObject.getOperations().isEmpty()) {
                PersistenceDBUtil.getPersistence().update(dataObject);
            } else {
                LOGGER.log(Level.FINE, "No changes in shared fields");
            }
            return true;
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, "Error occurred during field update {0}", exp.getMessage());
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
    }

    public static boolean enableDisableProviders(Map<Long, List<Long>> activities, CorrelationStatus status) throws BaseStatusCode {
        try {
            HashSet<Long> providerSet = new HashSet<Long>();
            JSONArray corrRules = new JSONArray();
            for (Map.Entry<Long, List<Long>> data : activities.entrySet()) {
                Long profileID = data.getKey();
                for (Long providerID : data.getValue()) {
                    providerSet.add(providerID);
                    ActivityProviderInfo providerInfo = ActivityProfileContainer.get().getProviderInfo(profileID, providerID);
                    corrRules.put((Object)providerInfo.getInitiator().getRuleID());
                    corrRules.put((Object)providerInfo.getTerminator().getRuleID());
                    if (providerInfo.getBreaker() != null) {
                        corrRules.put((Object)providerInfo.getBreaker().getRuleID());
                    }
                    if (status == CorrelationStatus.ENABLE) {
                        ActivityProviderController.enable(profileID, providerID);
                        continue;
                    }
                    if (status != CorrelationStatus.DISABLE) continue;
                    ActivityProviderController.disable(profileID, providerID);
                }
            }
            CorrelationConfigHandler.enableDisableCorrelationRule(corrRules, status);
            DataBaseReqestProcessor.executeUpdateQuery("ActivityRuleProviders", "STATUS", status.getValue(), new Criteria(Column.getColumn((String)"ActivityRuleProviders", (String)"PROVIDER_ID"), (Object)providerSet.toArray(), 8), true);
            ActivityUtil.updateActiveSessionsToInterrupted(providerSet.toArray(new Long[providerSet.size()]));
            LOGGER.log(Level.INFO, "Rule state changed to {0} for providers {1}", new Object[]{status, providerSet});
            return true;
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, "Error occurred during activity provider deletion {0}", exp.getMessage());
            throw BaseStatusCode.getBaseStatusCode(16386);
        }
    }

    public static boolean reconfigureActivityProvider(JSONObject providerConfig, Locale locale) throws BaseStatusCode {
        try {
            DataObject dataObject = PersistenceDBUtil.getPersistence().constructDataObject();
            JSONObject ruleData = providerConfig.getJSONObject("RULE_DATA");
            JSONObject ruleInfo = ruleData.getJSONObject("RULE_INFO");
            ActivityConfigHandler.validateProviderConfigRequest(ruleData);
            Long providerID = ruleInfo.getLong("PROVIDER_ID");
            Long updatedProfileID = ActivityConfigHandler.updateProfile(ruleInfo.getJSONObject("PROFILE"), locale, dataObject);
            Long previousProfileID = ActivityConfigMapping.get().getProfileID(providerID);
            ActivityProviderInfo providerInfo = ActivityProfileContainer.get().getProviderInfo(previousProfileID, providerID);
            ActivityProviderController.unload(previousProfileID, providerID);
            JSONObject initiatorJSON = ruleData.getJSONObject("INITIATOR").getJSONObject("RULE_DATA");
            JSONObject terminatorJSON = ruleData.getJSONObject("TERMINATOR").getJSONObject("RULE_DATA");
            ActivityConfigHandler.addProviderRuleInfo(providerInfo, ActivityRuleType.INITIATOR_RULE, initiatorJSON);
            ActivityConfigHandler.addProviderRuleInfo(providerInfo, ActivityRuleType.TERMINATOR_RULE, terminatorJSON);
            HashMap<String, Long> UIDMap = new HashMap<String, Long>();
            CorrelationConfigHandler.CorrRuleConfigData initData = CorrelationConfigHandler.reConfigureCorrelationRule(initiatorJSON, locale);
            CorrelationConfigHandler.CorrRuleConfigData termData = CorrelationConfigHandler.reConfigureCorrelationRule(terminatorJSON, locale);
            UIDMap.putAll(initData.getUidMap());
            UIDMap.putAll(termData.getUidMap());
            Boolean isRuleRecreationNeeded = ActivityConfigHandler.checkForRuleStructureChange(initData, termData, UIDMap, providerInfo, ruleData);
            Boolean isPrimaryActionsReconfigured = ActivityConfigHandler.updateProviderDatabaseChanges(providerInfo, updatedProfileID, ruleData, UIDMap, dataObject);
            if (isRuleRecreationNeeded.booleanValue()) {
                providerInfo = ActivityRuleInitializer.initActivityProvider(dataObject.getFirstRow("ActivityRuleProviders"), dataObject);
                if (providerInfo == null) {
                    throw BaseStatusCode.getBaseStatusCode(16386);
                }
                if (isPrimaryActionsReconfigured.booleanValue()) {
                    DBUtil.deleteExistingRows("ActivityHistory", new Criteria(Column.getColumn((String)"ActivityHistory", (String)"PROVIDER_ID"), (Object)providerID, 0), new boolean[0]);
                } else {
                    ActivityUtil.updateActiveSessionsToInterrupted(new Long[]{providerID});
                }
            }
            ActivityRuleController.postActivityModificationCall(updatedProfileID, providerInfo);
            return true;
        }
        catch (BaseStatusCode statusCode) {
            throw statusCode;
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, "Error occurred during activity provider edit {0}", exp.getMessage());
            throw BaseStatusCode.getBaseStatusCode(16386);
        }
    }

    private static boolean checkForRuleStructureChange(CorrelationConfigHandler.CorrRuleConfigData initData, CorrelationConfigHandler.CorrRuleConfigData termData, Map<String, Long> uidMap, ActivityProviderInfo providerInfo, JSONObject request) throws DataAccessException, JSONException, BaseStatusCode {
        try {
            Long providerID = providerInfo.getID();
            if (!initData.getDeletedActionIDSet().isEmpty() || !termData.getDeletedActionIDSet().isEmpty()) {
                LOGGER.log(Level.INFO, "Some actions deleted for provider {0}", providerID);
                return true;
            }
            if (!uidMap.keySet().stream().allMatch(NumberUtils::isNumber)) {
                LOGGER.log(Level.INFO, "New actions are added for provider {0}", providerID);
                return true;
            }
            HashMap<Long, Long> currentSharedList = new HashMap<Long, Long>();
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ActivityRuleLinkedFields"));
            selectQuery.addSelectColumn(Column.getColumn((String)"ActivityRuleLinkedFields", (String)"*"));
            selectQuery.setCriteria(new Criteria(Column.getColumn((String)"ActivityRuleLinkedFields", (String)"PROVIDER_ID"), (Object)providerInfo.getID(), 0));
            DataObject dataObject = PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
            if (!dataObject.containsTable("ActivityRuleLinkedFields")) {
                throw BaseStatusCode.getBaseStatusCode(7428);
            }
            Iterator iterator = dataObject.getRows("ActivityRuleLinkedFields");
            while (iterator.hasNext()) {
                Row linkedFields = (Row)iterator.next();
                currentSharedList.put((Long)linkedFields.get("INIT_FIELD_ID"), (Long)linkedFields.get("TERM_FIELD_ID"));
            }
            HashMap<Long, Long> newSharedFieldList = new HashMap<Long, Long>();
            JSONArray jsonArray = request.getJSONArray("SHARED_FIELDS");
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject sharedFieldEntry = jsonArray.getJSONObject(i);
                Long initField = sharedFieldEntry.getLong("INIT_FIELD_ID");
                Long termField = sharedFieldEntry.getLong("TERM_FIELD_ID");
                newSharedFieldList.put(initField, termField);
            }
            if (newSharedFieldList.size() != currentSharedList.size()) {
                LOGGER.log(Level.FINER, "Linked fields are changed for provider {0}", providerID);
                return true;
            }
            for (Long key : currentSharedList.keySet()) {
                if (newSharedFieldList.containsKey(key) && ((Long)newSharedFieldList.get(key)).compareTo((Long)currentSharedList.get(key)) == 0) continue;
                LOGGER.log(Level.FINER, "Linked fields are changed for provider {0}", providerID);
                return true;
            }
            Long initPActionConfigID = ActivityConfigHandler.findPrimaryActionID(uidMap, request.getJSONObject("INITIATOR").getJSONObject("RULE_DATA").getJSONArray("ACTIONS"));
            Long termPActionConfigID = ActivityConfigHandler.findPrimaryActionID(uidMap, request.getJSONObject("TERMINATOR").getJSONObject("RULE_DATA").getJSONArray("ACTIONS"));
            if (providerInfo.getInitiator().getPrimaryActionID().compareTo(initPActionConfigID) != 0 || providerInfo.getTerminator().getPrimaryActionID().compareTo(termPActionConfigID) != 0) {
                LOGGER.log(Level.FINER, "Primary action changed for provider {0}", providerID);
                return true;
            }
            LOGGER.log(Level.FINER, "No structure change for activity rule for provider {0}", providerID);
            return false;
        }
        catch (BaseStatusCode baseStatusCode) {
            throw baseStatusCode;
        }
        catch (Exception exp) {
            LOGGER.log(Level.INFO, "Error occurred during rule edit {0}", exp);
            return true;
        }
    }

    private static boolean updateProviderDatabaseChanges(ActivityProviderInfo provider, Long updatedProfileID, JSONObject ruleData, Map<String, Long> uidMap, DataObject dataObject) throws DataAccessException, JSONException, BaseStatusCode {
        Row terminatorInfo;
        Row initiatorInfo;
        boolean isRefreshNeeded = false;
        dataObject.merge(ActivityUtil.getCompleteActivityProviderData(provider.getID()));
        Row ruleProvider = dataObject.getFirstRow("ActivityRuleProviders");
        JSONObject ruleInfo = ruleData.getJSONObject("RULE_INFO");
        JSONObject initData = ruleData.getJSONObject("INITIATOR");
        JSONObject termData = ruleData.getJSONObject("TERMINATOR");
        if (ruleProvider == null) {
            throw BaseStatusCode.getBaseStatusCode(16385);
        }
        String description = ruleInfo.optString("DESCRIPTION", "");
        if (description.length() >= 255) {
            throw BaseStatusCode.getBaseStatusCode(16393);
        }
        ruleProvider.set("DESCRIPTION", (Object)description);
        ruleProvider.set("PROFILE_ID", (Object)updatedProfileID);
        dataObject.updateRow(ruleProvider);
        Long initPrimaryActionConfigID = ActivityConfigHandler.findPrimaryActionID(uidMap, initData.getJSONObject("RULE_DATA").getJSONArray("ACTIONS"));
        if (dataObject.containsTable("ActivityInitiatorInfo")) {
            initiatorInfo = dataObject.getFirstRow("ActivityInitiatorInfo");
            initiatorInfo.set("PRIMARY_ACTIONID", (Object)initPrimaryActionConfigID);
            dataObject.updateRow(initiatorInfo);
        } else {
            isRefreshNeeded = true;
            initiatorInfo = new Row("ActivityInitiatorInfo");
            initiatorInfo.set("INITIATOR_ID", (Object)provider.getInitiator().getID());
            initiatorInfo.set("PROVIDER_ID", (Object)provider.getID());
            initiatorInfo.set("RULE_ID", (Object)provider.getInitiator().getRuleID());
            initiatorInfo.set("PRIMARY_ACTIONID", (Object)initPrimaryActionConfigID);
            dataObject.addRow(initiatorInfo);
        }
        Long termPrimaryActionConfigID = ActivityConfigHandler.findPrimaryActionID(uidMap, termData.getJSONObject("RULE_DATA").getJSONArray("ACTIONS"));
        if (dataObject.containsTable("ActivityTerminatorInfo")) {
            terminatorInfo = dataObject.getFirstRow("ActivityTerminatorInfo");
            terminatorInfo.set("PRIMARY_ACTIONID", (Object)termPrimaryActionConfigID);
            dataObject.updateRow(terminatorInfo);
        } else {
            isRefreshNeeded = true;
            terminatorInfo = new Row("ActivityTerminatorInfo");
            terminatorInfo.set("TERMINATOR_ID", (Object)provider.getTerminator().getID());
            terminatorInfo.set("PROVIDER_ID", (Object)provider.getID());
            terminatorInfo.set("RULE_ID", (Object)provider.getTerminator().getRuleID());
            terminatorInfo.set("PRIMARY_ACTIONID", (Object)termPrimaryActionConfigID);
            dataObject.addRow(terminatorInfo);
        }
        dataObject.deleteRows("ActivityRuleLinkedFields", new Criteria(Column.getColumn((String)"ActivityRuleLinkedFields", (String)"PROVIDER_ID"), (Object)provider.getID(), 0));
        dataObject.deleteRows("ActivityTableViewConfig", new Criteria(Column.getColumn((String)"ActivityTableViewConfig", (String)"PROVIDER_ID"), (Object)provider.getID(), 0));
        JSONArray jsonArray = ruleData.getJSONArray("SHARED_FIELDS");
        HashMap<Long, Long> sharedFieldSet = new HashMap<Long, Long>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            Row linkedField = new Row("ActivityRuleLinkedFields");
            JSONObject sharedFieldEntry = jsonArray.getJSONObject(i);
            Long initField = sharedFieldEntry.getLong("INIT_FIELD_ID");
            Long termField = sharedFieldEntry.getLong("TERM_FIELD_ID");
            linkedField.set("PROVIDER_ID", (Object)provider.getID());
            linkedField.set("INIT_FIELD_ID", (Object)sharedFieldEntry.getLong("INIT_FIELD_ID"));
            linkedField.set("TERM_FIELD_ID", (Object)sharedFieldEntry.getLong("TERM_FIELD_ID"));
            dataObject.addRow(linkedField);
            Row activitySharedFieldStatus = new Row("ActivitySharedFieldStatus");
            activitySharedFieldStatus.set("LINKED_FIELD_ID", linkedField.get("LINKED_FIELD_ID"));
            activitySharedFieldStatus.set("STATUS", (Object)Boolean.TRUE);
            dataObject.addRow(activitySharedFieldStatus);
            sharedFieldSet.put(initField, termField);
        }
        PersistenceDBUtil.getPersistence().update(dataObject);
        dataObject.merge(ActivityConfigHandler.fetchSharedFieldData("NoSqlIndexFields_INIT", sharedFieldSet.keySet()));
        dataObject.merge(ActivityConfigHandler.fetchSharedFieldData("NoSqlIndexFields_TERN", sharedFieldSet.values()));
        DataObject tableData = ActivityConfigHandler.addActivityTableViewData(dataObject, sharedFieldSet, initData.getJSONObject("RULE_DATA").getLong("RULE_ID"), ruleInfo.getLong("PROVIDER_ID"), initData.getLong("PRIMARY_ACTION_ID"));
        PersistenceDBUtil.getPersistence().update(tableData);
        String uniqueTableName = "Table:204_Rule:" + provider.getID();
        ClientTableStructure.removeTableStructureFromCache(uniqueTableName);
        MultiColumnJRXMLGenerator.removeJRXMLCache(uniqueTableName);
        return isRefreshNeeded;
    }

    public static boolean addNewActivityProfile(JSONObject requestData) throws BaseStatusCode {
        try {
            DataObject dataObject = PersistenceDBUtil.getPersistence().constructDataObject();
            Row activityProfile = new Row("ActivityMonitorProfile");
            activityProfile.set("DISPLAY_NAME", (Object)requestData.getString("DISPLAY_NAME"));
            activityProfile.set("DESCRIPTION", (Object)requestData.optString("DISPLAY_NAME"));
            activityProfile.set("IS_EDITABLE", (Object)Boolean.TRUE);
            activityProfile.set("IS_SYSTEMGENERATED", (Object)Boolean.TRUE);
            activityProfile.set("STATUS", (Object)1L);
            dataObject.addRow(activityProfile);
            PersistenceDBUtil.getPersistence().update(dataObject);
            Long profileID = (Long)dataObject.getFirstRow("ActivityMonitorProfile").get("PROFILE_ID");
            ActivityProfileInfo profileInfo = new ActivityProfileInfo(profileID);
            ActivityProfileContainer.load(profileInfo, CorrelationStatus.ENABLE);
            return true;
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, "Error occurred during activity provider deletion {0}", exp.getMessage());
            throw BaseStatusCode.getBaseStatusCode(16386);
        }
    }

    private static void populateDatabase(JSONObject providerConfig, Long userID, Locale locale, DataObject dataObject) throws BaseStatusCode, JSONException, DataAccessException {
        Object profileID;
        JSONObject ruleData = providerConfig.getJSONObject("RULE_DATA");
        JSONObject ruleInfo = ruleData.getJSONObject("RULE_INFO");
        Long defaultRuleCategory = ActivityUtil.getDefaultActivityRuleCategory();
        JSONObject initiatorJSON = ruleData.getJSONObject("INITIATOR");
        JSONObject terminatorJSON = ruleData.getJSONObject("TERMINATOR");
        ActivityConfigHandler.validateProviderConfigRequest(ruleData);
        HashMap<String, Long> uidMap = new HashMap<String, Long>();
        Object initiatorRuleID = ActivityConfigHandler.addNewActivityRule(initiatorJSON.getJSONObject("RULE_DATA"), userID, defaultRuleCategory, uidMap, dataObject);
        Object terminatorRuleID = ActivityConfigHandler.addNewActivityRule(terminatorJSON.getJSONObject("RULE_DATA"), userID, defaultRuleCategory, uidMap, dataObject);
        Row corrRuleInfo = new Row("CorrRuleInfo");
        corrRuleInfo.set("CATEGORY_ID", (Object)defaultRuleCategory);
        corrRuleInfo.set("AUTHOR", (Object)userID);
        corrRuleInfo.set("RULE_DISPLAY_NAME", (Object)UUID.randomUUID().toString());
        corrRuleInfo.set("IS_EDITABLE", (Object)Boolean.TRUE);
        corrRuleInfo.set("IS_SYSTEMGENERATED", (Object)Boolean.FALSE);
        corrRuleInfo.set("STATUS", (Object)CorrelationStatus.ENABLE.getValue());
        corrRuleInfo.set("TYPE", (Object)2);
        corrRuleInfo.set("REPORT_ENABLED", (Object)Boolean.FALSE);
        dataObject.addRow(corrRuleInfo);
        JSONObject profileInfo = ruleInfo.getJSONObject("PROFILE");
        if (profileInfo.has("ID")) {
            profileID = profileInfo.getLong("ID");
        } else if (profileInfo.has("NAME")) {
            String profileName = profileInfo.getString("NAME").trim();
            Long returnedVal = ActivityUtil.getProfileIDIfAvailable(profileName, locale);
            if (returnedVal == -1L) {
                Row activityProfile = new Row("ActivityMonitorProfile");
                activityProfile.set("DISPLAY_NAME", (Object)profileName);
                activityProfile.set("IS_EDITABLE", (Object)Boolean.TRUE);
                activityProfile.set("IS_SYSTEMGENERATED", (Object)Boolean.FALSE);
                activityProfile.set("STATUS", (Object)1L);
                profileID = activityProfile.get("PROFILE_ID");
                dataObject.addRow(activityProfile);
            } else {
                profileID = returnedVal;
            }
        } else {
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
        String description = ruleInfo.optString("DESCRIPTION").trim();
        Row providerInfo = new Row("ActivityRuleProviders");
        providerInfo.set("PROFILE_ID", profileID);
        providerInfo.set("DISPLAY_NAME", (Object)ruleInfo.getString("DISPLAY_NAME").trim());
        providerInfo.set("DESCRIPTION", (Object)description);
        providerInfo.set("IS_EDITABLE", (Object)Boolean.TRUE);
        providerInfo.set("IS_SYSTEMGENERATED", (Object)Boolean.FALSE);
        providerInfo.set("STATUS", (Object)CorrelationStatus.ENABLE.getValue());
        providerInfo.set("RULE_ID", corrRuleInfo.get("RULE_ID"));
        dataObject.addRow(providerInfo);
        Long initPrimaryActionConfigID = ActivityConfigHandler.findPrimaryActionID(uidMap, initiatorJSON.getJSONObject("RULE_DATA").getJSONArray("ACTIONS"));
        Long termPrimaryActionConfigID = ActivityConfigHandler.findPrimaryActionID(uidMap, terminatorJSON.getJSONObject("RULE_DATA").getJSONArray("ACTIONS"));
        Row initiatorInfo = new Row("ActivityInitiatorInfo");
        initiatorInfo.set("PROVIDER_ID", providerInfo.get("PROVIDER_ID"));
        initiatorInfo.set("RULE_ID", initiatorRuleID);
        initiatorInfo.set("PRIMARY_ACTIONID", (Object)initPrimaryActionConfigID);
        dataObject.addRow(initiatorInfo);
        Row terminatorInfo = new Row("ActivityTerminatorInfo");
        terminatorInfo.set("PROVIDER_ID", providerInfo.get("PROVIDER_ID"));
        terminatorInfo.set("RULE_ID", terminatorRuleID);
        terminatorInfo.set("PRIMARY_ACTIONID", (Object)termPrimaryActionConfigID);
        dataObject.addRow(terminatorInfo);
        JSONArray jsonArray = ruleData.getJSONArray("SHARED_FIELDS");
        HashMap<Long, Long> sharedFieldSet = new HashMap<Long, Long>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            Row linkedField = new Row("ActivityRuleLinkedFields");
            JSONObject sharedFieldEntry = jsonArray.getJSONObject(i);
            Long initField = sharedFieldEntry.getLong("INIT_FIELD_ID");
            Long termField = sharedFieldEntry.getLong("TERM_FIELD_ID");
            linkedField.set("PROVIDER_ID", providerInfo.get("PROVIDER_ID"));
            linkedField.set("INIT_FIELD_ID", (Object)sharedFieldEntry.getLong("INIT_FIELD_ID"));
            linkedField.set("TERM_FIELD_ID", (Object)sharedFieldEntry.getLong("TERM_FIELD_ID"));
            dataObject.addRow(linkedField);
            Row activitySharedFieldStatus = new Row("ActivitySharedFieldStatus");
            activitySharedFieldStatus.set("LINKED_FIELD_ID", linkedField.get("LINKED_FIELD_ID"));
            activitySharedFieldStatus.set("STATUS", (Object)Boolean.TRUE);
            dataObject.addRow(activitySharedFieldStatus);
            sharedFieldSet.put(initField, termField);
        }
        dataObject.merge(ActivityConfigHandler.fetchSharedFieldData("NoSqlIndexFields_INIT", sharedFieldSet.keySet()));
        dataObject.merge(ActivityConfigHandler.fetchSharedFieldData("NoSqlIndexFields_TERN", sharedFieldSet.values()));
        dataObject.merge(ActivityConfigHandler.addActivityTableViewData(dataObject, sharedFieldSet, initiatorRuleID, providerInfo.get("PROVIDER_ID"), initiatorJSON.getLong("PRIMARY_ACTION_ID")));
        PersistenceDBUtil.getPersistence().update(dataObject);
    }

    private static Long findPrimaryActionID(Map<String, Long> uidMap, JSONArray actionData) throws JSONException, BaseStatusCode {
        for (int i = 0; i < actionData.length(); ++i) {
            JSONObject entry = (JSONObject)actionData.get(i);
            if (!entry.getBoolean("IS_PRIMARY")) continue;
            if (entry.has("CONFIG_ID")) {
                return entry.getLong("CONFIG_ID");
            }
            String uid = entry.getString("ACTION_UID");
            return uidMap.get(uid);
        }
        throw BaseStatusCode.getBaseStatusCode(7428);
    }

    private static Long updateProfile(JSONObject profileData, Locale locale, DataObject dataObject) throws Exception {
        Long profileID;
        if (profileData.has("ID")) {
            profileID = profileData.getLong("ID");
        } else if (profileData.has("NAME")) {
            String profileName = profileData.getString("NAME").trim();
            Long returnedVal = ActivityUtil.getProfileIDIfAvailable(profileName, locale);
            if (returnedVal == -1L) {
                Row activityProfile = new Row("ActivityMonitorProfile");
                activityProfile.set("DISPLAY_NAME", (Object)profileName);
                activityProfile.set("IS_EDITABLE", (Object)Boolean.TRUE);
                activityProfile.set("IS_SYSTEMGENERATED", (Object)Boolean.FALSE);
                activityProfile.set("STATUS", (Object)1L);
                DataAccess.generateValues((Row)activityProfile);
                profileID = (Long)activityProfile.get("PROFILE_ID");
                dataObject.addRow(activityProfile);
            } else {
                profileID = returnedVal;
            }
        } else {
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
        return profileID;
    }

    private static DataObject addActivityTableViewData(DataObject dataObject, Map<Long, Long> sharedFieldSet, Object initiatorRuleID, Object providerID, Long actionID) throws DataAccessException {
        int count = 0;
        DataObject toInsert = PersistenceDBUtil.getPersistence().constructDataObject();
        DataObject actionInfo = ActivityConfigHandler.fetchActionData(actionID, sharedFieldSet);
        if (!dataObject.containsTable("CorrConfiguredActions")) {
            dataObject.merge(ActivityConfigHandler.fetchActionData(initiatorRuleID));
        }
        for (Long field : sharedFieldSet.keySet()) {
            Criteria criteria = new Criteria(Column.getColumn((String)"CorrConfiguredActions", (String)"RULE_ID"), initiatorRuleID, 0).and(new Criteria(Column.getColumn((String)"CorrConfiguredActions", (String)"ACTION_ID"), (Object)actionID, 0));
            Row configAction = dataObject.getRow("CorrConfiguredActions", criteria);
            criteria = new Criteria(Column.getColumn((String)"CorrActionCondnFields", (String)"ACTION_ID"), (Object)actionID, 0).and(new Criteria(Column.getColumn((String)"CorrActionCondnFields", (String)"CONDN_FIELD_ID"), (Object)field, 0));
            Row actionCondnFields = actionInfo.getRow("CorrActionCondnFields", criteria);
            criteria = new Criteria(Column.getColumn((String)"NoSqlIndexFields_INIT", (String)"FIELD_ID"), (Object)field, 0);
            Row indexField = dataObject.getRow("NoSqlIndexFields_INIT", criteria);
            Row tableViewConfig = new Row("ActivityTableViewConfig");
            tableViewConfig.set("PROVIDER_ID", providerID);
            tableViewConfig.set("RULE_ID", initiatorRuleID);
            tableViewConfig.set("ACTION_CONFIG_ID", configAction.get("CONFIG_ID"));
            tableViewConfig.set("FIELD_CONFIG_ID", actionCondnFields.get("FIELD_CONFIG_ID"));
            tableViewConfig.set("DISPLAY_NAME", indexField.get("FIELD_DISPLAY_NAME"));
            tableViewConfig.set("DISPLAY_TYPE", (Object)0);
            tableViewConfig.set("DISPLAY_ORDER", (Object)count);
            tableViewConfig.set("IS_RESOLVED", (Object)Boolean.TRUE);
            tableViewConfig.set("VISIBILITY", (Object)(count < 3 ? Boolean.TRUE : Boolean.FALSE));
            toInsert.addRow(tableViewConfig);
            ++count;
        }
        return toInsert;
    }

    private static DataObject fetchSharedFieldData(String tableName, Collection<Long> initFields) throws DataAccessException {
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"NoSqlIndexFields", (String)tableName));
        selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"FIELD_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"FIELD_INDEX_NAME"));
        selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"FIELD_DISPLAY_NAME"));
        selectQuery.setCriteria(new Criteria(Column.getColumn((String)tableName, (String)"FIELD_ID"), (Object)initFields.toArray(), 8));
        return PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
    }

    private static DataObject fetchActionData(Long actionID, Map<Long, Long> fieldIDs) throws DataAccessException {
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"CorrActionCondnFields"));
        selectQuery.addSelectColumn(Column.getColumn((String)"CorrActionCondnFields", (String)"ACTION_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"CorrActionCondnFields", (String)"CONDN_FIELD_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"CorrActionCondnFields", (String)"FIELD_CONFIG_ID"));
        Criteria criteria = new Criteria(Column.getColumn((String)"CorrActionCondnFields", (String)"ACTION_ID"), (Object)actionID, 0).and(new Criteria(Column.getColumn((String)"CorrActionCondnFields", (String)"CONDN_FIELD_ID"), (Object)fieldIDs.keySet().toArray(), 8));
        selectQuery.setCriteria(criteria);
        return PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
    }

    private static DataObject fetchActionData(Object ruleID) throws DataAccessException {
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"CorrConfiguredActions"));
        selectQuery.addSelectColumn(Column.getColumn((String)"CorrConfiguredActions", (String)"CONFIG_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"CorrConfiguredActions", (String)"RULE_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"CorrConfiguredActions", (String)"ACTION_ID"));
        Criteria criteria = new Criteria(Column.getColumn((String)"CorrConfiguredActions", (String)"RULE_ID"), ruleID, 0);
        selectQuery.setCriteria(criteria);
        return PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
    }

    private static DataObject fetchConfiguredActionData(Object[] dependentRules) throws DataAccessException {
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"CorrConfiguredActions"));
        selectQuery.addSelectColumn(Column.getColumn((String)"CorrConfiguredActions", (String)"RULE_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"CorrConfiguredActions", (String)"ACTION_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"CorrConfiguredActions", (String)"CONFIG_ID"));
        selectQuery.setCriteria(new Criteria(Column.getColumn((String)"CorrConfiguredActions", (String)"RULE_ID"), (Object)dependentRules, 8));
        return PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
    }

    private static Object addNewActivityRule(JSONObject jsonObject, Long userID, Long dCategory, Map<String, Long> uidMap, DataObject dataObject) throws BaseStatusCode {
        try {
            String ruleName = UUID.randomUUID().toString();
            Row ruleInfo = new Row("CorrRuleInfo");
            ruleInfo.set("CATEGORY_ID", (Object)dCategory);
            ruleInfo.set("AUTHOR", (Object)userID);
            ruleInfo.set("RULE_DISPLAY_NAME", (Object)ruleName);
            ruleInfo.set("DESCRIPTION", (Object)"Session Activity Rule");
            ruleInfo.set("IS_EDITABLE", (Object)Boolean.TRUE);
            ruleInfo.set("IS_SYSTEMGENERATED", (Object)Boolean.FALSE);
            ruleInfo.set("STATUS", (Object)CorrelationStatus.ENABLE.getValue());
            ruleInfo.set("TYPE", (Object)2);
            ruleInfo.set("REPORT_ENABLED", (Object)Boolean.FALSE);
            DataObject dobj = DataAccess.constructDataObject();
            dobj.addRow(ruleInfo);
            JSONArray actionConfig = jsonObject.getJSONArray("ACTIONS");
            JSONObject sharedLinkConfig = jsonObject.getJSONObject("SHARED_LINKS");
            CorrelationConfigHandler.fillActionConfigurations(actionConfig, sharedLinkConfig, uidMap, ruleInfo, dobj);
            CorrelationConfigHandler.fillAlertNotificationInfo(ruleName, userID, -1003L, ruleInfo.get("RULE_ID"), dobj);
            dataObject.append(dobj);
            return dobj.getFirstValue("CorrRuleInfo", "RULE_ID");
        }
        catch (Exception baseStatusCode) {
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
    }

    private static void addProviderRuleInfo(ActivityProviderInfo providerInfo, ActivityRuleType ruleType, JSONObject ruleData) throws JSONException, DataAccessException {
        ruleData.put("REPORT_ENABLED", false);
        ruleData.put("RULE_ID", (Object)(ruleType == ActivityRuleType.INITIATOR_RULE ? providerInfo.getInitiator().getRuleID() : providerInfo.getTerminator().getRuleID()));
        JSONObject category = new JSONObject();
        category.put("ID", (Object)ActivityUtil.getDefaultActivityRuleCategory());
        ruleData.put("CATEGORY", (Object)category);
        ruleData.put("RULE_NAME", (Object)UUID.randomUUID().toString());
    }

    private static Object getActionConfigID(Object ruleID, Object actionID, DataObject dataObject) throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"CorrConfiguredActions", (String)"ACTION_ID"), actionID, 0);
        criteria = criteria.and(new Criteria(Column.getColumn((String)"CorrConfiguredActions", (String)"RULE_ID"), ruleID, 0));
        return dataObject.getValue("CorrConfiguredActions", "CONFIG_ID", criteria);
    }

    private static void handleRuleNotification(DataObject dataObject) throws DataAccessException, BaseStatusCode {
        Iterator rowIterator = dataObject.getRows("CorrNotificationMapping");
        while (rowIterator.hasNext()) {
            Row notifMapping = (Row)rowIterator.next();
            ActivityRuleController.postActivityAddCall((Long)notifMapping.get("RULE_ID"), (Long)notifMapping.get("NOTIFID"));
        }
    }

    public static void updateSelectedCols(JSONObject request, Locale locale) throws Exception {
        Long[] visibleColumns;
        Long[] hiddenColumns;
        TableUniqueIdentifier tableIdentifier = new TableUniqueIdentifier(request, locale);
        if (request.has("HIDDEN") && (hiddenColumns = JSONUtil.toLongArray(request.getJSONArray("HIDDEN"))).length > 0) {
            ActivityConfigHandler.updateTableDisplayColumn(hiddenColumns, Boolean.FALSE);
        }
        if (request.has("VISIBLE") && (visibleColumns = JSONUtil.toLongArray(request.getJSONArray("VISIBLE"))).length > 0) {
            ActivityConfigHandler.updateTableDisplayColumn(visibleColumns, Boolean.TRUE);
        }
        ClientTableStructure.removeTableStructureFromCache(tableIdentifier.getUniqueId());
        MultiColumnJRXMLGenerator.removeJRXMLCache(tableIdentifier);
    }

    private static void updateTableDisplayColumn(Long[] columnConfigIDs, Boolean displayType) throws Exception {
        UpdateQueryImpl updateQuery = new UpdateQueryImpl("ActivityTableViewConfig");
        Criteria criteria = new Criteria(Column.getColumn((String)"ActivityTableViewConfig", (String)"TABLE_VIEW_ID"), (Object)columnConfigIDs, 8);
        updateQuery.setCriteria(criteria);
        updateQuery.setUpdateColumn("VISIBILITY", (Object)displayType);
        PersistenceDBUtil.getPersistence().update((UpdateQuery)updateQuery);
    }

    public static Map<Long, List<Long>> resolveArray(JSONArray array) throws JSONException {
        HashMap<Long, List<Long>> map = new HashMap<Long, List<Long>>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject activity = array.getJSONObject(i);
            Long profileID = activity.getLong("PROFILE_ID");
            Long providerID = activity.getLong("PROVIDER_ID");
            List list = map.computeIfAbsent(profileID, k -> new ArrayList());
            list.add(providerID);
        }
        return map;
    }

    private static void validateProviderConfigRequest(JSONObject request) throws BaseStatusCode, JSONException {
        JSONArray jsonArray = request.getJSONArray("SHARED_FIELDS");
        if (jsonArray.length() <= 0) {
            throw BaseStatusCode.getBaseStatusCode(16392);
        }
        String description = request.getJSONObject("RULE_INFO").optString("DESCRIPTION").trim();
        if (description.length() >= 255) {
            throw BaseStatusCode.getBaseStatusCode(16393);
        }
    }
}

