/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.config;

import com.manageengine.ela.server.correlation.session.info.ActivityProfileInfo;
import com.manageengine.ela.server.correlation.session.info.ActivityProviderInfo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ActivityConfigMapping {
    private static final Logger LOGGER = Logger.getLogger(ActivityConfigMapping.class.getName());
    private static final ActivityConfigMapping INSTANCE = new ActivityConfigMapping();
    private Map<Long, Long> ruleProviderMap = new ConcurrentHashMap<Long, Long>();
    private Map<Long, Long> providerProfileMap = new ConcurrentHashMap<Long, Long>();

    private ActivityConfigMapping() {
    }

    public static ActivityConfigMapping get() {
        return INSTANCE;
    }

    public void insertMapping(ActivityProfileInfo profileInfo) {
        for (ActivityProviderInfo providerInfo : profileInfo.getProvidersList()) {
            this.insertMapping(profileInfo.getID(), providerInfo);
        }
    }

    public void insertMapping(Long actID, ActivityProviderInfo providerInfo) {
        this.ruleProviderMap.put(providerInfo.getRuleID(), providerInfo.getID());
        this.providerProfileMap.put(providerInfo.getID(), actID);
        LOGGER.log(Level.INFO, "Mapping has been registered for provider {0}", providerInfo.getID());
    }

    public void removeMapping(ActivityProfileInfo profileInfo) {
        for (ActivityProviderInfo providerInfo : profileInfo.getProvidersList()) {
            this.removeMapping(providerInfo);
        }
    }

    public void removeMapping(ActivityProviderInfo providerInfo) {
        this.ruleProviderMap.remove(providerInfo.getRuleID());
        this.providerProfileMap.remove(providerInfo.getID());
        LOGGER.log(Level.INFO, "Mapping has been removed for provider {0}", providerInfo.getID());
    }

    public Long getProviderFromRule(Long ruleID) {
        if (this.ruleProviderMap.containsKey(ruleID)) {
            return this.ruleProviderMap.get(ruleID);
        }
        LOGGER.log(Level.WARNING, "[Invalid] No provider registered with the given ruleID {0}", ruleID);
        return null;
    }

    public Long getProfileID(Long providerID) {
        if (this.providerProfileMap.containsKey(providerID)) {
            return this.providerProfileMap.get(providerID);
        }
        LOGGER.log(Level.WARNING, "[Invalid] No provider - profile mapping exists for provider {0}", providerID);
        return null;
    }
}

