/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.config;

import com.manageengine.ela.server.correlation.core.constants.CorrelationStatus;
import com.manageengine.ela.server.correlation.session.config.ActivityConfigMapping;
import com.manageengine.ela.server.correlation.session.config.ActivityRuleController;
import com.manageengine.ela.server.correlation.session.info.ActivityProfileInfo;
import com.manageengine.ela.server.correlation.session.info.ActivityProviderInfo;
import com.manageengine.ela.server.correlation.session.listener.ActivityBreaker;
import com.manageengine.ela.server.correlation.session.listener.ActivityInitiator;
import com.manageengine.ela.server.correlation.session.listener.ActivityTerminator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ActivityProfileContainer {
    private static final Logger LOGGER = Logger.getLogger(ActivityProfileContainer.class.getName());
    private static final ActivityProfileContainer INSTANCE;
    private static final Map<Long, ActivityProfileInfo> CONFIGUREDPROFILEINFO;
    private static final Lock SYNC;

    private ActivityProfileContainer() {
    }

    public static ActivityProfileContainer get() {
        return INSTANCE;
    }

    public static void load(ActivityProfileInfo profileInfo, CorrelationStatus status) {
        SYNC.lock();
        try {
            CONFIGUREDPROFILEINFO.put(profileInfo.getID(), profileInfo);
            if (status == CorrelationStatus.ENABLE) {
                ActivityInitiator.addOrUpdate(profileInfo);
                ActivityTerminator.addOrUpdate(profileInfo);
                ActivityBreaker.addOrUpdate(profileInfo);
            }
            ActivityRuleController.initializeCorrelationRules(profileInfo, status);
            ActivityConfigMapping.get().insertMapping(profileInfo);
        }
        finally {
            SYNC.unlock();
        }
    }

    public static void unload(Long activityID) {
        SYNC.lock();
        try {
            ActivityProfileInfo activityProfileInfo = CONFIGUREDPROFILEINFO.remove(activityID);
            if (activityProfileInfo != null) {
                ActivityInitiator.remove(activityProfileInfo);
                ActivityTerminator.remove(activityProfileInfo);
                ActivityBreaker.remove(activityProfileInfo);
                activityProfileInfo.getProvidersList().forEach(ActivityRuleController::unloadCorrelationRules);
                ActivityConfigMapping.get().removeMapping(activityProfileInfo);
            }
        }
        finally {
            SYNC.unlock();
        }
    }

    public static void enable(Long activityID) {
        SYNC.lock();
        try {
            ActivityProfileInfo activityProfileInfo = CONFIGUREDPROFILEINFO.get(activityID);
            if (activityProfileInfo != null) {
                ActivityInitiator.addOrUpdate(activityProfileInfo);
                ActivityTerminator.addOrUpdate(activityProfileInfo);
                ActivityBreaker.addOrUpdate(activityProfileInfo);
                activityProfileInfo.getProvidersList().forEach(ActivityRuleController::enableCorrelationRules);
            }
        }
        finally {
            SYNC.unlock();
        }
    }

    public static void disable(Long activityID) {
        SYNC.lock();
        try {
            ActivityProfileInfo activityProfileInfo = CONFIGUREDPROFILEINFO.get(activityID);
            if (activityProfileInfo != null) {
                ActivityInitiator.remove(activityProfileInfo);
                ActivityTerminator.remove(activityProfileInfo);
                ActivityBreaker.remove(activityProfileInfo);
                activityProfileInfo.getProvidersList().forEach(ActivityRuleController::disableCorrelationRules);
            }
        }
        finally {
            SYNC.unlock();
        }
    }

    public ActivityProfileInfo getProfileInfo(Long activityID) {
        if (!CONFIGUREDPROFILEINFO.containsKey(activityID)) {
            LOGGER.log(Level.WARNING, "[Invalid] No Provider found for profile = {0}", new Object[]{activityID});
            return null;
        }
        return CONFIGUREDPROFILEINFO.get(activityID);
    }

    public boolean isProfileLoaded(Long activityID) {
        return CONFIGUREDPROFILEINFO.containsKey(activityID);
    }

    public ActivityProviderInfo getProviderInfo(Long activityID, Long providerID) {
        if (!CONFIGUREDPROFILEINFO.containsKey(activityID)) {
            LOGGER.log(Level.WARNING, "[Invalid] No Provider found for profile = {0}", new Object[]{activityID});
            return null;
        }
        ActivityProviderInfo providerInfo = this.getProfileInfo(activityID).getProviderInfo(providerID);
        if (providerInfo == null) {
            LOGGER.log(Level.WARNING, "[Invalid] No Provider found for profile = {0} and provider = {1}", new Object[]{activityID, providerID});
        }
        return providerInfo;
    }

    Lock getLock() {
        return SYNC;
    }

    @Deprecated
    public Map<Long, ActivityProfileInfo> getProfileMap() {
        return CONFIGUREDPROFILEINFO;
    }

    static {
        SYNC = new ReentrantLock(true);
        INSTANCE = new ActivityProfileContainer();
        CONFIGUREDPROFILEINFO = new HashMap<Long, ActivityProfileInfo>();
    }
}

