/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.config;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.correlation.core.constants.CorrelationStatus;
import com.manageengine.ela.server.correlation.session.config.ActivityConfigMapping;
import com.manageengine.ela.server.correlation.session.config.ActivityProfileContainer;
import com.manageengine.ela.server.correlation.session.config.ActivityRuleController;
import com.manageengine.ela.server.correlation.session.info.ActivityProfileInfo;
import com.manageengine.ela.server.correlation.session.info.ActivityProviderInfo;
import com.manageengine.ela.server.correlation.session.listener.ActivityBreaker;
import com.manageengine.ela.server.correlation.session.listener.ActivityInitiator;
import com.manageengine.ela.server.correlation.session.listener.ActivityTerminator;
import java.util.concurrent.locks.Lock;
import java.util.logging.Logger;

public class ActivityProviderController {
    private static final Logger LOGGER = Logger.getLogger(ActivityProviderController.class.getName());
    private static final ActivityProviderController INSTANCE = new ActivityProviderController();
    private static final Lock SYNC;
    private static final ActivityProfileContainer PROF_CONTAINER;

    public static ActivityProviderController get() {
        return INSTANCE;
    }

    public static void load(Long activityID, ActivityProviderInfo providerInfo, CorrelationStatus status) {
        SYNC.lock();
        try {
            if (!PROF_CONTAINER.isProfileLoaded(activityID)) {
                ActivityProfileContainer.load(new ActivityProfileInfo(activityID), CorrelationStatus.ENABLE);
            }
            PROF_CONTAINER.getProfileInfo(activityID).addProvider(providerInfo);
            if (status == CorrelationStatus.ENABLE) {
                ActivityInitiator.addOrUpdate(activityID, providerInfo);
                ActivityTerminator.addOrUpdate(activityID, providerInfo);
                ActivityBreaker.addOrUpdate(activityID, providerInfo);
                ActivityRuleController.initializeCorrelationRules(providerInfo, status);
            }
            ActivityConfigMapping.get().insertMapping(activityID, providerInfo);
        }
        finally {
            SYNC.unlock();
        }
    }

    public static void unload(Long activityID, Long providerID) throws BaseStatusCode {
        block4: {
            SYNC.lock();
            try {
                ActivityProviderInfo providerInfo = PROF_CONTAINER.getProviderInfo(activityID, providerID);
                if (providerInfo != null) {
                    ActivityInitiator.remove(activityID, providerInfo);
                    ActivityTerminator.remove(activityID, providerInfo);
                    ActivityBreaker.remove(activityID, providerInfo);
                    ActivityRuleController.unloadCorrelationRules(providerInfo);
                    ActivityConfigMapping.get().removeMapping(providerInfo);
                    break block4;
                }
                throw BaseStatusCode.getBaseStatusCode(16385);
            }
            finally {
                SYNC.unlock();
            }
        }
    }

    public static void enable(Long activityID, Long providerID) throws BaseStatusCode {
        block4: {
            SYNC.lock();
            try {
                ActivityProviderInfo providerInfo = PROF_CONTAINER.getProviderInfo(activityID, providerID);
                if (providerInfo != null) {
                    ActivityInitiator.addOrUpdate(activityID, providerInfo);
                    ActivityTerminator.addOrUpdate(activityID, providerInfo);
                    ActivityBreaker.addOrUpdate(activityID, providerInfo);
                    ActivityRuleController.enableCorrelationRules(providerInfo);
                    break block4;
                }
                throw BaseStatusCode.getBaseStatusCode(16385);
            }
            finally {
                SYNC.unlock();
            }
        }
    }

    public static void disable(Long activityID, Long providerID) throws BaseStatusCode {
        block4: {
            SYNC.lock();
            try {
                ActivityProviderInfo providerInfo = PROF_CONTAINER.getProviderInfo(activityID, providerID);
                if (providerInfo != null) {
                    ActivityInitiator.remove(activityID, providerInfo);
                    ActivityTerminator.remove(activityID, providerInfo);
                    ActivityBreaker.remove(activityID, providerInfo);
                    ActivityRuleController.disableCorrelationRules(providerInfo);
                    break block4;
                }
                throw BaseStatusCode.getBaseStatusCode(16385);
            }
            finally {
                SYNC.unlock();
            }
        }
    }

    public static void delete(Long activityID, Long providerID) throws Exception {
        ActivityProviderInfo providerInfo = PROF_CONTAINER.getProfileInfo(activityID).removeProvider(providerID);
        if (providerInfo == null) {
            throw BaseStatusCode.getBaseStatusCode(16385);
        }
        Criteria deleteCriteria = new Criteria(Column.getColumn((String)"ActivityRuleProviders", (String)"PROVIDER_ID"), (Object)providerID, 0);
        DBUtil.deleteExistingRows("ActivityRuleProviders", deleteCriteria, new boolean[0]);
        ActivityRuleController.deleteCorrelationRules(providerInfo);
        ActivityConfigMapping.get().removeMapping(providerInfo);
    }

    static {
        PROF_CONTAINER = ActivityProfileContainer.get();
        SYNC = PROF_CONTAINER.getLock();
    }
}

