/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.config;

import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.sa.server.nf.NotificationManager;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.correlation.config.CorrelationConfigHandler;
import com.manageengine.ela.server.correlation.config.CorrelationRuleHandler;
import com.manageengine.ela.server.correlation.core.CorrelationRuleContainer;
import com.manageengine.ela.server.correlation.core.builder.CorrelationBuilder;
import com.manageengine.ela.server.correlation.core.constants.CorrelationStatus;
import com.manageengine.ela.server.correlation.session.config.ActivityProviderController;
import com.manageengine.ela.server.correlation.session.info.ActivityBreakerInfo;
import com.manageengine.ela.server.correlation.session.info.ActivityInitiatorInfo;
import com.manageengine.ela.server.correlation.session.info.ActivityProfileInfo;
import com.manageengine.ela.server.correlation.session.info.ActivityProviderInfo;
import com.manageengine.ela.server.correlation.session.info.ActivityTerminatorInfo;
import com.manageengine.ela.server.correlation.session.listener.ActivityBreaker;
import com.manageengine.ela.server.correlation.session.listener.ActivityInitiator;
import com.manageengine.ela.server.correlation.session.listener.ActivityTerminator;
import com.manageengine.ela.server.correlation.util.CorrelationUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class ActivityRuleController {
    private static final Logger LOGGER = Logger.getLogger(ActivityRuleController.class.getName());

    ActivityRuleController() {
    }

    public static void unloadCorrelationRules(ActivityProviderInfo providerInfo) {
        Set<Long> ruleSet = ActivityRuleController.getRuleIDList(providerInfo);
        ruleSet.forEach(ruleID -> {
            if (!ActivityRuleController.isRuleInUse(ruleID)) {
                CorrelationRuleContainer.unload(ruleID);
            }
        });
    }

    public static void enableCorrelationRules(ActivityProviderInfo providerInfo) {
        Set<Long> ruleSet = ActivityRuleController.getRuleIDList(providerInfo);
        ruleSet.forEach(ruleID -> CorrelationRuleContainer.enable(ruleID));
    }

    public static void disableCorrelationRules(ActivityProviderInfo providerInfo) {
        Set<Long> ruleSet = ActivityRuleController.getRuleIDList(providerInfo);
        ruleSet.forEach(ruleID -> {
            if (!ActivityRuleController.isRuleInUse(ruleID)) {
                CorrelationRuleContainer.disable(ruleID);
            }
        });
    }

    public static void deleteCorrelationRules(ActivityProviderInfo providerInfo) throws Exception {
        Set<Long> ruleSet = ActivityRuleController.getRuleIDList(providerInfo);
        ruleSet.add(providerInfo.getRuleID());
        for (Long ruleID : ruleSet) {
            if (ActivityRuleController.isRuleInUse(ruleID)) continue;
            CorrelationConfigHandler.deleteCorrelationRule(ruleID);
        }
    }

    public static void initializeCorrelationRules(ActivityProfileInfo profileInfo, CorrelationStatus profileStatus) {
        Set<Long> ruleSet = ActivityRuleController.getRuleIDList(profileInfo);
        try {
            DataObject dataObject = CorrelationUtil.getCompleteCorrelationRuleActionNotifData(2, ruleSet.toArray(new Long[ruleSet.size()]));
            CorrelationBuilder builder = CorrelationBuilder.create().setDataContainer(dataObject);
            for (ActivityProviderInfo provider : profileInfo.getProvidersList()) {
                ActivityRuleController.initRules(provider, builder, profileStatus);
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.INFO, "Error occurred during profile initialization - {0}", profileInfo.getID());
        }
    }

    public static void postActivityAddCall(Long ruleID, Long notifID) throws BaseStatusCode, DataAccessException {
        NotificationManager.getInstance().changeProfNotificationStatus(notifID, false);
        List<Long> notifIDList = CorrelationRuleHandler.analyzeRuleNotifIDStatus(1, ruleID);
        CorrelationRuleHandler.updateNotifActionStatus(notifIDList, true);
    }

    public static void postActivityModificationCall(Long profileID, ActivityProviderInfo providerInfo) throws Exception {
        CorrelationRuleHandler.postRuleEnableDisableCall(CorrelationStatus.ENABLE, providerInfo.getInitiator().getRuleID(), providerInfo.getTerminator().getRuleID());
        ActivityProviderController.load(profileID, providerInfo, CorrelationStatus.ENABLE);
    }

    public static void initializeCorrelationRules(ActivityProviderInfo provider, CorrelationStatus status) {
        Set<Long> ruleSet = ActivityRuleController.getRuleIDList(provider);
        try {
            DataObject dataObject = CorrelationUtil.getCompleteCorrelationRuleActionNotifData(2, ruleSet.toArray(new Long[ruleSet.size()]));
            CorrelationBuilder builder = CorrelationBuilder.create().setDataContainer(dataObject);
            ActivityRuleController.initRules(provider, builder, status);
        }
        catch (Exception exp) {
            LOGGER.log(Level.INFO, "Error occurred during provider initialization - {0}", provider.getID());
        }
    }

    private static void initRules(ActivityProviderInfo provider, CorrelationBuilder builder, CorrelationStatus status) {
        CorrelationStatus providerStatus = status == CorrelationStatus.ENABLE && provider.getStatus() == CorrelationStatus.ENABLE ? CorrelationStatus.ENABLE : CorrelationStatus.DISABLE;
        ActivityInitiatorInfo activityInitiatorInfo = provider.getInitiator();
        ActivityTerminatorInfo activityTerminatorInfo = provider.getTerminator();
        ActivityBreakerInfo activityBreakerInfo = provider.getBreaker();
        try {
            builder.setIdentity(activityInitiatorInfo.getRuleID()).setCallBack(ActivityInitiator.create()).setStatus(providerStatus).build();
            builder.setIdentity(activityTerminatorInfo.getRuleID()).setCallBack(ActivityTerminator.create()).setStatus(providerStatus).build();
            if (activityBreakerInfo != null) {
                builder.setIdentity(activityBreakerInfo.getRuleID()).setCallBack(ActivityBreaker.create()).setStatus(providerStatus).build();
            }
        }
        catch (Exception exp) {
            ActivityRuleController.unloadCorrelationRules(provider);
            LOGGER.log(Level.INFO, "Unable to initializeProvider correlation rule for provider - {0}", provider.getID());
            exp.printStackTrace();
        }
    }

    private static Set<Long> getRuleIDList(ActivityProfileInfo profileInfo) {
        HashSet<Long> ruleIDList = new HashSet<Long>();
        for (ActivityProviderInfo provider : profileInfo.getProvidersList()) {
            ruleIDList.addAll(ActivityRuleController.getRuleIDList(provider));
        }
        return ruleIDList;
    }

    private static Set<Long> getRuleIDList(ActivityProviderInfo providerInfo) {
        HashSet<Long> rules = new HashSet<Long>();
        rules.add(providerInfo.getInitiator().getRuleID());
        rules.add(providerInfo.getTerminator().getRuleID());
        if (providerInfo.getBreaker() != null) {
            rules.add(providerInfo.getBreaker().getRuleID());
        }
        return rules;
    }

    public static boolean isRuleInUse(Long ruleID) {
        return ActivityInitiator.isRuleInUse(ruleID) != false || ActivityTerminator.isRuleInUse(ruleID) != false || ActivityBreaker.isRuleInUse(ruleID) != false;
    }
}

