/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.data;

import com.manageengine.ela.server.correlation.common.data.PreProcessDataHandler;
import com.manageengine.ela.server.correlation.core.constants.ActionType;
import com.manageengine.ela.server.correlation.core.criteria.ActionDelimiter;
import com.manageengine.ela.server.correlation.core.criteria.UniqueFieldChain;
import com.manageengine.ela.server.correlation.core.data.FieldDataContainer;
import com.manageengine.ela.server.correlation.session.constants.ActivityRuleType;
import com.manageengine.ela.server.correlation.session.data.ActivityDataHelper;
import com.manageengine.ela.server.correlation.session.info.ActivityProviderInfo;
import com.manageengine.ela.server.correlation.session.util.ActivityUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ActPreProcessDataHandler
implements PreProcessDataHandler {
    private static final Logger LOGGER = Logger.getLogger(ActPreProcessDataHandler.class.getName());
    private final Long providerRuleID;
    private final List<Long> actions;
    private final Map<Long, FieldDataContainer> originalContainer;
    private final Map<Long, Integer> actionTypeMap;
    private final Map<Long, UniqueFieldChain> uniqueMap;
    private final Map<Long, Map<String, List<Map.Entry<Long, String>>>> sharedRefMap;

    public ActPreProcessDataHandler(Long providerID, Set<Long> actionSet, Map<Long, FieldDataContainer> originalContainer, ActivityRuleType ruleType) {
        this.providerRuleID = providerID;
        this.originalContainer = originalContainer;
        this.actions = new ArrayList<Long>(actionSet);
        this.uniqueMap = new HashMap<Long, UniqueFieldChain>();
        this.actionTypeMap = new HashMap<Long, Integer>();
        this.sharedRefMap = new HashMap<Long, Map<String, List<Map.Entry<Long, String>>>>();
        this.prepareData(ruleType);
    }

    private void prepareData(ActivityRuleType ruleType) {
        for (Long actionID : this.originalContainer.keySet()) {
            ActivityProviderInfo providerInfo = ActivityUtil.getProviderInfoByRuleID(this.providerRuleID);
            if (providerInfo != null) {
                if (ruleType == ActivityRuleType.INIT_TERMINATOR_RULE) {
                    this.sharedRefMap.putAll(ActivityDataHelper.prepareSharedFieldMap(providerInfo.getLinkedFields(), providerInfo.getInitiator().getRuleID(), providerInfo.getTerminator().getRuleID()));
                } else if (ruleType == ActivityRuleType.INIT_BREAKER_RULE) {
                    this.sharedRefMap.putAll(ActivityDataHelper.prepareSharedFieldMap(providerInfo.getBreaker().getBreakerFields(), providerInfo.getInitiator().getRuleID(), providerInfo.getBreaker().getRuleID()));
                }
                this.actionTypeMap.put(actionID, ActionType.SHARED.getValue());
                continue;
            }
            LOGGER.log(Level.WARNING, "Invalid provider found.");
        }
    }

    @Override
    public Map<Long, FieldDataContainer> getOriginalContainer() {
        return this.originalContainer;
    }

    @Override
    public Map<String, List<Map.Entry<Long, String>>> getSharedFieldData(Long actionID) {
        return this.sharedRefMap.get(actionID);
    }

    @Override
    public UniqueFieldChain getUniqueFieldChain(Long actionID) {
        return this.uniqueMap.get(actionID);
    }

    @Override
    public ActionDelimiter getActionDelimiter(Long actionID) {
        return null;
    }

    @Override
    public List<Long> getActionList() {
        return this.actions;
    }

    @Override
    public Integer getActionType(Long actionID) {
        return this.actionTypeMap.get(actionID);
    }
}

