/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.data;

import com.google.common.collect.ImmutableMap;
import com.manageengine.ela.server.correlation.core.analyzer.AnalyzerInput;
import com.manageengine.ela.server.correlation.core.analyzer.selector.FieldSelector;
import com.manageengine.ela.server.correlation.core.criteria.CrossActionChain;
import com.manageengine.ela.server.correlation.core.data.DataStore;
import com.manageengine.ela.server.correlation.core.data.FieldDataContainer;
import com.manageengine.ela.server.correlation.core.data.ResponseContainer;
import com.manageengine.ela.server.correlation.core.data.SortedContainer;
import com.manageengine.ela.server.correlation.session.info.ActivityProviderInfo;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public class ActivityDataHelper {
    public static FieldDataContainer prepareBreakerContainer(ActivityProviderInfo providerInfo, Long time, Map<String, Object> log, String docID) {
        Set<String> breakerFields = providerInfo.getBreaker().getBreakerRuleFields();
        Long id = providerInfo.getBreaker().getRuleID();
        DataStore dataStore = DataStore.getDataStore(id, new ReentrantLock(), providerInfo.getDataTimeLimit(), DataStore.StoreType.JAVAHEAP);
        FieldDataContainer container = new FieldDataContainer(dataStore, providerInfo.getTerminator().getRuleID(), breakerFields, providerInfo.getDataTimeLimit());
        for (String breakerField : breakerFields) {
            if (!log.containsKey(breakerField)) {
                return null;
            }
            String fieldVal = String.valueOf(log.get(breakerField));
            container.store(breakerField, fieldVal, time, docID);
        }
        return container;
    }

    public static AnalyzerInput prepareBreakerInput(ActivityProviderInfo providerInfo) {
        CrossActionChain chain = CrossActionChain.create(providerInfo.getInitiator().getRuleID(), null, 1);
        chain.add(providerInfo.getBreaker().getRuleID(), null, 1);
        return new AnalyzerInput(providerInfo.getRuleID(), chain, providerInfo.getContainer());
    }

    public static Map<Long, Map<Long, List<String>>> normalizeResponse(Long primaryActionID, Map<Long, ResponseContainer> response) {
        HashMap<Long, Map<Long, List<String>>> nonPrimaryDocMap = new HashMap<Long, Map<Long, List<String>>>();
        response.entrySet().stream().filter(entry -> ((Long)entry.getKey()).compareTo(primaryActionID) != 0).forEach(entry -> {
            ResponseContainer responseContainer = (ResponseContainer)entry.getValue();
            HashMap docMap = new HashMap();
            responseContainer.getSelectedData().forEach((time, limit) -> {
                ArrayList<String> docList = new ArrayList<String>();
                for (int i = 0; i < limit; ++i) {
                    docList.add(responseContainer.getOriginalContainer().get((Long)time).get(i));
                }
                docMap.put(time, docList);
            });
            nonPrimaryDocMap.put((Long)entry.getKey(), docMap);
        });
        return nonPrimaryDocMap;
    }

    public static Boolean checkLogCompatibility(Map<String, Object> rawLog, Set<String> sharedFields) {
        return sharedFields.stream().allMatch(rawLog::containsKey);
    }

    public static Map<Long, Map<String, List<Map.Entry<Long, String>>>> prepareSharedFieldMap(Map<String, String> sharedFields, Long initID, Long endID) {
        HashMap<String, List<AbstractMap.SimpleEntry<Long, String>>> initMap = new HashMap<String, List<AbstractMap.SimpleEntry<Long, String>>>();
        HashMap<String, List<AbstractMap.SimpleEntry<Long, String>>> endMap = new HashMap<String, List<AbstractMap.SimpleEntry<Long, String>>>();
        for (Map.Entry<String, String> entry : sharedFields.entrySet()) {
            String initField = entry.getKey();
            String endField = entry.getValue();
            initMap.put(initField, Collections.singletonList(new AbstractMap.SimpleEntry<Long, String>(endID, endField)));
            endMap.put(endField, Collections.singletonList(new AbstractMap.SimpleEntry<Long, String>(initID, initField)));
        }
        return ImmutableMap.of((Object)initID, initMap, (Object)endID, endMap);
    }

    public static Map<String, FieldSelector> prepareDependentFieldSelectors(ActivityProviderInfo providerInfo, Long containerID) {
        ConcurrentHashMap<String, FieldSelector> dependentMap = new ConcurrentHashMap<String, FieldSelector>();
        for (String sharedField : providerInfo.getInitLinkedFields()) {
            Map<String, SortedContainer> directMap = providerInfo.getContainer().getFieldDataContainer(containerID).getDirectMap().get(sharedField);
            if (directMap == null) continue;
            Set<String> sources = directMap.keySet();
            ConcurrentHashMap<String, SortedContainer> derivedMap = new ConcurrentHashMap<String, SortedContainer>();
            for (String source : sources) {
                SortedContainer original = directMap.get(source);
                SortedContainer container = SortedContainer.getCustomContainer(original.getDirectMap(), false, original.getDataMarker());
                derivedMap.put(source, container);
            }
            FieldSelector fieldSelector = new FieldSelector(providerInfo.getInitiator().getRuleID(), sources, derivedMap, null);
            dependentMap.put(sharedField, fieldSelector);
        }
        return dependentMap;
    }
}

