/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.data;

import com.manageengine.ela.server.correlation.session.constants.ActivityRuleType;
import java.util.Objects;

public class ActivityDocData {
    Long profileID;
    Long providerID;
    Long ruleID;
    Long time;
    String docID;
    Boolean isIndexUpdateNeeded;
    ActivityRuleType ruleType;

    public ActivityDocData(Long profileID, Long providerID, Long ruleID, Long time, ActivityRuleType ruleType, String docID) {
        this.profileID = Objects.requireNonNull(profileID);
        this.providerID = Objects.requireNonNull(providerID);
        this.ruleID = Objects.requireNonNull(ruleID);
        this.ruleType = Objects.requireNonNull(ruleType);
        this.time = Objects.requireNonNull(time);
        this.docID = Objects.requireNonNull(docID);
        this.isIndexUpdateNeeded = true;
    }

    public Long getProfileID() {
        return this.profileID;
    }

    public Long getProviderID() {
        return this.providerID;
    }

    public Long getRuleID() {
        return this.ruleID;
    }

    public ActivityRuleType getRuleType() {
        return this.ruleType;
    }

    public Long getTime() {
        return this.time;
    }

    public String getDocID() {
        return this.docID;
    }

    public boolean isIndexUpdateNeeded() {
        return this.isIndexUpdateNeeded != false && this.ruleType == ActivityRuleType.INITIATOR_RULE;
    }

    public void setIndexUpdateNeeded(Boolean reindexNeed) {
        this.isIndexUpdateNeeded = reindexNeed;
    }

    public String toString() {
        return "ActivityDocData{profileID=" + this.profileID + ", providerID=" + this.providerID + ", ruleID=" + this.ruleID + ", time=" + this.time + ", docID='" + this.docID + '\'' + ", isIndexUpdateNeeded=" + this.isIndexUpdateNeeded + ", ruleType=" + (Object)((Object)this.ruleType) + '}';
    }
}

