/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.data.cache;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataObject;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ActRuntimeCache {
    private static final Logger LOGGER = Logger.getLogger(ActRuntimeCache.class.getName());
    private static Long pmpMainActionConfigID;

    private static Long getPMPMainActionConfigID() {
        if (pmpMainActionConfigID == null) {
            try {
                SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ActivityInitiatorInfo"));
                selectQuery.addJoin(new Join("ActivityInitiatorInfo", "CorrConfiguredActions", new String[]{"RULE_ID"}, new String[]{"RULE_ID"}, 1));
                selectQuery.addSelectColumn(Column.getColumn((String)"ActivityInitiatorInfo", (String)"*"));
                selectQuery.addSelectColumn(Column.getColumn((String)"CorrConfiguredActions", (String)"*"));
                selectQuery.setCriteria(new Criteria(Column.getColumn((String)"CorrConfiguredActions", (String)"CONFIG_ORDER"), (Object)2, 0));
                DataObject dataObject = PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
                pmpMainActionConfigID = (Long)dataObject.getFirstValue("CorrConfiguredActions", "CONFIG_ID");
                return pmpMainActionConfigID;
            }
            catch (Exception exp) {
                LOGGER.log(Level.INFO, "Error occurred in runtime cache {0}", exp.getMessage());
                pmpMainActionConfigID = -1L;
            }
        }
        return pmpMainActionConfigID;
    }

    public static Long fetchValue(RuntimeConstants runtimeConstant) {
        switch (runtimeConstant) {
            case PMP_MAIN_ACTION_CONFIG_ID: {
                return ActRuntimeCache.getPMPMainActionConfigID();
            }
        }
        return -1L;
    }

    public static enum RuntimeConstants {
        PMP_MAIN_ACTION_CONFIG_ID;

    }
}

