/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.data.cache;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.manageengine.ela.server.correlation.core.config.CorrConfigInfo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ActivityHistoryDataHandler {
    private static final Logger LOGGER = Logger.getLogger(ActivityHistoryDataHandler.class.getName());
    private static final ActivityHistoryDataHandler INSTANCE = new ActivityHistoryDataHandler();
    private Map<Long, LoadingCache<String, Row>> historyMap = new ConcurrentHashMap<Long, LoadingCache<String, Row>>();

    private ActivityHistoryDataHandler() {
    }

    public static ActivityHistoryDataHandler getInstance() {
        return INSTANCE;
    }

    public void storeActivityHistoryData(Long providerID, String docID, Row row) {
        LoadingCache cache = this.historyMap.computeIfAbsent(providerID, k -> this.prepareLoadingCache(providerID));
        cache.put((Object)docID, (Object)this.prepareFreshRow(row));
    }

    public Row getActivityHistoryData(Long providerID, String initiatorDocID) {
        try {
            return (Row)this.historyMap.get(providerID).get((Object)initiatorDocID);
        }
        catch (Exception exp) {
            return this.fetchActivityHistoryFromDB(initiatorDocID, providerID);
        }
    }

    public Row getAndRemoveActivityHistoryData(Long providerID, String initiatorDocID) {
        try {
            Row hist = (Row)this.historyMap.get(providerID).get((Object)initiatorDocID);
            this.historyMap.get(providerID).invalidate((Object)initiatorDocID);
            return hist;
        }
        catch (Exception exp) {
            return this.fetchActivityHistoryFromDB(initiatorDocID, providerID);
        }
    }

    private LoadingCache<String, Row> prepareLoadingCache(final Long providerID) {
        return CacheBuilder.newBuilder().maximumSize(CorrConfigInfo.getDefault_activity_history_cache_entry_count()).build((CacheLoader)new CacheLoader<String, Row>(){

            public Row load(String docID) {
                return ActivityHistoryDataHandler.this.fetchActivityHistoryFromDB(docID, providerID);
            }
        });
    }

    private Row prepareFreshRow(Row parentRow) {
        try {
            DataAccess.generateValues((Row)parentRow);
        }
        catch (Exception exp) {
            LOGGER.log(Level.INFO, "Cant generate values for row {0}", exp.getMessage());
        }
        Row newRow = new Row("ActivityHistory");
        newRow.set("HISTORY_ID", parentRow.get("HISTORY_ID"));
        newRow.set("PROVIDER_ID", parentRow.get("PROVIDER_ID"));
        newRow.set("START_TIME", parentRow.get("START_TIME"));
        newRow.set("IS_PRIMARY", parentRow.get("IS_PRIMARY"));
        newRow.set("STATUS", parentRow.get("STATUS"));
        return newRow;
    }

    private Row fetchActivityHistoryFromDB(String docID, Long providerID) {
        LOGGER.log(Level.FINER, "No Cache hit. Loading history row from DB");
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ActivityInitiatorDocID"));
            query.addJoin(new Join("ActivityInitiatorDocID", "ActivityHistory", new String[]{"HISTORY_ID"}, new String[]{"HISTORY_ID"}, 1));
            query.addSelectColumn(Column.getColumn((String)"ActivityInitiatorDocID", (String)"UNIQUE_ID"));
            query.addSelectColumn(Column.getColumn((String)"ActivityInitiatorDocID", (String)"HISTORY_ID"));
            query.addSelectColumn(Column.getColumn((String)"ActivityInitiatorDocID", (String)"DOC_ID"));
            query.addSelectColumn(Column.getColumn((String)"ActivityHistory", (String)"*"));
            Criteria criteria = new Criteria(Column.getColumn((String)"ActivityInitiatorDocID", (String)"DOC_ID"), (Object)docID, 0).and(new Criteria(Column.getColumn((String)"ActivityHistory", (String)"PROVIDER_ID"), (Object)providerID, 0));
            query.setCriteria(criteria);
            DataObject dataObject = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
            if (dataObject.containsTable("ActivityHistory")) {
                return dataObject.getFirstRow("ActivityHistory");
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, "Cant fetch ROW in case of Cache miss in Activity history cache for docID {0}. Exception = {1}", new Object[]{docID, exp});
        }
        return null;
    }

    public void wipeHistory() {
        this.historyMap.forEach((providerID, loadingCache) -> loadingCache.cleanUp());
    }

    @Deprecated
    public Map<Long, LoadingCache<String, Row>> getHistoryMap() {
        return this.historyMap;
    }
}

